/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks;

import betterwithmods.BWRegistry;
import betterwithmods.blocks.BTWBlock;
import betterwithmods.blocks.BlockRope;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockAnchor
extends BTWBlock {
    public static final PropertyBool TOPCONNECT = PropertyBool.func_177716_a((String)"topconnect");
    public static final PropertyBool BOTTOMCONNECT = PropertyBool.func_177716_a((String)"bottomconnect");
    public static float height = 0.375f;

    public BlockAnchor() {
        super(Material.field_151576_e, "anchor");
        this.func_149711_c(2.0f);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        int facing = ((EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING)).func_176745_a();
        switch (facing) {
            case 0: {
                return new AxisAlignedBB(0.0, (double)(1.0f - height), 0.0, 1.0, 1.0, 1.0);
            }
            case 1: {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)height, 1.0);
            }
            case 2: {
                return new AxisAlignedBB(0.0, 0.0, (double)(1.0f - height), 1.0, 1.0, 1.0);
            }
            case 3: {
                return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)height);
            }
            case 4: {
                return new AxisAlignedBB((double)(1.0f - height), 0.0, 0.0, 1.0, 1.0, 1.0);
            }
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, (double)height, 1.0, 1.0);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase entity) {
        IBlockState state = super.func_180642_a(world, pos, side, flX, flY, flZ, meta, entity);
        return this.setFacingInBlock(state, side);
    }

    @Override
    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.func_177226_a((IProperty)DirUtils.FACING, (Comparable)facing);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack = heldItem;
        BlockPos down = pos.func_177977_b();
        if (stack != null) {
            Block block;
            if (stack.func_77973_b() instanceof ItemBlock && (block = ((ItemBlock)stack.func_77973_b()).func_179223_d()) == BWRegistry.rope) {
                if (!world.field_72995_K) {
                    if (world.func_180495_p(down).func_177230_c() == BWRegistry.rope) {
                        ((BlockRope)world.func_180495_p(down).func_177230_c()).placeRopeUnder(stack, world, down, player);
                    } else if (world.func_180495_p(down).func_177230_c().func_176200_f((IBlockAccess)world, down) || world.func_175623_d(down)) {
                        world.func_175656_a(down, BWRegistry.rope.func_176223_P());
                        if (!player.field_71075_bZ.field_75098_d) {
                            --stack.field_77994_a;
                        }
                    } else {
                        return false;
                    }
                }
                return true;
            }
            return false;
        }
        if (!world.field_72995_K) {
            this.retractRope(world, pos, player);
        }
        return true;
    }

    @Override
    public boolean canRotateOnTurntable(IBlockAccess world, BlockPos pos) {
        EnumFacing facing = this.getFacing(world, pos);
        return facing != EnumFacing.UP && facing != EnumFacing.DOWN;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        EnumFacing facing = this.getFacing(world, pos);
        return side == facing.func_176734_d();
    }

    @Override
    public EnumFacing getFacing(IBlockAccess world, BlockPos pos) {
        return (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)DirUtils.FACING);
    }

    private void retractRope(World world, BlockPos pos, EntityPlayer player) {
        for (int i = pos.func_177956_o() - 1; i >= 0; --i) {
            BlockPos pos2 = new BlockPos(pos.func_177958_n(), i, pos.func_177952_p());
            Block block = world.func_180495_p(pos2).func_177230_c();
            if (world.func_180495_p(pos2).func_177230_c() != BWRegistry.rope && world.func_180495_p(pos2.func_177984_a()).func_177230_c() == BWRegistry.rope) {
                if (!player.field_71075_bZ.field_75098_d) {
                    this.addRopeToInv(world, pos, player);
                }
                world.func_175698_g(pos2.func_177984_a());
                break;
            }
            if (world.func_180495_p(pos2).func_177230_c() != BWRegistry.rope) break;
        }
    }

    private void addRopeToInv(World world, BlockPos pos, EntityPlayer player) {
        ItemStack rope = new ItemStack(BWRegistry.rope);
        if (player.field_71071_by.func_70441_a(rope)) {
            world.func_184133_a(null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        } else {
            InvUtils.ejectStackWithOffset(world, pos, rope);
        }
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return entity instanceof EntityPlayer && world.func_180495_p(pos).func_177230_c() == this && world.func_180495_p(pos).func_177229_b((IProperty)DirUtils.FACING) != EnumFacing.DOWN;
    }

    private boolean isRope(IBlockAccess world, BlockPos origin, EnumFacing facing) {
        BlockPos pos = origin.func_177972_a(facing);
        return world.func_180495_p(pos).func_177230_c() == BWRegistry.rope;
    }

    private boolean isAnchor(IBlockAccess world, BlockPos origin, EnumFacing facing) {
        BlockPos pos = origin.func_177972_a(facing);
        return world.func_180495_p(pos).func_177230_c() == this && world.func_180495_p(pos).func_177229_b((IProperty)DirUtils.FACING) != facing;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean topRope = this.isRope(world, pos, EnumFacing.UP) || this.isAnchor(world, pos, EnumFacing.UP);
        boolean bottomRope = this.isRope(world, pos, EnumFacing.DOWN) || this.isAnchor(world, pos, EnumFacing.DOWN);
        return state.func_177226_a((IProperty)TOPCONNECT, (Comparable)Boolean.valueOf(topRope)).func_177226_a((IProperty)BOTTOMCONNECT, (Comparable)Boolean.valueOf(bottomRope));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)DirUtils.FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.FACING, TOPCONNECT, BOTTOMCONNECT});
    }
}

