/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks;

import betterwithmods.BWRegistry;
import betterwithmods.BWSounds;
import betterwithmods.api.block.IAxle;
import betterwithmods.api.block.IMechanical;
import betterwithmods.api.block.IMechanicalBlock;
import betterwithmods.blocks.BTWBlock;
import betterwithmods.util.InvUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAxle
extends BTWBlock
implements IMechanical,
IAxle {
    public static final PropertyInteger AXLEDIR = PropertyInteger.func_177719_a((String)"dir", (int)0, (int)2);
    public static final PropertyInteger SIGNAL = PropertyInteger.func_177719_a((String)"signal", (int)0, (int)4);
    public static final float width = 0.25f;
    public static final int tickRate = 1;
    public static final EnumFacing[][] facings = new EnumFacing[][]{{EnumFacing.UP, EnumFacing.DOWN}, {EnumFacing.NORTH, EnumFacing.SOUTH}, {EnumFacing.WEST, EnumFacing.EAST}};

    public BlockAxle() {
        super(Material.field_151575_d, "axle");
        this.func_149711_c(2.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)AXLEDIR, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)SIGNAL, (Comparable)Integer.valueOf(0)));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean emptyHands;
        boolean bl = emptyHands = player.func_184586_b(EnumHand.MAIN_HAND) == null && player.func_184586_b(EnumHand.OFF_HAND) == null;
        if (world.field_72995_K && emptyHands) {
            return true;
        }
        if (!world.field_72995_K && emptyHands) {
            int dir = (Integer)state.func_177229_b((IProperty)AXLEDIR) == 2 ? 0 : (Integer)state.func_177229_b((IProperty)AXLEDIR) + 1;
            world.func_184133_a(null, pos, this.func_185467_w().func_185841_e(), SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            world.func_175656_a(pos, state.func_177226_a((IProperty)SIGNAL, (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)AXLEDIR, (Comparable)Integer.valueOf(dir)));
            world.func_175685_c(pos, (Block)this);
            world.func_180497_b(pos, (Block)this, 10, 5);
            return true;
        }
        return false;
    }

    public int func_149738_a(World world) {
        return 1;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        int ori = (Integer)state.func_177229_b((IProperty)AXLEDIR);
        AxisAlignedBB axis = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
        switch (ori) {
            case 0: {
                break;
            }
            case 1: {
                axis = new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 1.0);
                break;
            }
            case 2: {
                axis = new AxisAlignedBB(0.0, 0.375, 0.375, 1.0, 0.625, 0.625);
            }
        }
        return axis;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.func_180642_a(world, pos, side, flX, flY, flZ, meta, placer);
        return this.setAxisAlignment(state, side);
    }

    @Override
    public EnumFacing getFacing(IBlockAccess world, BlockPos pos) {
        return EnumFacing.func_82600_a((int)((Integer)world.func_180495_p(pos).func_177229_b((IProperty)AXLEDIR) * 2));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_180497_b(pos, (Block)this, 1, 5);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        this.validatePowerLevel(world, pos);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.setPowerLevel(world, pos, 0);
        this.validatePowerLevel(world, pos);
    }

    public IBlockState setAxisAlignment(IBlockState state, EnumFacing facing) {
        int axis;
        switch (facing) {
            case DOWN: 
            case UP: {
                axis = 0;
                break;
            }
            case NORTH: 
            case SOUTH: {
                axis = 1;
                break;
            }
            default: {
                axis = 2;
            }
        }
        return state.func_177226_a((IProperty)AXLEDIR, (Comparable)Integer.valueOf(axis)).func_177226_a((IProperty)SIGNAL, (Comparable)Integer.valueOf(0));
    }

    public void setPowerLevel(World world, BlockPos pos, int power) {
        IBlockState state = world.func_180495_p(pos);
        state = this.setPowerLevelInState(state, power);
        world.func_175656_a(pos, state);
    }

    public IBlockState setPowerLevelInState(IBlockState state, int power) {
        return state.func_177226_a((IProperty)SIGNAL, (Comparable)Integer.valueOf(power));
    }

    public void validatePowerLevel(World world, BlockPos pos) {
        int currentPower = this.getPowerLevel((IBlockAccess)world, pos);
        int axis = this.getAxisAlignment((IBlockAccess)world, pos);
        int maxNeighborPower = 0;
        int greaterPowerNeighbors = 0;
        for (int i = 0; i < 2; ++i) {
            EnumFacing dir = facings[axis][i];
            BlockPos pos2 = pos.func_177972_a(dir);
            Block block = world.func_180495_p(pos2).func_177230_c();
            if (!(block instanceof IMechanical)) continue;
            IMechanical mech = (IMechanical)block;
            int powerLevel = mech.getMechPowerLevelToFacing(world, pos2, dir.func_176734_d());
            if (powerLevel > maxNeighborPower) {
                maxNeighborPower = powerLevel;
            }
            if (powerLevel <= currentPower) continue;
            ++greaterPowerNeighbors;
        }
        if (greaterPowerNeighbors >= 2) {
            this.breakAxle(world, pos);
            return;
        }
        int newPower = currentPower;
        if (maxNeighborPower > currentPower) {
            if (maxNeighborPower == 1) {
                this.breakAxle(world, pos);
                return;
            }
            newPower = maxNeighborPower - 1;
        } else {
            newPower = 0;
        }
        if (newPower != currentPower) {
            this.setPowerLevel(world, pos, newPower);
        }
    }

    public void breakAxle(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            InvUtils.ejectStackWithOffset(world, pos, new ItemStack(BWRegistry.axle, 1, 0));
            world.func_175698_g(pos);
        }
    }

    @Override
    public int getMechPowerLevelToFacing(World world, BlockPos pos, EnumFacing dir) {
        int alignment = this.getAxisAlignment((IBlockAccess)world, pos);
        if (dir.ordinal() >> 1 == alignment) {
            return this.getPowerLevel((IBlockAccess)world, pos);
        }
        return 0;
    }

    @Override
    public int getPowerLevel(IBlockAccess world, BlockPos pos) {
        return this.getPowerLevelFromState(world.func_180495_p(pos));
    }

    public int getPowerLevelFromState(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)SIGNAL);
    }

    @Override
    public int getAxisAlignment(IBlockAccess world, BlockPos pos) {
        return (Integer)world.func_180495_p(pos).func_177229_b((IProperty)AXLEDIR);
    }

    public void setAxisAlignment(World world, BlockPos pos, int alignment) {
        IBlockState state = world.func_180495_p(pos);
        world.func_175656_a(pos, state.func_177226_a((IProperty)AXLEDIR, (Comparable)Integer.valueOf(alignment)));
    }

    @Override
    public boolean isAxleOrientedToFacing(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        int axis = this.getAxisAlignment(world, pos);
        return dir == facings[axis][0] || dir == facings[axis][1];
    }

    public void overpower(World world, BlockPos pos) {
        int axis = this.getAxisAlignment((IBlockAccess)world, pos);
        this.overpowerBlockToSide(world, pos, axis, facings[axis][0]);
        this.overpowerBlockToSide(world, pos, axis, facings[axis][1]);
    }

    private void overpowerBlockToSide(World world, BlockPos pos, int source, EnumFacing dir) {
        IMechanicalBlock mech;
        BlockPos pos2 = pos.func_177972_a(dir);
        Block block = world.func_180495_p(pos2).func_177230_c();
        if (block == BWRegistry.axle) {
            int axis = ((BlockAxle)world.func_180495_p(pos2).func_177230_c()).getAxisAlignment((IBlockAccess)world, pos2);
            if (axis == source) {
                this.overpowerBlockToSide(world, pos2, source, dir);
            }
        } else if (block instanceof IMechanicalBlock && (mech = (IMechanicalBlock)block).canInputPowerToSide((IBlockAccess)world, pos2, dir.func_176734_d())) {
            mech.overpower(world, pos2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)SIGNAL) > 0) {
            this.emitAxleParticles(world, pos, rand);
            if (rand.nextInt(200) == 0) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, BWSounds.WOODCREAK, SoundCategory.BLOCKS, 0.5f, rand.nextFloat() * 0.1f + 0.5f, false);
            }
        }
    }

    private void emitAxleParticles(World world, BlockPos pos, Random rand) {
        int pow = this.getPowerLevel((IBlockAccess)world, pos);
        for (int i = 0; i < pow; ++i) {
            float flX = (float)pos.func_177958_n() + rand.nextFloat();
            float flY = (float)pos.func_177956_o() + rand.nextFloat() * 0.5f + 0.625f;
            float flZ = (float)pos.func_177952_p() + rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)flX, (double)flY, (double)flZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public int powerLevelFromMeta(int meta) {
        if (meta < 3) {
            return 0;
        }
        if (meta < 6) {
            return 1;
        }
        if (meta < 9) {
            return 2;
        }
        if (meta < 12) {
            return 3;
        }
        if (meta < 15) {
            return 4;
        }
        return 0;
    }

    public int orientationFromMeta(int meta) {
        int powerLevel = 3 * this.powerLevelFromMeta(meta);
        return meta - powerLevel;
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)SIGNAL) * 3 + (Integer)state.func_177229_b((IProperty)AXLEDIR);
    }

    public IBlockState func_176203_a(int meta) {
        int power = this.powerLevelFromMeta(meta);
        int ori = this.orientationFromMeta(meta);
        return this.func_176223_P().func_177226_a((IProperty)AXLEDIR, (Comparable)Integer.valueOf(ori)).func_177226_a((IProperty)SIGNAL, (Comparable)Integer.valueOf(power));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXLEDIR, SIGNAL});
    }
}

