/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks;

import betterwithmods.BWRegistry;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.util.DirUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockBTWPane
extends Block {
    public static final PropertyEnum<EnumPaneType> TYPES = PropertyEnum.func_177709_a((String)"type", EnumPaneType.class);
    private String[] names = new String[]{"grate", "slats", "wicker"};

    public BlockBTWPane() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149663_c("bwm:pane");
        this.func_149647_a(BWCreativeTabs.BWTAB);
        this.func_180632_j(this.func_176223_P().func_177226_a(TYPES, (Comparable)((Object)EnumPaneType.GRATE)));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, Entity entity) {
        state = state.func_185899_b((IBlockAccess)world, pos);
        float minY = 0.001f;
        float maxY = 0.999f;
        float minX = 0.4375f;
        float maxX = 0.5625f;
        float minZ = 0.4375f;
        float maxZ = 0.5625f;
        if (((Boolean)state.func_177229_b((IProperty)DirUtils.NORTH)).booleanValue()) {
            minZ = 0.0f;
        }
        if (((Boolean)state.func_177229_b((IProperty)DirUtils.SOUTH)).booleanValue()) {
            maxZ = 1.0f;
        }
        if (((Boolean)state.func_177229_b((IProperty)DirUtils.WEST)).booleanValue()) {
            minX = 0.0f;
        }
        if (((Boolean)state.func_177229_b((IProperty)DirUtils.EAST)).booleanValue()) {
            maxX = 1.0f;
        }
        AxisAlignedBB stick = new AxisAlignedBB(0.4375, 0.0, 0.4375, 0.5625, 1.0, 0.5625);
        BlockBTWPane.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)stick);
        if (minZ == 0.0f || maxZ == 1.0f) {
            AxisAlignedBB extZ = new AxisAlignedBB(0.4375, (double)minY, (double)minZ, 0.5625, (double)maxY, (double)maxZ);
            BlockBTWPane.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)extZ);
        }
        if (minX == 0.0f || maxX == 1.0f) {
            AxisAlignedBB extX = new AxisAlignedBB((double)minX, (double)minY, 0.4375, (double)maxX, (double)maxY, 0.5625);
            BlockBTWPane.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)extX);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        state = state.func_185899_b(world, pos);
        float minY = 0.0f;
        float maxY = 1.0f;
        float minX = 0.4375f;
        float maxX = 0.5625f;
        float minZ = 0.4375f;
        float maxZ = 0.5625f;
        if (((Boolean)state.func_177229_b((IProperty)DirUtils.NORTH)).booleanValue()) {
            minZ = 0.0f;
        }
        if (((Boolean)state.func_177229_b((IProperty)DirUtils.SOUTH)).booleanValue()) {
            maxZ = 1.0f;
        }
        if (((Boolean)state.func_177229_b((IProperty)DirUtils.WEST)).booleanValue()) {
            minX = 0.0f;
        }
        if (((Boolean)state.func_177229_b((IProperty)DirUtils.EAST)).booleanValue()) {
            maxX = 1.0f;
        }
        return new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        list.add(new ItemStack(item, 1, 2));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        switch ((EnumPaneType)((Object)state.func_177229_b(TYPES))) {
            case SLATS: {
                return Item.func_150898_a((Block)BWRegistry.slats);
            }
            case WICKER: {
                return Item.func_150898_a((Block)this);
            }
        }
        return Item.func_150898_a((Block)BWRegistry.grate);
    }

    public int func_180651_a(IBlockState state) {
        if (state.func_177229_b(TYPES) == EnumPaneType.WICKER) {
            return 2;
        }
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean isCompatiblePane(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        BlockPos neighbor = pos.func_177972_a(dir);
        Block block = world.func_180495_p(neighbor).func_177230_c();
        return block instanceof BlockBTWPane;
    }

    public boolean canConnectTo(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        return world.func_180495_p(pos).func_177230_c().func_149662_c(world.func_180495_p(pos)) || world.func_180495_p(pos).func_177230_c().func_176212_b(world, pos, dir.func_176734_d());
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return entity instanceof EntityPlayer && world.func_180495_p(pos).func_177229_b(TYPES) != EnumPaneType.WICKER;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean north = this.canConnectTo(world, pos.func_177978_c(), EnumFacing.NORTH) || this.isCompatiblePane(world, pos, EnumFacing.NORTH);
        boolean east = this.canConnectTo(world, pos.func_177974_f(), EnumFacing.EAST) || this.isCompatiblePane(world, pos, EnumFacing.EAST);
        boolean south = this.canConnectTo(world, pos.func_177968_d(), EnumFacing.SOUTH) || this.isCompatiblePane(world, pos, EnumFacing.SOUTH);
        boolean west = this.canConnectTo(world, pos.func_177976_e(), EnumFacing.WEST) || this.isCompatiblePane(world, pos, EnumFacing.WEST);
        return state.func_177226_a((IProperty)DirUtils.NORTH, (Comparable)Boolean.valueOf(north)).func_177226_a((IProperty)DirUtils.EAST, (Comparable)Boolean.valueOf(east)).func_177226_a((IProperty)DirUtils.SOUTH, (Comparable)Boolean.valueOf(south)).func_177226_a((IProperty)DirUtils.WEST, (Comparable)Boolean.valueOf(west));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumPaneType)((Object)state.func_177229_b(TYPES))).getMeta();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPES, (Comparable)((Object)EnumPaneType.byMeta(meta)));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPES, DirUtils.SOUTH, DirUtils.EAST, DirUtils.NORTH, DirUtils.WEST});
    }

    public static enum EnumPaneType implements IStringSerializable
    {
        GRATE(0, "grate"),
        SLATS(1, "slats"),
        WICKER(2, "wicker");

        private static final EnumPaneType[] META_LOOKUP;
        private String name;
        private int meta;

        private EnumPaneType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumPaneType byMeta(int meta) {
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumPaneType[EnumPaneType.values().length];
            EnumPaneType[] enumPaneTypeArray = EnumPaneType.values();
            int n = enumPaneTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumPaneType type;
                EnumPaneType.META_LOOKUP[type.getMeta()] = type = enumPaneTypeArray[i];
            }
        }
    }
}

