/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks;

import betterwithmods.BWRegistry;
import betterwithmods.api.block.IMechanicalBlock;
import betterwithmods.blocks.BTWBlock;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import betterwithmods.util.MechanicalUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBellows
extends BTWBlock
implements IMechanicalBlock {
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    public static final PropertyBool TRIGGER = PropertyBool.func_177716_a((String)"trigger");

    public BlockBellows() {
        super(Material.field_151575_d, "bellows");
        this.func_149675_a(true);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DirUtils.HORIZONTAL, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)TRIGGER, (Comparable)Boolean.valueOf(false)));
    }

    public int func_149738_a(World world) {
        return 37;
    }

    public boolean func_149662_c(IBlockState state) {
        return state.func_177230_c() == this && (Boolean)state.func_177229_b((IProperty)ACTIVE) == false;
    }

    public boolean func_149686_d(IBlockState state) {
        return state.func_177230_c() == this && (Boolean)state.func_177229_b((IProperty)ACTIVE) == false;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase living) {
        IBlockState state = super.func_180642_a(world, pos, side, flX, flY, flZ, meta, living);
        if (side.ordinal() < 2) {
            side = DirUtils.convertEntityOrientationToFlatFacing(living, side);
        }
        return this.setFacingInBlock(state, side);
    }

    @Override
    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.func_177226_a((IProperty)DirUtils.HORIZONTAL, (Comparable)facing);
    }

    @Override
    public void setFacing(World world, BlockPos pos, EnumFacing facing) {
        world.func_180495_p(pos).func_177226_a((IProperty)DirUtils.HORIZONTAL, (Comparable)facing);
    }

    @Override
    public EnumFacing getFacing(IBlockAccess world, BlockPos pos) {
        return this.getFacingFromBlockState(world.func_180495_p(pos));
    }

    @Override
    public EnumFacing getFacingFromBlockState(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)DirUtils.HORIZONTAL);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        if (entity == null) {
            this.setFacingInBlock(state, EnumFacing.NORTH);
        }
        EnumFacing facing = DirUtils.convertEntityOrientationToFlatFacing(entity);
        this.setFacingInBlock(state, facing);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.6875, 1.0);
        }
        return field_185505_j;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        if (!this.isCurrentStateValid(world, pos)) {
            world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
            this.setTriggerMechanicalStateChange(world, pos, true);
        } else {
            boolean continuous = this.isTriggerMechanicalStateChange((IBlockAccess)world, pos);
            if (continuous && this.isCurrentStateValid(world, pos)) {
                this.setTriggerMechanicalStateChange(world, pos, false);
            }
        }
    }

    public boolean isCurrentStateValid(World world, BlockPos pos) {
        boolean mechanicalOn;
        boolean gettingPower = this.isInputtingMechPower(world, pos);
        return gettingPower == (mechanicalOn = this.isMechanicalOn((IBlockAccess)world, pos));
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        boolean gettingPower = this.isInputtingMechPower(world, pos);
        boolean isMechOn = this.isMechanicalOn((IBlockAccess)world, pos);
        boolean continuous = this.isTriggerMechanicalStateChange((IBlockAccess)world, pos);
        if (isMechOn != gettingPower) {
            if (continuous) {
                this.setTriggerMechanicalStateChange(world, pos, false);
                this.setMechanicalOn(world, pos, gettingPower);
                world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
                if (gettingPower) {
                    this.blow(world, pos);
                } else {
                    this.liftCollidingEntities(world, pos);
                }
            } else {
                world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
                this.setTriggerMechanicalStateChange(world, pos, true);
            }
        } else if (continuous) {
            this.setTriggerMechanicalStateChange(world, pos, false);
        }
    }

    public boolean isTriggerMechanicalState(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)TRIGGER);
    }

    public boolean isTriggerMechanicalStateChange(IBlockAccess world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)TRIGGER);
    }

    public void setTriggerMechanicalStateChange(World world, BlockPos pos, boolean continuous) {
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)TRIGGER, (Comparable)Boolean.valueOf(continuous)));
    }

    @Override
    public boolean canRotateOnTurntable(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public void rotateAroundYAxis(World world, BlockPos pos, boolean reverse) {
        if (DirUtils.rotateAroundY(this, world, pos, reverse)) {
            world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
            MechanicalUtil.destoryHorizontalAxles(world, pos);
            world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
        }
    }

    @Override
    public boolean canOutputMechanicalPower() {
        return false;
    }

    @Override
    public boolean canInputMechanicalPower() {
        return true;
    }

    @Override
    public boolean isInputtingMechPower(World world, BlockPos pos) {
        return MechanicalUtil.isBlockPoweredByAxle(world, pos, this) || MechanicalUtil.isPoweredByCrank(world, pos);
    }

    @Override
    public boolean isOutputtingMechPower(World world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean canInputPowerToSide(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        EnumFacing facing = this.getFacing(world, pos);
        return dir != facing && dir != EnumFacing.UP;
    }

    @Override
    public void overpower(World world, BlockPos pos) {
        this.breakBellows(world, pos);
    }

    @Override
    public boolean isMechanicalOn(IBlockAccess world, BlockPos pos) {
        return this.isMechanicalOnFromState(world.func_180495_p(pos));
    }

    @Override
    public void setMechanicalOn(World world, BlockPos pos, boolean isOn) {
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(isOn)));
    }

    @Override
    public boolean isMechanicalOnFromState(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ACTIVE);
    }

    private void blow(World world, BlockPos pos) {
        this.stokeFlames(world, pos);
    }

    private void stokeFlames(World world, BlockPos pos) {
        EnumFacing dir = this.getFacing((IBlockAccess)world, pos);
        EnumFacing dirLeft = DirUtils.rotateFacingAroundY(this.getFacing((IBlockAccess)world, pos), false);
        EnumFacing dirRight = DirUtils.rotateFacingAroundY(this.getFacing((IBlockAccess)world, pos), true);
        for (int i = 0; i < 3; ++i) {
            BlockPos posRight;
            Block targetRight;
            BlockPos dirPos = pos.func_177967_a(dir, 1 + i);
            Block target = world.func_180495_p(dirPos).func_177230_c();
            if (target == Blocks.field_150480_ab || target == BWRegistry.stokedFlame) {
                this.stokeFire(world, dirPos);
            } else if (!world.func_175623_d(dirPos)) break;
            BlockPos posLeft = dirPos.func_177972_a(dirLeft);
            Block targetLeft = world.func_180495_p(posLeft).func_177230_c();
            if (targetLeft == Blocks.field_150480_ab || targetLeft == BWRegistry.stokedFlame) {
                this.stokeFire(world, posLeft);
            }
            if ((targetRight = world.func_180495_p(posRight = dirPos.func_177972_a(dirRight)).func_177230_c()) != Blocks.field_150480_ab && targetRight != BWRegistry.stokedFlame) continue;
            this.stokeFire(world, posRight);
        }
    }

    private void stokeFire(World world, BlockPos pos) {
        BlockPos down = pos.func_177977_b();
        BlockPos up = pos.func_177984_a();
        if (world.func_180495_p(down).func_177230_c() == BWRegistry.hibachi) {
            if (world.func_180495_p(pos).func_177230_c() == BWRegistry.stokedFlame) {
                world.func_175656_a(pos, BWRegistry.stokedFlame.func_176223_P());
            } else {
                world.func_175656_a(pos, BWRegistry.stokedFlame.func_176223_P());
            }
            if (world.func_175623_d(up)) {
                world.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
            }
        } else {
            world.func_175698_g(pos);
        }
    }

    private void liftCollidingEntities(World world, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        List list = world.func_72872_a(Entity.class, new AxisAlignedBB((double)x, (double)((float)y + 0.6875f), (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1)));
        float extendedY = y + 1;
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                double tempY;
                Entity entity = (Entity)list.get(i);
                if (entity.field_70128_L || !entity.func_70104_M() && !(entity instanceof EntityItem) || !((tempY = entity.func_174813_aQ().field_72338_b) < (double)extendedY)) continue;
                double entityOffset = (double)extendedY - tempY;
                entity.func_70107_b(entity.field_70165_t, entity.field_70163_u + entityOffset, entity.field_70161_v);
            }
        }
    }

    public void breakBellows(World world, BlockPos pos) {
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack((Block)Blocks.field_150376_bx, 2, 0));
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack(BWRegistry.material, 1, 0));
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack(BWRegistry.material, 2, 6));
        world.func_184133_a(null, pos, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.3f, world.field_73012_v.nextFloat() * 0.1f + 0.45f);
        world.func_175698_g(pos);
    }

    public int func_176201_c(IBlockState state) {
        int meta = this.isMechanicalOnFromState(state) ? 8 : 0;
        return (meta += this.isTriggerMechanicalState(state) ? 4 : 0) + ((EnumFacing)state.func_177229_b((IProperty)DirUtils.HORIZONTAL)).func_176736_b();
    }

    public IBlockState func_176203_a(int meta) {
        boolean isTrigger;
        boolean isActive = false;
        if (meta > 7) {
            isActive = true;
            meta -= 8;
        }
        boolean bl = isTrigger = meta > 3;
        if (isTrigger) {
            meta -= 4;
        }
        return this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(isActive)).func_177226_a((IProperty)TRIGGER, (Comparable)Boolean.valueOf(isTrigger)).func_177226_a((IProperty)DirUtils.HORIZONTAL, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.HORIZONTAL, ACTIVE, TRIGGER});
    }
}

