/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks;

import betterwithmods.BWRegistry;
import betterwithmods.blocks.BTWBlock;
import betterwithmods.blocks.BlockInvisibleLight;
import betterwithmods.blocks.BlockLens;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.util.DirUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDetector
extends BTWBlock {
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public BlockDetector() {
        super(Material.field_151576_e, "detector");
        this.func_149647_a(BWCreativeTabs.BWTAB);
        this.func_149711_c(3.5f);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DirUtils.FACING, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.func_149675_a(true);
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public int func_149738_a(World world) {
        return 4;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase entity) {
        IBlockState state = super.func_180642_a(world, pos, side, flX, flY, flZ, meta, entity);
        return this.setFacingInBlock(state, DirUtils.convertEntityOrientationToFacing(entity, side));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        EnumFacing facing = DirUtils.convertEntityOrientationToFacing(entity, EnumFacing.NORTH);
        this.setFacingInBlock(state, facing);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.setBlockOn(world, pos, false);
        world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        boolean blockDetection = this.detectBlock(world, pos);
        boolean detected = this.checkDetection(world, pos);
        EnumFacing facing = this.getFacing((IBlockAccess)world, pos);
        BlockPos offset = pos.func_177972_a(facing);
        Block offsetBlock = world.func_180495_p(offset).func_177230_c();
        if (world.func_175623_d(offset)) {
            if (!detected && world.func_175710_j(offset) && (world.func_72896_J() || world.func_72911_I()) && (world.getBiomeForCoordsBody(offset).func_76738_d() || state.func_177229_b((IProperty)DirUtils.FACING) == EnumFacing.UP)) {
                detected = true;
            }
            world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
        } else if (blockDetection) {
            detected = true;
        }
        if (detected) {
            if (!this.isBlockOn((IBlockAccess)world, pos)) {
                this.setBlockOn(world, pos, true);
            }
        } else if (this.isBlockOn((IBlockAccess)world, pos)) {
            if (!blockDetection) {
                this.setBlockOn(world, pos, false);
            } else {
                world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
            }
        }
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing facing) {
        if (this.isBlockOn(world, pos)) {
            return 15;
        }
        return 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    @Override
    public EnumFacing getFacing(IBlockAccess world, BlockPos pos) {
        return (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)DirUtils.FACING);
    }

    @Override
    public void setFacing(World world, BlockPos pos, EnumFacing facing) {
        this.setFacingInBlock(world.func_180495_p(pos), facing);
    }

    @Override
    public EnumFacing getFacingFromBlockState(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING);
    }

    @Override
    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.func_177226_a((IProperty)DirUtils.FACING, (Comparable)facing);
    }

    @Override
    public boolean canRotateOnTurntable(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean canRotateHorizontally(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean canRotateVertically(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public void rotateAroundYAxis(World world, BlockPos pos, boolean reverse) {
        if (DirUtils.rotateAroundY(this, world, pos, reverse)) {
            world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
        }
    }

    public boolean isBlockOn(IBlockAccess world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)ACTIVE);
    }

    public void setBlockOn(World world, BlockPos pos, boolean on) {
        if (on != this.isBlockOn((IBlockAccess)world, pos)) {
            IBlockState state = world.func_180495_p(pos).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(on));
            if (on) {
                world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.7f);
            }
            world.func_175656_a(pos, state);
            for (int i = 0; i < 6; ++i) {
                world.func_180496_d(pos.func_177972_a(EnumFacing.func_82600_a((int)i)), (Block)this);
            }
        }
    }

    public boolean detectBlock(World world, BlockPos pos) {
        BlockPos offset = pos.func_177972_a(this.getFacing((IBlockAccess)world, pos));
        Block target = world.func_180495_p(offset).func_177230_c();
        if (world.func_175623_d(offset) && world.getBiomeForCoordsBody(offset).func_76738_d() && world.func_175710_j(offset) && (world.func_72896_J() || world.func_72911_I())) {
            return true;
        }
        if (target == BWRegistry.lens) {
            BlockLens lens = (BlockLens)target;
            if (lens.getFacing((IBlockAccess)world, offset) == DirUtils.getOpposite(this.getFacing((IBlockAccess)world, pos)) && lens.isLit((IBlockAccess)world, offset)) {
                return true;
            }
        } else {
            if (world.func_180495_p(offset).func_185914_p()) {
                return true;
            }
            if (!world.func_180495_p(offset).func_185914_p() && !world.func_175623_d(offset)) {
                int x = offset.func_177958_n();
                int y = offset.func_177956_o();
                int z = offset.func_177952_p();
                AxisAlignedBB collisionBox = new AxisAlignedBB((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
                List entityList = world.func_72872_a(Entity.class, collisionBox);
                world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
                if (entityList.size() > 0) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean checkDetection(World world, BlockPos pos) {
        BlockPos offset = pos.func_177972_a(this.getFacing((IBlockAccess)world, pos));
        if (world.func_175623_d(offset)) {
            int z;
            int y;
            int x = offset.func_177958_n();
            AxisAlignedBB collisionBox = new AxisAlignedBB((double)x, (double)(y = offset.func_177956_o()), (double)(z = offset.func_177952_p()), (double)(x + 1), (double)(y + 1), (double)(z + 1));
            List entityList = world.func_72872_a(Entity.class, collisionBox);
            if (entityList.size() > 0) {
                return true;
            }
            BlockPos below = offset.func_177972_a(EnumFacing.DOWN);
            if (world.func_180495_p(below).func_177230_c() instanceof BlockCrops && world.func_180495_p(below).func_177230_c().func_176201_c(world.func_180495_p(below)) >= ((BlockCrops)world.func_180495_p(below).func_177230_c()).func_185526_g()) {
                return true;
            }
            if (world.func_180495_p(offset).func_177230_c() == BWRegistry.lightSource && ((BlockInvisibleLight)world.func_180495_p(offset).func_177230_c()).getFacing((IBlockAccess)world, offset) == this.getFacing((IBlockAccess)world, pos)) {
                return true;
            }
        } else {
            if (world.func_180495_p(offset).func_177230_c() instanceof BlockCrops && world.func_180495_p(offset).func_177230_c().func_176201_c(world.func_180495_p(offset)) >= ((BlockCrops)world.func_180495_p(offset).func_177230_c()).func_185526_g()) {
                return true;
            }
            if (world.func_180495_p(offset).func_177230_c() == Blocks.field_150388_bm && world.func_180495_p(offset).func_177230_c().func_176201_c(world.func_180495_p(offset)) >= 3) {
                return true;
            }
            if (world.func_180495_p(offset).func_177230_c() == Blocks.field_150436_aH) {
                return true;
            }
        }
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        boolean isActive = false;
        if (meta > 7) {
            isActive = true;
            meta -= 8;
        }
        return this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(isActive)).func_177226_a((IProperty)DirUtils.FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        int meta = (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 8 : 0;
        return meta + ((EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.FACING, ACTIVE});
    }
}

