/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks;

import betterwithmods.blocks.BlockGearbox;
import betterwithmods.util.DirUtils;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockGearBoostedRail
extends BlockRailBase {
    public static final PropertyEnum<BlockRailBase.EnumRailDirection> SHAPE = PropertyEnum.func_177708_a((String)"shape", BlockRailBase.EnumRailDirection.class, (Predicate)new Predicate<BlockRailBase.EnumRailDirection>(){

        public boolean apply(@Nullable BlockRailBase.EnumRailDirection railDirection) {
            return railDirection != BlockRailBase.EnumRailDirection.NORTH_EAST && railDirection != BlockRailBase.EnumRailDirection.NORTH_WEST && railDirection != BlockRailBase.EnumRailDirection.SOUTH_EAST && railDirection != BlockRailBase.EnumRailDirection.SOUTH_WEST;
        }
    });
    public static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");

    public BlockGearBoostedRail() {
        super(false);
        this.func_149663_c("bwm:booster");
        this.func_149711_c(0.7f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        if (!world.field_72995_K) {
            state.func_189546_a(world, pos, (Block)this);
        }
    }

    protected void func_189541_b(IBlockState state, World world, BlockPos pos, Block block) {
        boolean gear;
        boolean pow = (Boolean)state.func_177229_b((IProperty)POWERED);
        boolean bl = gear = world.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BlockGearbox && this.isGearboxOn(state, world, pos);
        if (pow != gear) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(gear)), 3);
            world.func_175685_c(pos.func_177977_b(), (Block)this);
            if (((BlockRailBase.EnumRailDirection)state.func_177229_b(SHAPE)).func_177018_c()) {
                world.func_175685_c(pos.func_177984_a(), (Block)this);
            }
        }
    }

    private boolean isGearboxOn(IBlockState state, World world, BlockPos pos) {
        BlockRailBase.EnumRailDirection dir = (BlockRailBase.EnumRailDirection)state.func_177229_b(SHAPE);
        IBlockState below = world.func_180495_p(pos.func_177977_b());
        EnumFacing face = (EnumFacing)below.func_177229_b((IProperty)DirUtils.FACING);
        boolean correctFace = false;
        if (dir == BlockRailBase.EnumRailDirection.ASCENDING_EAST || dir == BlockRailBase.EnumRailDirection.ASCENDING_WEST || dir == BlockRailBase.EnumRailDirection.EAST_WEST) {
            correctFace = face == EnumFacing.DOWN || face == EnumFacing.NORTH || face == EnumFacing.SOUTH;
        } else if (dir == BlockRailBase.EnumRailDirection.ASCENDING_NORTH || dir == BlockRailBase.EnumRailDirection.ASCENDING_SOUTH || dir == BlockRailBase.EnumRailDirection.NORTH_SOUTH) {
            correctFace = face == EnumFacing.DOWN || face == EnumFacing.EAST || face == EnumFacing.WEST;
        }
        return correctFace && ((BlockGearbox)below.func_177230_c()).isGearboxOn((IBlockAccess)world, pos.func_177977_b());
    }

    public boolean isFlexibleRail(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public IProperty<BlockRailBase.EnumRailDirection> func_176560_l() {
        return SHAPE;
    }

    public void onMinecartPass(World world, EntityMinecart cart, BlockPos pos) {
        double planarMotion;
        BlockPos down = pos.func_177977_b();
        Block block = world.func_180495_p(down).func_177230_c();
        if (block instanceof BlockGearbox) {
            boolean isRedstonePowered = world.func_175640_z(down);
            if (!isRedstonePowered) {
                BlockGearbox gear = (BlockGearbox)block;
                EnumFacing face = (EnumFacing)world.func_180495_p(down).func_177229_b((IProperty)DirUtils.FACING);
                if (face != EnumFacing.UP) {
                    if (gear.isGearboxOn((IBlockAccess)world, down)) {
                        IBlockState state = world.func_180495_p(pos);
                        if (state.func_177230_c() == this) {
                            double planarMotion2 = Math.sqrt(cart.field_70159_w * cart.field_70159_w + cart.field_70179_y * cart.field_70179_y);
                            if (state.func_177229_b(SHAPE) == BlockRailBase.EnumRailDirection.ASCENDING_NORTH || state.func_177229_b(SHAPE) == BlockRailBase.EnumRailDirection.ASCENDING_SOUTH || state.func_177229_b(SHAPE) == BlockRailBase.EnumRailDirection.NORTH_SOUTH) {
                                if (face == EnumFacing.EAST || face == EnumFacing.WEST) {
                                    if (face == EnumFacing.EAST) {
                                        if (planarMotion2 > 0.01) {
                                            if (cart.field_70179_y > 0.0) {
                                                cart.field_70179_y -= cart.field_70179_y / planarMotion2 * 0.06;
                                                if (!world.field_72995_K && planarMotion2 > 0.02 && world.field_73012_v.nextDouble() < planarMotion2) {
                                                    world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 1.0f, 2.0f);
                                                }
                                            } else {
                                                cart.field_70179_y += cart.field_70179_y / planarMotion2 * 0.06;
                                            }
                                        } else if (!world.func_180495_p(pos.func_177976_e()).func_185914_p()) {
                                            cart.field_70179_y = -0.02;
                                        }
                                    } else if (face == EnumFacing.WEST) {
                                        if (planarMotion2 > 0.01) {
                                            if (cart.field_70179_y < 0.0) {
                                                cart.field_70179_y -= cart.field_70179_y / planarMotion2 * 0.06;
                                                if (!world.field_72995_K && planarMotion2 > 0.02 && world.field_73012_v.nextDouble() < planarMotion2) {
                                                    world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 1.0f, 2.0f);
                                                }
                                            } else {
                                                cart.field_70179_y += cart.field_70179_y / planarMotion2 * 0.06;
                                            }
                                        } else if (!world.func_180495_p(pos.func_177974_f()).func_185914_p()) {
                                            cart.field_70179_y = 0.02;
                                        }
                                    }
                                } else if (face == EnumFacing.DOWN) {
                                    if (planarMotion2 > 0.01) {
                                        cart.field_70179_y += cart.field_70179_y / planarMotion2 * 0.06;
                                    } else if (world.func_180495_p(pos.func_177976_e()).func_185914_p()) {
                                        cart.field_70179_y = 0.02;
                                    } else if (world.func_180495_p(pos.func_177974_f()).func_185914_p()) {
                                        cart.field_70179_y = -0.02;
                                    }
                                }
                            } else if (state.func_177229_b(SHAPE) == BlockRailBase.EnumRailDirection.ASCENDING_EAST || state.func_177229_b(SHAPE) == BlockRailBase.EnumRailDirection.ASCENDING_WEST || state.func_177229_b(SHAPE) == BlockRailBase.EnumRailDirection.EAST_WEST) {
                                if (face == EnumFacing.NORTH || face == EnumFacing.SOUTH) {
                                    if (face == EnumFacing.SOUTH) {
                                        if (planarMotion2 > 0.01) {
                                            if (cart.field_70159_w > 0.0) {
                                                cart.field_70159_w -= cart.field_70159_w / planarMotion2 * 0.06;
                                                if (!world.field_72995_K && planarMotion2 > 0.02 && world.field_73012_v.nextDouble() < planarMotion2) {
                                                    world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 1.0f, 2.0f);
                                                }
                                            } else {
                                                cart.field_70159_w += cart.field_70159_w / planarMotion2 * 0.06;
                                            }
                                        } else if (!world.func_180495_p(pos.func_177976_e()).func_185914_p()) {
                                            cart.field_70159_w = -0.02;
                                        }
                                    } else if (face == EnumFacing.NORTH) {
                                        if (planarMotion2 > 0.01) {
                                            if (cart.field_70159_w < 0.0) {
                                                cart.field_70159_w -= cart.field_70159_w / planarMotion2 * 0.06;
                                                if (!world.field_72995_K && planarMotion2 > 0.02 && world.field_73012_v.nextDouble() < planarMotion2) {
                                                    world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 1.0f, 2.0f);
                                                }
                                            } else {
                                                cart.field_70159_w += cart.field_70159_w / planarMotion2 * 0.06;
                                            }
                                        } else if (!world.func_180495_p(pos.func_177974_f()).func_185914_p()) {
                                            cart.field_70159_w = 0.02;
                                        }
                                    }
                                } else if (face == EnumFacing.DOWN) {
                                    if (planarMotion2 > 0.01) {
                                        cart.field_70159_w += cart.field_70159_w / planarMotion2 * 0.06;
                                    } else if (world.func_180495_p(pos.func_177976_e()).func_185914_p()) {
                                        cart.field_70159_w = 0.02;
                                    } else if (world.func_180495_p(pos.func_177974_f()).func_185914_p()) {
                                        cart.field_70159_w = -0.02;
                                    }
                                }
                            }
                        }
                    } else {
                        IBlockState state = world.func_180495_p(pos);
                        if (state.func_177230_c() == this) {
                            double planarMotion3 = Math.sqrt(cart.field_70159_w * cart.field_70159_w + cart.field_70179_y * cart.field_70179_y);
                            if (planarMotion3 > 0.01) {
                                double zMotion = Math.sqrt(cart.field_70179_y * cart.field_70179_y);
                                double xMotion = Math.sqrt(cart.field_70159_w * cart.field_70159_w);
                                if (xMotion > 0.0) {
                                    cart.field_70159_w -= cart.field_70159_w / planarMotion3 * 0.06;
                                } else if (zMotion > 0.0) {
                                    cart.field_70179_y -= cart.field_70179_y / planarMotion3 * 0.06;
                                }
                                if (!world.field_72995_K && planarMotion3 > 0.02 && world.field_73012_v.nextDouble() < planarMotion3) {
                                    world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 1.0f, 2.0f);
                                }
                            } else if (state.func_177229_b(SHAPE) == BlockRailBase.EnumRailDirection.EAST_WEST || state.func_177229_b(SHAPE) == BlockRailBase.EnumRailDirection.NORTH_SOUTH) {
                                cart.field_70159_w = 0.0;
                                cart.field_70179_y = 0.0;
                            }
                        }
                    }
                }
            }
        } else if (!world.field_72995_K && (planarMotion = Math.sqrt(cart.field_70159_w * cart.field_70159_w + cart.field_70179_y * cart.field_70179_y)) > 0.02 && world.field_73012_v.nextDouble() < planarMotion) {
            world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 1.0f, 2.0f);
        }
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return Blocks.field_150318_D.func_185499_a(state, rot);
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return Blocks.field_150318_D.func_185471_a(state, mirrorIn);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(SHAPE, (Comparable)BlockRailBase.EnumRailDirection.func_177016_a((int)(meta & 7))).func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf((meta & 8) > 0));
    }

    public int func_176201_c(IBlockState state) {
        int i = 0;
        i |= ((BlockRailBase.EnumRailDirection)state.func_177229_b(SHAPE)).func_177015_a();
        if (((Boolean)state.func_177229_b((IProperty)POWERED)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{SHAPE, POWERED});
    }
}

