/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks;

import betterwithmods.BWRegistry;
import betterwithmods.blocks.BTWBlock;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockHibachi
extends BTWBlock {
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");

    public BlockHibachi() {
        super(Material.field_151576_e, "hibachi");
        this.func_149675_a(true);
        this.func_149711_c(3.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public int func_149738_a(World world) {
        return 4;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        boolean powered;
        boolean bl = powered = world.func_175687_A(pos) > 0;
        if (powered) {
            if (!this.isLit((IBlockAccess)world, pos)) {
                this.ignite(world, pos);
            } else {
                Block above = world.func_180495_p(pos.func_177984_a()).func_177230_c();
                if (above != Blocks.field_150480_ab && above != BWRegistry.stokedFlame && this.shouldIgnite(world, pos.func_177984_a())) {
                    world.func_184133_a(null, pos, SoundEvents.field_187557_bK, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 0.8f);
                    world.func_175656_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
                }
            }
        } else if (this.isLit((IBlockAccess)world, pos)) {
            this.extinguish(world, pos);
        } else {
            Block above = world.func_180495_p(pos.func_177984_a()).func_177230_c();
            if (above == Blocks.field_150480_ab || above == BWRegistry.stokedFlame) {
                world.func_175698_g(pos);
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        if (!this.isCurrentlyValid(world, pos)) {
            world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
        }
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)LIT) != false && side == EnumFacing.UP;
    }

    public boolean isCurrentlyValid(World world, BlockPos pos) {
        Block block;
        boolean powered;
        boolean bl = powered = world.func_175687_A(pos) > 0;
        if (this.isLit((IBlockAccess)world, pos) != powered) {
            return false;
        }
        return !this.isLit((IBlockAccess)world, pos) || (block = world.func_180495_p(pos).func_177230_c()) == Blocks.field_150480_ab || block == BWRegistry.stokedFlame || !this.shouldIgnite(world, pos.func_177984_a());
    }

    public boolean isLit(IBlockAccess world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)LIT);
    }

    private boolean shouldIgnite(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return true;
        }
        if (world.func_180495_p(pos).func_177230_c().isFlammable((IBlockAccess)world, pos, EnumFacing.DOWN)) {
            return true;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        Material material = block.func_149688_o(world.func_180495_p(pos));
        return !material.func_76230_c() && material != Material.field_151587_i && material != Material.field_151586_h && !(block instanceof BlockDoor);
    }

    private void ignite(World world, BlockPos pos) {
        this.setLit(world, pos);
        world.func_184133_a(null, pos, SoundEvents.field_187557_bK, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.4f + 1.0f);
        if (this.shouldIgnite(world, pos.func_177984_a())) {
            world.func_175656_a(pos.func_177984_a(), Blocks.field_150480_ab.func_176223_P());
        }
    }

    private void extinguish(World world, BlockPos pos) {
        boolean isFire;
        this.clearLit(world, pos);
        world.func_184133_a(null, pos, SoundEvents.field_187541_bC, SoundCategory.BLOCKS, 0.5f, 2.6f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.8f);
        boolean bl = isFire = world.func_180495_p(pos.func_177984_a()).func_177230_c() == Blocks.field_150480_ab || world.func_180495_p(pos.func_177984_a()).func_177230_c() == BWRegistry.stokedFlame;
        if (isFire) {
            world.func_175698_g(pos.func_177984_a());
        }
    }

    private void setLit(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        world.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(true)));
    }

    private void clearLit(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        world.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public IBlockState func_176203_a(int meta) {
        boolean isLit = meta == 1;
        return this.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(isLit));
    }

    public int func_176201_c(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 1 : 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LIT});
    }
}

