/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks;

import betterwithmods.BWMod;
import betterwithmods.BWRegistry;
import betterwithmods.api.block.IBTWBlock;
import betterwithmods.api.block.IMechanicalBlock;
import betterwithmods.blocks.tile.IMechSubtype;
import betterwithmods.blocks.tile.TileEntityCauldron;
import betterwithmods.blocks.tile.TileEntityCookingPot;
import betterwithmods.blocks.tile.TileEntityCrucible;
import betterwithmods.blocks.tile.TileEntityFilteredHopper;
import betterwithmods.blocks.tile.TileEntityMill;
import betterwithmods.blocks.tile.TileEntityPulley;
import betterwithmods.blocks.tile.TileEntityTurntable;
import betterwithmods.blocks.tile.TileEntityVisibleInventory;
import betterwithmods.util.InvUtils;
import betterwithmods.util.MechanicalUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMechMachines
extends BlockContainer
implements IBTWBlock,
IMechanicalBlock {
    public static final PropertyBool ISACTIVE = PropertyBool.func_177716_a((String)"ison");
    public static final PropertyEnum<EnumType> MACHINETYPE = PropertyEnum.func_177709_a((String)"machinetype", EnumType.class);
    public static final PropertyInteger SUBTYPE = PropertyInteger.func_177719_a((String)"subtype", (int)0, (int)11);
    public static final PropertyInteger FILLEDSLOTS = PropertyInteger.func_177719_a((String)"filledslots", (int)0, (int)3);
    public static String[] machine = new String[]{"mill", "pulley", "crucible", "cauldron", "hopper", "turntable"};
    private static boolean keepInv;

    public BlockMechMachines() {
        super(Material.field_151576_e);
        this.func_149663_c("bwm:tileMachine");
        this.func_149675_a(true);
        this.func_149711_c(3.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(MACHINETYPE, (Comparable)((Object)EnumType.MILL)));
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        EnumType type = (EnumType)((Object)world.func_180495_p(pos).func_177229_b(MACHINETYPE));
        return type == EnumType.MILL || type == EnumType.PULLEY || type == EnumType.TURNTABLE;
    }

    public int tickRateForMeta(int meta) {
        if (meta > 7) {
            meta -= 8;
        }
        switch (meta) {
            case 2: 
            case 3: {
                return 1;
            }
        }
        return 10;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        EnumType type = (EnumType)((Object)world.func_180495_p(pos).func_177229_b(MACHINETYPE));
        world.func_180497_b(pos, (Block)this, this.tickRateForMeta(type.getMeta()), 5);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public int func_180651_a(IBlockState state) {
        EnumType type = (EnumType)((Object)state.func_177229_b(MACHINETYPE));
        return type.getMeta();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149662_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(MACHINETYPE))).getSolidity();
    }

    public boolean func_149686_d(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(MACHINETYPE))).getSolidity();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof IInventory) {
            player.openGui((Object)BWMod.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        } else if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityTurntable) {
            ((TileEntityTurntable)world.func_175625_s(pos)).processRightClick(player);
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (!keepInv && tileentity instanceof IInventory) {
            TileEntityFilteredHopper hopper;
            InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((IInventory)tileentity));
            if (tileentity instanceof TileEntityFilteredHopper && (hopper = (TileEntityFilteredHopper)tileentity).func_70301_a(18) != null) {
                InvUtils.ejectStackWithOffset(world, pos, hopper.func_70301_a(18));
            }
            world.func_175666_e(pos, (Block)this);
        }
        super.func_180663_b(world, pos, state);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        IMechSubtype sub;
        boolean gettingPower = this.isInputtingMechPower(world, pos);
        boolean isOn = this.isMechanicalOn((IBlockAccess)world, pos);
        if (world.func_175625_s(pos) instanceof IMechSubtype && (sub = (IMechSubtype)world.func_175625_s(pos)).getSubtype() != ((Integer)state.func_177229_b((IProperty)SUBTYPE)).intValue()) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)SUBTYPE, (Comparable)Integer.valueOf(sub.getSubtype())));
        }
        if (world.func_175625_s(pos) instanceof TileEntityTurntable && !world.func_82736_K().func_82766_b("doDaylightCycle")) {
            ((TileEntityTurntable)world.func_175625_s(pos)).toggleAsynchronous(null);
        }
        if (isOn != gettingPower) {
            this.setMechanicalOn(world, pos, gettingPower);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block) {
        EnumType type = (EnumType)((Object)world.func_180495_p(pos).func_177229_b(MACHINETYPE));
        if (!this.isCurrentStateValid(world, pos)) {
            world.func_180497_b(pos, (Block)this, this.tickRateForMeta(type.getMeta()), 5);
        }
        if (type == EnumType.HOPPER) {
            ((TileEntityFilteredHopper)world.func_175625_s((BlockPos)pos)).outputBlocked = false;
        }
    }

    public boolean isCurrentStateValid(World world, BlockPos pos) {
        boolean gettingPower = this.isInputtingMechPower(world, pos);
        boolean isOn = this.isMechanicalOn((IBlockAccess)world, pos);
        return isOn == gettingPower;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return this.createTileEntity(world, this.func_176203_a(meta));
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch ((EnumType)((Object)state.func_177229_b(MACHINETYPE))) {
            case MILL: {
                return new TileEntityMill();
            }
            case PULLEY: {
                return new TileEntityPulley();
            }
            case CRUCIBLE: {
                return new TileEntityCrucible();
            }
            case CAULDRON: {
                return new TileEntityCauldron();
            }
            case HOPPER: {
                return new TileEntityFilteredHopper();
            }
            case TURNTABLE: {
                return new TileEntityTurntable();
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 6; ++i) {
            if (i == 1) continue;
            list.add(new ItemStack(item, 1, i));
        }
    }

    @Override
    public boolean canOutputMechanicalPower() {
        return false;
    }

    @Override
    public boolean canInputMechanicalPower() {
        return true;
    }

    @Override
    public boolean isInputtingMechPower(World world, BlockPos pos) {
        EnumType type = (EnumType)((Object)world.func_180495_p(pos).func_177229_b(MACHINETYPE));
        if (type == EnumType.MILL || type == EnumType.PULLEY || type == EnumType.HOPPER) {
            return MechanicalUtil.isBlockPoweredByAxle(world, pos, this) || MechanicalUtil.isPoweredByCrank(world, pos);
        }
        if (type == EnumType.TURNTABLE) {
            return MechanicalUtil.isBlockPoweredByAxle(world, pos, this);
        }
        return false;
    }

    @Override
    public boolean isOutputtingMechPower(World world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean canInputPowerToSide(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        EnumType type = (EnumType)((Object)world.func_180495_p(pos).func_177229_b(MACHINETYPE));
        switch (type) {
            case MILL: {
                return dir == EnumFacing.UP || dir == EnumFacing.DOWN;
            }
            case PULLEY: {
                return dir != EnumFacing.DOWN;
            }
            case CRUCIBLE: 
            case CAULDRON: 
            case HOPPER: {
                return dir != EnumFacing.UP && dir != EnumFacing.DOWN;
            }
            case TURNTABLE: {
                return dir == EnumFacing.DOWN;
            }
        }
        return false;
    }

    @Override
    public void overpower(World world, BlockPos pos) {
        EnumType type = (EnumType)((Object)world.func_180495_p(pos).func_177229_b(MACHINETYPE));
        if (!world.field_72995_K) {
            switch (type) {
                case MILL: {
                    this.breakMill(world, pos);
                    break;
                }
                case PULLEY: {
                    this.breakPulley(world, pos);
                    break;
                }
                case HOPPER: {
                    this.breakHopper(world, pos);
                    break;
                }
                case TURNTABLE: {
                    this.breakTurntable(world, pos);
                    break;
                }
            }
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        EnumType type;
        if (!world.field_72995_K && (type = (EnumType)((Object)world.func_180495_p(pos).func_177229_b(MACHINETYPE))) == EnumType.HOPPER && world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityFilteredHopper && (entity instanceof EntityItem || entity instanceof EntityXPOrb)) {
            world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
        }
    }

    private void breakMill(World world, BlockPos pos) {
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack(Blocks.field_150347_e));
        world.func_184133_a(null, pos, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.3f, world.field_73012_v.nextFloat() * 0.1f + 0.45f);
        world.func_175698_g(pos);
    }

    private void breakPulley(World world, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack(Blocks.field_150344_f, 2, 0));
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack(BWRegistry.material, 1, 0));
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack(Items.field_151042_j));
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack(Items.field_151074_bl, 2, 0));
        world.func_184133_a(null, pos, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.3f, world.field_73012_v.nextFloat() * 0.1f + 0.45f);
        world.func_175698_g(pos);
    }

    public void breakHopper(World world, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack((Block)Blocks.field_150376_bx, 2, 0));
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack(BWRegistry.material, 1, 0));
        world.func_184133_a(null, pos, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.3f, world.field_73012_v.nextFloat() * 0.1f + 0.45f);
        world.func_175698_g(pos);
    }

    private void breakTurntable(World world, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack(Items.field_151137_ax));
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack(Blocks.field_150347_e, 4, 0));
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack((Block)Blocks.field_150376_bx, 2, 0));
        world.func_184133_a(null, pos, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.3f, world.field_73012_v.nextFloat() * 0.1f + 0.45f);
        world.func_175698_g(pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        EnumType type = (EnumType)((Object)world.func_180495_p(pos).func_177229_b(MACHINETYPE));
        boolean isOn = (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)ISACTIVE);
        if (type == EnumType.MILL && isOn) {
            this.updateMill(world, pos, rand);
        } else if (!(isOn || type != EnumType.CAULDRON && type != EnumType.CRUCIBLE)) {
            this.updateCookingPot(world, pos, rand);
        }
    }

    public void updateMill(World world, BlockPos pos, Random rand) {
        if (this.isMechanicalOn((IBlockAccess)world, pos)) {
            this.emitSmoke(world, pos, rand);
            if (rand.nextInt(2) == 0) {
                world.func_184133_a(null, pos, SoundEvents.field_187782_ds, SoundCategory.BLOCKS, 0.5f + rand.nextFloat() * 0.1f, 0.5f + rand.nextFloat() * 0.1f);
            }
        }
    }

    private void emitSmoke(World world, BlockPos pos, Random rand) {
        for (int i = 0; i < 5; ++i) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            float fX = (float)x + rand.nextFloat();
            float fY = (float)y + rand.nextFloat() * 0.5f + 1.0f;
            float fZ = (float)z + rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)fX, (double)fY, (double)fZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private void updateCookingPot(World world, BlockPos pos, Random rand) {
        if (!this.isMechanicalOn((IBlockAccess)world, pos)) {
            TileEntityCookingPot tile = (TileEntityCookingPot)world.func_175625_s(pos);
            int heat = tile.fireIntensity;
            if (heat > 4) {
                for (int i = 0; i < heat; ++i) {
                    int x = pos.func_177958_n();
                    int y = pos.func_177956_o();
                    int z = pos.func_177952_p();
                    float fX = (float)x + rand.nextFloat();
                    float fY = (float)y + rand.nextFloat() * 0.5f + 1.0f;
                    float fZ = (float)z + rand.nextFloat();
                    world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)fX, (double)fY, (double)fZ, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
    }

    @Override
    public EnumFacing getFacing(IBlockAccess world, BlockPos pos) {
        return null;
    }

    @Override
    public void setFacing(World world, BlockPos pos, EnumFacing facing) {
    }

    @Override
    public EnumFacing getFacingFromBlockState(IBlockState state) {
        return null;
    }

    @Override
    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state;
    }

    @Override
    public boolean canRotateOnTurntable(IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean canRotateHorizontally(IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean canRotateVertically(IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Override
    public void rotateAroundYAxis(World world, BlockPos pos, boolean reverse) {
    }

    @Override
    public boolean isMechanicalOn(IBlockAccess world, BlockPos pos) {
        return this.isMechanicalOnFromState(world.func_180495_p(pos));
    }

    @Override
    public void setMechanicalOn(World world, BlockPos pos, boolean isOn) {
        if (isOn != (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)ISACTIVE)) {
            world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)ISACTIVE, (Comparable)Boolean.valueOf(isOn)));
        }
    }

    @Override
    public boolean isMechanicalOnFromState(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ISACTIVE);
    }

    public boolean isRedstonePowered(World world, BlockPos pos) {
        return world.func_175687_A(pos) > 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        int subType = ((EnumType)((Object)state.func_177229_b(MACHINETYPE))).getSubTypeCount();
        boolean subtypes = false;
        int actualType = 0;
        if (subType > 0 && world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof IMechSubtype) {
            actualType = ((IMechSubtype)world.func_175625_s(pos)).getSubtype();
        }
        int filledSlots = 0;
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityVisibleInventory) {
            filledSlots = ((TileEntityVisibleInventory)world.func_175625_s(pos)).filledSlots();
        }
        return state.func_177226_a((IProperty)SUBTYPE, (Comparable)Integer.valueOf(actualType)).func_177226_a((IProperty)FILLEDSLOTS, (Comparable)Integer.valueOf(filledSlots));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ISACTIVE, MACHINETYPE, SUBTYPE, FILLEDSLOTS});
    }

    public IBlockState func_176203_a(int meta) {
        boolean isActive = false;
        if (meta > 7) {
            isActive = true;
            meta -= 8;
        }
        return this.func_176223_P().func_177226_a(MACHINETYPE, (Comparable)((Object)EnumType.byMeta(meta))).func_177226_a((IProperty)ISACTIVE, (Comparable)Boolean.valueOf(isActive));
    }

    public int func_176201_c(IBlockState state) {
        int meta = ((EnumType)((Object)state.func_177229_b(MACHINETYPE))).getMeta();
        return meta += (Boolean)state.func_177229_b((IProperty)ISACTIVE) != false ? 8 : 0;
    }

    public static enum EnumType implements IStringSerializable
    {
        MILL(0, "mill", true),
        PULLEY(1, "pulley", true),
        CRUCIBLE(2, "crucible"),
        CAULDRON(3, "cauldron"),
        HOPPER(4, "hopper", 7, false),
        TURNTABLE(5, "turntable", 3, true);

        private static final EnumType[] META_LOOKUP;
        private int meta;
        private String name;
        private int subTypes;
        private boolean solidity;

        private EnumType(int meta, String name) {
            this(meta, name, 0, false);
        }

        private EnumType(int meta, String name, boolean solid) {
            this(meta, name, 0, solid);
        }

        private EnumType(int meta, String name, int numSubTypes, boolean solid) {
            this.meta = meta;
            this.name = name;
            this.subTypes = numSubTypes;
            this.solidity = solid;
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        public int getSubTypeCount() {
            return this.subTypes;
        }

        public boolean getSolidity() {
            return this.solidity;
        }

        public static EnumType byMeta(int meta) {
            if (meta > 7) {
                meta -= 8;
            }
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        static {
            META_LOOKUP = new EnumType[EnumType.values().length];
            EnumType[] enumTypeArray = EnumType.values();
            int n = enumTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumType machineTypes;
                EnumType.META_LOOKUP[machineTypes.getMeta()] = machineTypes = enumTypeArray[i];
            }
        }
    }
}

