/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks.tile;

import betterwithmods.util.InvUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class TileEntityBlockDispenser
extends TileEntity
implements IInventory {
    private ItemStack[] contents = new ItemStack[16];
    public int nextIndex = 0;

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public int func_70302_i_() {
        return 16;
    }

    public ItemStack func_70301_a(int slot) {
        return this.contents[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return InvUtils.decrStackSize(this, slot, amount);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        if (this.contents[slot] != null) {
            ItemStack stack = this.contents[slot];
            this.contents[slot] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70296_d();
        this.contents[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagList tagList = tag.func_150295_c("Items", 10);
        this.contents = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound tag1 = tagList.func_150305_b(i);
            int j = tag1.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.contents.length) continue;
            this.contents[j] = ItemStack.func_77949_a((NBTTagCompound)tag1);
        }
        if (tag.func_74764_b("NextSlot")) {
            this.nextIndex = tag.func_74762_e("NextSlot");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.contents.length; ++i) {
            if (this.contents[i] == null) continue;
            NBTTagCompound tag1 = new NBTTagCompound();
            tag1.func_74774_a("Slot", (byte)i);
            this.contents[i].func_77955_b(tag1);
            tagList.func_74742_a((NBTBase)tag1);
        }
        t.func_74782_a("Items", (NBTBase)tagList);
        t.func_74768_a("NextSlot", this.nextIndex);
        return t;
    }

    public void addStackToInventory(ItemStack stack, BlockPos pos) {
        if (stack == null) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            ItemStack check = this.contents[i];
            if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)check) || check.field_77994_a >= check.func_77976_d()) continue;
            ++check.field_77994_a;
            this.contents[i] = check;
            return;
        }
        int firstSlot = this.findFirstNullStack();
        if (firstSlot > -1) {
            this.contents[firstSlot] = stack;
        } else {
            EntityItem item = new EntityItem(this.field_145850_b, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
            item.func_174869_p();
            this.field_145850_b.func_72838_d((Entity)item);
        }
    }

    private int findFirstNullStack() {
        for (int i = 0; i < 16; ++i) {
            if (this.contents[i] != null) continue;
            return i;
        }
        return -1;
    }

    public ItemStack getNextStackFromInv() {
        int slot;
        if (this.nextIndex >= this.contents.length || this.contents[this.nextIndex] == null) {
            slot = this.findNextValidSlot(this.nextIndex);
            if (slot < 0) {
                return null;
            }
            this.nextIndex = slot;
        }
        ItemStack nextStack = this.contents[this.nextIndex];
        slot = this.findNextValidSlot(this.nextIndex);
        this.nextIndex = slot < 0 ? 0 : slot;
        return nextStack;
    }

    private int findNextValidSlot(int currentSlot) {
        int slot;
        for (slot = currentSlot + 1; slot < this.contents.length; ++slot) {
            if (this.contents[slot] == null) continue;
            return slot;
        }
        for (slot = 0; slot < currentSlot; ++slot) {
            if (this.contents[slot] == null) continue;
            return slot;
        }
        if (this.contents[currentSlot] != null) {
            return currentSlot;
        }
        return -1;
    }

    public String func_70005_c_() {
        return "inv.bwm.dispenser.name";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return this.getStackInSlotOnClosing(index);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return this.nextIndex;
    }

    public void func_174885_b(int id, int value) {
        this.nextIndex = value;
    }

    public int func_174890_g() {
        return 1;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.contents.length; ++i) {
            this.contents[i] = null;
        }
    }
}

