/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks.tile;

import betterwithmods.BWRegistry;
import betterwithmods.blocks.BlockMechMachines;
import betterwithmods.blocks.tile.TileEntityVisibleInventory;
import betterwithmods.craft.bulk.CraftingManagerBulk;
import betterwithmods.craft.heat.BWMHeatRegistry;
import betterwithmods.craft.heat.BWMHeatSource;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;

public abstract class TileEntityCookingPot
extends TileEntityVisibleInventory {
    public final int stackSizeToDropWhenTipped = 8;
    private final int stokedTicksToCooldown = 20;
    private final int timeToCook = 4350;
    public int cookCounter;
    public int stokedCooldownCounter;
    public int scaledCookCounter;
    public boolean containsValidIngredients;
    private boolean forceValidation;
    public int fireIntensity;
    public int forceFacing;

    public TileEntityCookingPot() {
        this.contents = new ItemStack[27];
        this.cookCounter = 0;
        this.containsValidIngredients = false;
        this.forceValidation = true;
        this.scaledCookCounter = 0;
        this.fireIntensity = -1;
        this.forceFacing = -1;
        this.occupiedSlots = 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound items = tag.func_74775_l("Items");
        for (int i = 0; i < this.contents.length; ++i) {
            if (!items.func_74764_b("Item_" + i)) continue;
            this.func_70299_a(i, ItemStack.func_77949_a((NBTTagCompound)items.func_74775_l("Item_" + i)));
        }
        this.fireIntensity = tag.func_74764_b("fireIntensity") ? tag.func_74762_e("fireIntensity") : -1;
        if (tag.func_74764_b("facing")) {
            this.forceFacing = tag.func_74762_e("facing");
        }
        this.validateInventory();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        NBTTagCompound items = new NBTTagCompound();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            this.func_70301_a(i).func_77955_b(item);
            items.func_74782_a("Item_" + i, (NBTBase)item);
        }
        t.func_74782_a("Items", (NBTBase)items);
        t.func_74768_a("fireIntensity", this.fireIntensity);
        return t;
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockMechMachines) {
            BlockMechMachines block = (BlockMechMachines)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
            if (this.fireIntensity != this.getFireIntensity()) {
                this.validateFireIntensity();
                this.forceValidation = true;
            }
            if (!block.isMechanicalOn((IBlockAccess)this.field_145850_b, this.field_174879_c)) {
                if (this.fireIntensity > 0) {
                    if (this.forceValidation) {
                        this.validateContents();
                        this.forceValidation = false;
                    }
                    if (this.fireIntensity > 4) {
                        if (this.stokedCooldownCounter < 1) {
                            this.cookCounter = 0;
                        }
                        this.stokedCooldownCounter = 20;
                        this.performStokedFireUpdate(this.getCurrentFireIntensity());
                    } else if (this.stokedCooldownCounter > 0) {
                        --this.stokedCooldownCounter;
                        if (this.stokedCooldownCounter < 1) {
                            this.cookCounter = 0;
                        }
                    } else if (this.stokedCooldownCounter == 0 && this.fireIntensity > 0 && this.fireIntensity < 5) {
                        this.performNormalFireUpdate(this.getCurrentFireIntensity());
                    }
                } else {
                    this.cookCounter = 0;
                }
            } else {
                this.cookCounter = 0;
                int tilt = this.forceFacing;
                this.attemptToEjectStackFromInv(tilt);
            }
        }
        this.validateInventory();
        this.scaledCookCounter = this.cookCounter * 1000 / 4350;
    }

    @Override
    public int func_70302_i_() {
        return 27;
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        return this.contents[slot];
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        return InvUtils.decrStackSize(this, slot, amount);
    }

    public ItemStack func_70304_b(int index) {
        return this.getStackInSlotOnClosing(index);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        if (this.contents[slot] != null) {
            ItemStack stack = this.contents[slot];
            this.contents[slot] = null;
            return stack;
        }
        return null;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        this.contents[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.forceValidation = true;
        if (this.field_145850_b != null) {
            this.validateInventory();
        }
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public abstract void validateContents();

    protected abstract CraftingManagerBulk getCraftingManager(boolean var1);

    public int getCurrentFireIntensity() {
        int fireFactor = 0;
        if (this.fireIntensity > 0) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    int meta;
                    int xPos = x;
                    int yPos = -1;
                    int zPos = z;
                    BlockPos target = this.field_174879_c.func_177982_a(xPos, yPos, zPos);
                    Block block = this.field_145850_b.func_180495_p(target).func_177230_c();
                    if (BWMHeatRegistry.get(block, meta = this.field_145850_b.func_180495_p(target).func_177230_c().func_180651_a(this.field_145850_b.func_180495_p(target))) == null) continue;
                    fireFactor += BWMHeatRegistry.get((Block)block, (int)meta).value;
                }
            }
            if (fireFactor < 5) {
                fireFactor = 5;
            }
        }
        return fireFactor;
    }

    private void performNormalFireUpdate(int fireIntensity) {
        if (this.containsValidIngredients) {
            this.cookCounter += fireIntensity;
            if (this.cookCounter >= 4350) {
                this.attemptToCookNormal();
                this.cookCounter = 0;
            }
        } else {
            this.cookCounter = 0;
        }
    }

    private void performStokedFireUpdate(int fireIntensity) {
        if (this.containsValidIngredients) {
            this.cookCounter += fireIntensity;
            if (this.cookCounter >= 4350) {
                if (this.containsExplosives()) {
                    this.explode();
                } else {
                    this.attemptToCookStoked();
                }
                this.cookCounter = 0;
            }
        } else {
            this.cookCounter = 0;
        }
    }

    protected boolean containsExplosives() {
        return this.containsItem(BWRegistry.material, 16) || this.containsItem(Item.func_150898_a((Block)Blocks.field_150335_W)) || this.containsItem(Items.field_151016_H) || this.containsItem(BWRegistry.material, 29);
    }

    private boolean containsItem(Item item) {
        return this.containsItem(item, Short.MAX_VALUE);
    }

    private boolean containsItem(Item item, int meta) {
        return InvUtils.getFirstOccupiedStackOfItem(this, item, meta) > -1;
    }

    private void explode() {
        int hellfire = InvUtils.countItemsInInventory(this, BWRegistry.material, 16);
        float expSize = (float)hellfire * 10.0f / 64.0f;
        expSize += (float)InvUtils.countItemsInInventory(this, Items.field_151016_H) * 10.0f / 64.0f;
        expSize += (float)InvUtils.countItemsInInventory(this, BWRegistry.material, 29) * 10.0f / 64.0f;
        if (InvUtils.countItemsInInventory(this, Item.func_150898_a((Block)Blocks.field_150335_W)) > 0) {
            if (expSize < 4.0f) {
                expSize = 4.0f;
            }
            expSize += (float)InvUtils.countItemsInInventory(this, Item.func_150898_a((Block)Blocks.field_150335_W));
        }
        if (expSize < 2.0f) {
            expSize = 2.0f;
        } else if (expSize > 10.0f) {
            expSize = 10.0f;
        }
        InvUtils.clearInventory(this);
        this.field_145850_b.func_175698_g(this.field_174879_c);
        this.field_145850_b.func_72876_a(null, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, expSize, true);
    }

    protected boolean attemptToCookNormal() {
        return this.attemptToCookWithManager(this.getCraftingManager(false));
    }

    protected boolean attemptToCookStoked() {
        return this.attemptToCookWithManager(this.getCraftingManager(true));
    }

    private boolean attemptToCookWithManager(CraftingManagerBulk man) {
        if (man != null && man.getCraftingResult(this) != null) {
            ItemStack[] output = man.consumeIngredientsAndReturnResult(this);
            assert (output != null && output.length > 0);
            for (int i = 0; i < output.length; ++i) {
                ItemStack stack = output[i].func_77946_l();
                if (stack == null || InvUtils.addItemStackToInv(this, stack)) continue;
                InvUtils.ejectStackWithOffset(this.field_145850_b, this.field_174879_c, stack);
            }
            return true;
        }
        return false;
    }

    public int getCookingProgressScaled(int scale) {
        return this.scaledCookCounter * scale / 1000;
    }

    public boolean isCooking() {
        return this.scaledCookCounter > 0;
    }

    private void attemptToEjectStackFromInv(int facing) {
        int index = InvUtils.getFirstOccupiedStackNotOfItem(this, Items.field_151118_aC);
        if (index >= 0 && index < this.func_70302_i_()) {
            ItemStack stack = this.func_70301_a(index);
            int ejectStackSize = 8;
            if (8 > stack.field_77994_a) {
                ejectStackSize = stack.field_77994_a;
            }
            ItemStack eject = new ItemStack(stack.func_77973_b(), ejectStackSize, stack.func_77952_i());
            InvUtils.copyTags(eject, stack);
            BlockPos target = this.field_174879_c.func_177972_a(EnumFacing.func_82600_a((int)facing));
            boolean ejectIntoWorld = false;
            if (this.field_145850_b.func_175623_d(target)) {
                ejectIntoWorld = true;
            } else if (this.field_145850_b.func_180495_p(target).func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, target)) {
                ejectIntoWorld = true;
            } else {
                Block block = this.field_145850_b.func_180495_p(target).func_177230_c();
                if (!block.func_149688_o(this.field_145850_b.func_180495_p(target)).func_76220_a()) {
                    ejectIntoWorld = true;
                }
            }
            if (ejectIntoWorld) {
                this.ejectStack(eject, facing);
                this.func_70298_a(index, ejectStackSize);
            }
        }
    }

    private void ejectStack(ItemStack stack, int facing) {
        Vec3d pos = DirUtils.convertBlockFacingToVector(facing);
        double x = pos.field_72450_a * 0.5;
        double y = pos.field_72448_b * 0.5;
        double z = pos.field_72449_c * 0.5;
        EntityItem item = new EntityItem(this.field_145850_b, x += (double)this.field_174879_c.func_177958_n() + 0.5, y += (double)this.field_174879_c.func_177956_o() + 0.25, z += (double)this.field_174879_c.func_177952_p() + 0.5, stack);
        Vec3d vel = DirUtils.convertBlockFacingToVector(facing);
        x = vel.field_72450_a * 0.1000000014901161;
        y = vel.field_72448_b * 0.1000000014901161;
        z = vel.field_72449_c * 0.1000000014901161;
        item.field_70159_w = x;
        item.field_70181_x = y;
        item.field_70179_y = z;
        item.func_174869_p();
        this.field_145850_b.func_72838_d((Entity)item);
    }

    private boolean validateInventory() {
        boolean stateChanged = false;
        short currentSlots = (short)InvUtils.getOccupiedStacks(this);
        if (currentSlots != this.occupiedSlots) {
            this.occupiedSlots = currentSlots;
            stateChanged = true;
        }
        if (this.field_145850_b != null && stateChanged) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
        return stateChanged;
    }

    public int getFireIntensity() {
        int meta;
        BlockPos down = this.field_174879_c.func_177977_b();
        Block block = this.field_145850_b.func_180495_p(down).func_177230_c();
        BWMHeatSource source = BWMHeatRegistry.get(block, meta = block.func_180651_a(this.field_145850_b.func_180495_p(down)));
        if (source != null) {
            return source.value;
        }
        return -1;
    }

    private void validateFireIntensity() {
        int meta;
        BlockPos down = this.field_174879_c.func_177977_b();
        Block block = this.field_145850_b.func_180495_p(down).func_177230_c();
        BWMHeatSource source = BWMHeatRegistry.get(block, meta = block.func_180651_a(this.field_145850_b.func_180495_p(down)));
        this.fireIntensity = source != null ? source.value : -1;
    }
}

