/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks.tile;

import betterwithmods.BWRegistry;
import betterwithmods.api.block.ISoulSensitive;
import betterwithmods.blocks.BlockBTWPane;
import betterwithmods.blocks.BlockMechMachines;
import betterwithmods.blocks.tile.IFilteredHopper;
import betterwithmods.blocks.tile.IMechSubtype;
import betterwithmods.blocks.tile.TileEntityVisibleInventory;
import betterwithmods.util.InvUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityFilteredHopper
extends TileEntityVisibleInventory
implements IMechSubtype,
IFilteredHopper {
    public short filterType;
    private final int xpInvSpace = 100;
    private final int xpEjectSize = 20;
    private final int delayBetweenXPDrops = 10;
    private int ejectCounter;
    private int containedXP;
    private int xpDropDelay;
    public boolean outputBlocked;
    public int isPowered;
    private final int maximumRetainedSouls = 8;
    private int soulsRetained;
    public boolean[] filledSlots = new boolean[19];

    public TileEntityFilteredHopper() {
        this.contents = new ItemStack[19];
        this.ejectCounter = 0;
        this.containedXP = 0;
        this.xpDropDelay = 10;
        this.outputBlocked = false;
        this.isPowered = 0;
        this.filterType = 0;
        this.soulsRetained = 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound items = tag.func_74775_l("Items");
        for (int i = 0; i < this.contents.length; ++i) {
            if (!items.func_74764_b("Item_" + i)) continue;
            this.func_70299_a(i, ItemStack.func_77949_a((NBTTagCompound)items.func_74775_l("Item_" + i)));
        }
        if (tag.func_74764_b("EjectCounter")) {
            this.ejectCounter = tag.func_74762_e("EjectCounter");
        }
        if (tag.func_74764_b("XPCount")) {
            this.containedXP = tag.func_74762_e("XPCount");
        }
        if (tag.func_74764_b("FilterType")) {
            this.filterType = tag.func_74765_d("FilterType");
        }
        if (tag.func_74764_b("Souls")) {
            this.soulsRetained = tag.func_74762_e("Souls");
        }
        if (tag.func_74764_b("Active")) {
            this.isPowered = tag.func_74767_n("Active") ? 1 : 0;
        }
        this.validateInventory();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        NBTTagCompound items = new NBTTagCompound();
        for (int i = 0; i < this.contents.length; ++i) {
            if (this.func_70301_a(i) == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            this.func_70301_a(i).func_77955_b(item);
            items.func_74782_a("Item_" + i, (NBTBase)item);
        }
        t.func_74782_a("Items", (NBTBase)items);
        t.func_74768_a("EjectCounter", this.ejectCounter);
        t.func_74768_a("XPCount", this.containedXP);
        t.func_74777_a("FilterType", this.filterType);
        t.func_74768_a("Souls", this.soulsRetained);
        t.func_74757_a("Active", this.isPowered > 0);
        return t;
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (!(this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockMechMachines)) {
            return;
        }
        boolean isOn = false;
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockMechMachines) {
            isOn = ((BlockMechMachines)BWRegistry.singleMachines).isMechanicalOn((IBlockAccess)this.field_145850_b, this.field_174879_c);
        }
        this.entityCollision();
        if (isOn) {
            this.isPowered = 1;
            this.attemptToEjectXPFromInv();
            if (!this.outputBlocked) {
                ++this.ejectCounter;
                if (this.ejectCounter > 2) {
                    this.attemptToEjectStackFromInv();
                    this.ejectCounter = 0;
                }
            } else {
                this.ejectCounter = 0;
            }
        } else {
            this.isPowered = 0;
            this.ejectCounter = 0;
            this.xpDropDelay = 0;
        }
        if (this.soulsRetained > 0) {
            this.processSouls();
        }
    }

    @Override
    public ItemStack func_70301_a(int slot) {
        return this.contents[slot];
    }

    @Override
    public ItemStack func_70298_a(int slot, int amount) {
        return InvUtils.decrStackSize(this, slot, amount);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        if (this.contents[slot] != null) {
            ItemStack stack = this.contents[slot];
            this.contents[slot] = null;
            return stack;
        }
        return null;
    }

    @Override
    public void func_70299_a(int slot, ItemStack stack) {
        this.contents[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public int func_70302_i_() {
        return 18;
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null) {
            this.outputBlocked = false;
            this.validateInventory();
            int occupiedStacks = InvUtils.getOccupiedStacks(this, 0, 17);
            this.setFilter(this.getFilterType());
        }
    }

    public void setFilter(short filter) {
        this.filterType = filter;
    }

    @Override
    public boolean func_70300_a(EntityPlayer player) {
        int z;
        int y;
        int x = this.field_174879_c.func_177958_n();
        return player.func_70092_e((double)x + 0.5, (double)(y = this.field_174879_c.func_177956_o()) + 0.5, (double)(z = this.field_174879_c.func_177952_p()) + 0.5) <= 64.0;
    }

    private boolean validateInventory() {
        short slotsOccupied;
        boolean stateChanged = false;
        short currentFilter = this.getFilterType();
        if (currentFilter != this.filterType) {
            this.filterType = currentFilter;
            stateChanged = true;
        }
        if ((slotsOccupied = (short)InvUtils.getOccupiedStacks(this, 0, 17)) != this.occupiedSlots) {
            this.occupiedSlots = slotsOccupied;
            stateChanged = true;
        }
        if (this.field_145850_b != null && stateChanged) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
        return stateChanged;
    }

    public short getFilterType() {
        ItemStack filter = this.func_70301_a(18);
        if (filter != null && filter.field_77994_a > 0 && filter.func_77973_b() instanceof ItemBlock) {
            Block block = ((ItemBlock)filter.func_77973_b()).func_179223_d();
            if (block instanceof BlockLadder) {
                return 1;
            }
            if (block instanceof BlockTrapDoor) {
                return 2;
            }
            if (block instanceof BlockBTWPane) {
                switch (filter.func_77952_i()) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 5;
                    }
                    case 2: {
                        return 4;
                    }
                }
            }
            if (filter.func_77973_b() == Item.func_150898_a((Block)BWRegistry.grate)) {
                return 3;
            }
            if (filter.func_77973_b() == Item.func_150898_a((Block)BWRegistry.slats)) {
                return 5;
            }
            if (filter.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150425_aM)) {
                return 6;
            }
            if (filter.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150411_aY)) {
                return 7;
            }
        }
        return 0;
    }

    public boolean canFilterProcessItem(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (this.filterType > 0) {
            if (item instanceof ItemBlock || item == Items.field_151144_bL || item == Items.field_151162_bE || item == Items.field_151160_bD) {
                Block block = ((ItemBlock)item).func_179223_d();
                if (item != Item.func_150898_a((Block)Blocks.field_150354_m) && item != Item.func_150898_a((Block)Blocks.field_150351_n) && item != Item.func_150898_a((Block)Blocks.field_150478_aa) && item != Item.func_150898_a((Block)Blocks.field_150429_aA) && !OreDictionary.getOres((String)"treeSapling").contains(new ItemStack(item, 1, stack.func_77952_i())) && !(block instanceof BlockBush)) {
                    return false;
                }
            }
            if (this.filterType == 1) {
                return true;
            }
            if (this.filterType < 6) {
                if (!(item == Item.func_150898_a((Block)Blocks.field_150354_m) || item == Items.field_151014_N || item == Items.field_151080_bb || item == Items.field_151081_bc || item == Items.field_151075_bm || OreDictionary.getOres((String)"listAllseeds").contains(new ItemStack(item, 1, stack.func_77952_i())) || item == Items.field_151016_H || item == Items.field_151102_aT || item == Items.field_151065_br || OreDictionary.getOres((String)"foodFlour").contains(new ItemStack(item, 1, stack.func_77952_i())) || InvUtils.dustNames.contains(new ItemStack(item, 1, stack.func_77952_i())))) {
                    if (this.filterType == 4) {
                        return false;
                    }
                    if (item != Items.field_151007_F && item != Items.field_151121_aF && item == BWRegistry.material && stack.func_77952_i() != 3 && stack.func_77952_i() != 28 && item != Item.func_150898_a((Block)Blocks.field_150325_L)) {
                        int meta = stack.func_77952_i();
                        if (this.filterType == 5) {
                            return item == Items.field_151116_aA || item == Items.field_151148_bJ || item == Items.field_151098_aY || item == BWRegistry.material && (meta == 1 || meta == 4 || meta > 5 && meta < 10 || meta > 31 && meta < 35);
                        }
                        if (item != Item.func_150898_a((Block)Blocks.field_150328_O) && item != Item.func_150898_a((Block)Blocks.field_150327_N) && !(item instanceof ItemBlock) && stack.func_77976_d() > 1 && item != Items.field_151112_aM && item != Items.field_151146_bM) {
                            if (this.filterType == 3) {
                                return false;
                            }
                            if (item != Items.field_151103_aS && item != Items.field_151032_g && !OreDictionary.getOres((String)"stickWood").contains(new ItemStack(item, 1, stack.func_77952_i())) && item != Items.field_151015_O && item != Items.field_151120_aE && item != Items.field_151112_aM && item != Items.field_151146_bM && item != Items.field_151072_bj && item == BWRegistry.material && meta != 8 && meta != 9) {
                                return false;
                            }
                        }
                    }
                }
            } else {
                if (this.filterType == 6) {
                    return stack.func_77973_b() == BWRegistry.material && (stack.func_77952_i() == 15 || stack.func_77952_i() == 23);
                }
                if (this.filterType == 7) {
                    if (stack.func_77976_d() < 2) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isEjecting() {
        return ((BlockMechMachines)BWRegistry.singleMachines).isMechanicalOn((IBlockAccess)this.field_145850_b, this.field_174879_c);
    }

    public void entityCollision() {
        boolean flag = false;
        if (!this.isFull()) {
            flag = this.captureDroppedItems(this);
        }
        if (!this.isXPFull()) {
            BlockPos pos = new BlockPos(this.func_96107_aA(), this.func_96109_aB(), this.func_96108_aC());
            if (this.captureXP(this)) {
                this.field_145850_b.func_184133_a(null, pos, SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 1.0f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.45f);
            }
            boolean bl = flag = this.captureXP(this) || flag;
        }
        if (flag) {
            this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), this.func_145838_q().func_149738_a(this.field_145850_b), 5);
            this.func_70296_d();
        }
    }

    public boolean captureDroppedItems(IFilteredHopper hopper) {
        if (TileEntityHopper.func_184292_a((World)hopper.func_145831_w(), (double)hopper.func_96107_aA(), (double)hopper.func_96109_aB(), (double)hopper.func_96108_aC()).size() > 0) {
            boolean flag = false;
            for (EntityItem item : TileEntityHopper.func_184292_a((World)hopper.func_145831_w(), (double)hopper.func_96107_aA(), (double)hopper.func_96109_aB(), (double)hopper.func_96108_aC())) {
                ItemStack stack = item.func_92059_d();
                if (hopper.filterType() == 4 && stack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150351_n)) {
                    this.handleGravelCase(item);
                    continue;
                }
                if (hopper.filterType() == 6 && stack.func_77973_b() == BWRegistry.material && (stack.func_77952_i() == 15 || stack.func_77952_i() == 23)) {
                    this.handleSoulCase(item);
                    continue;
                }
                if (!this.canFilterProcessItem(stack)) continue;
                flag = TileEntityHopper.func_145898_a((IInventory)this, (EntityItem)item) || flag;
            }
            if (flag) {
                if (this.validateInventory()) {
                    IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                    int filledSlots = this.filledSlots();
                    if (filledSlots != (Integer)state.func_177229_b((IProperty)BlockMechMachines.FILLEDSLOTS)) {
                        this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)BlockMechMachines.FILLEDSLOTS, (Comparable)Integer.valueOf(filledSlots)));
                    }
                    this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), this.func_145838_q().func_149738_a(this.field_145850_b), 5);
                }
                return true;
            }
        }
        return false;
    }

    public boolean captureXP(IFilteredHopper hopper) {
        if (TileEntityFilteredHopper.getCollidingXPOrbs(hopper.func_145831_w(), hopper.func_96107_aA(), hopper.func_96109_aB(), hopper.func_96108_aC()).size() > 0 && hopper.filterType() == 6) {
            boolean flag = false;
            for (EntityXPOrb orb : TileEntityFilteredHopper.getCollidingXPOrbs(hopper.func_145831_w(), hopper.func_96107_aA(), hopper.func_96109_aB(), hopper.func_96108_aC())) {
                flag = this.attemptToSwallowXPOrb(this.func_145831_w(), this.field_174879_c, orb) || flag;
            }
            if (flag) {
                return true;
            }
        }
        return false;
    }

    private boolean isXPFull() {
        return this.containedXP > 99;
    }

    private boolean isFull() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack itemstack = this.contents[i];
            if (itemstack != null && itemstack.field_77994_a == itemstack.func_77976_d()) continue;
            return false;
        }
        return true;
    }

    private void handleGravelCase(EntityItem item) {
        EntityItem red;
        ItemStack stack = item.func_92059_d();
        int separate = this.func_145831_w().field_73012_v.nextInt(stack.field_77994_a + 1);
        int redStack = stack.field_77994_a - separate;
        ItemStack redSand = new ItemStack((Block)Blocks.field_150354_m, redStack, 1);
        if (redStack != 0 && !TileEntityHopper.func_145898_a((IInventory)this, (EntityItem)(red = new EntityItem(this.func_145831_w(), item.field_70142_S, item.field_70137_T, item.field_70136_U, redSand)))) {
            red.func_174869_p();
            this.func_145831_w().func_72838_d((Entity)red);
        }
        if (separate != 0) {
            ItemStack sand = new ItemStack((Block)Blocks.field_150354_m, separate, 0);
            EntityItem reg = new EntityItem(this.func_145831_w(), item.field_70142_S, item.field_70137_T, item.field_70136_U, sand);
            if (!TileEntityHopper.func_145898_a((IInventory)this, (EntityItem)reg)) {
                reg.func_174869_p();
                this.func_145831_w().func_72838_d((Entity)reg);
            }
        }
        ItemStack flint = new ItemStack(Items.field_151145_ak, stack.field_77994_a);
        EntityItem rock = new EntityItem(this.func_145831_w(), item.field_70142_S, item.field_70137_T, item.field_70136_U, flint);
        rock.func_174869_p();
        if (!this.func_145831_w().field_72995_K) {
            this.func_145831_w().func_72838_d((Entity)rock);
        }
        item.func_70106_y();
    }

    private void handleSoulCase(EntityItem item) {
        this.increaseSoulCount(item.func_92059_d().field_77994_a);
        EntityItem hellfire = new EntityItem(this.func_145831_w(), item.field_70142_S, item.field_70137_T, item.field_70136_U, new ItemStack(BWRegistry.material, item.func_92059_d().field_77994_a, 16));
        hellfire.func_174869_p();
        if (!this.func_145831_w().field_72995_K) {
            this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187551_bH, SoundCategory.BLOCKS, 1.0f, this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.45f);
            this.func_145831_w().func_72838_d((Entity)hellfire);
        }
        item.func_70106_y();
    }

    private void attemptToEjectStackFromInv() {
        int stackIndex = InvUtils.getFirstOccupiedStackInRange(this, 0, 17);
        if (stackIndex > -1 && stackIndex < 18) {
            List carts;
            ItemStack invStack = this.func_70301_a(stackIndex);
            int ejectStackSize = 8;
            if (8 > invStack.field_77994_a) {
                ejectStackSize = invStack.field_77994_a;
            }
            ItemStack ejectStack = new ItemStack(invStack.func_77973_b(), ejectStackSize, invStack.func_77952_i());
            InvUtils.copyTags(ejectStack, invStack);
            BlockPos down = this.field_174879_c.func_177977_b();
            boolean ejectIntoWorld = false;
            if (this.field_145850_b.func_175623_d(down)) {
                ejectIntoWorld = true;
            } else if (this.field_145850_b.func_180495_p(down).func_177230_c().func_176200_f((IBlockAccess)this.field_145850_b, down)) {
                ejectIntoWorld = true;
            } else {
                Block block = this.field_145850_b.func_180495_p(down).func_177230_c();
                if (block == null || !block.func_176212_b((IBlockAccess)this.field_145850_b, down, EnumFacing.UP) && (this.field_145850_b.func_175625_s(down) == null || !(this.field_145850_b.func_175625_s(down) instanceof IInventory))) {
                    ejectIntoWorld = true;
                } else {
                    ISidedInventory inv;
                    TileEntity tile = this.field_145850_b.func_175625_s(down);
                    boolean itemsStored = false;
                    if (tile != null && tile instanceof ISidedInventory) {
                        int[] slots;
                        inv = (ISidedInventory)tile;
                        for (int slot : slots = inv.func_180463_a(EnumFacing.UP)) {
                            if (!inv.func_180462_a(slot, ejectStack, EnumFacing.UP)) continue;
                            if (inv.func_70301_a(slot) != null) {
                                if (inv.func_70301_a((int)slot).field_77994_a + ejectStackSize > inv.func_70301_a(slot).func_77976_d()) {
                                    ejectStackSize = inv.func_70301_a(slot).func_77976_d() - inv.func_70301_a((int)slot).field_77994_a;
                                }
                                inv.func_70301_a((int)slot).field_77994_a += ejectStackSize;
                            } else {
                                inv.func_70299_a(slot, ejectStack);
                            }
                            this.func_70298_a(stackIndex, ejectStackSize);
                        }
                    } else if (tile != null && tile instanceof IInventory) {
                        inv = (IInventory)tile;
                        if (InvUtils.addItemStackToInv((IInventory)inv, ejectStack)) {
                            this.func_70298_a(stackIndex, ejectStackSize);
                        }
                    } else {
                        this.outputBlocked = true;
                    }
                }
            }
            if (ejectIntoWorld && (carts = this.field_145850_b.func_72872_a(EntityMinecart.class, new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() + 0.4f), (double)((float)this.field_174879_c.func_177956_o() - 0.5f), (double)((float)this.field_174879_c.func_177952_p() + 0.4f), (double)((float)this.field_174879_c.func_177958_n() + 0.6f), (double)this.field_174879_c.func_177956_o(), (double)((float)this.field_174879_c.func_177952_p() + 0.6f)))) != null && carts.size() > 0) {
                for (int i = 0; i < carts.size(); ++i) {
                    EntityMinecart cart = (EntityMinecart)carts.get(i);
                    if (!(cart instanceof IInventory)) continue;
                    int itemsStored = 0;
                    itemsStored = InvUtils.addItemStackToInv((IInventory)cart, ejectStack) ? ejectStackSize : ejectStackSize - ejectStack.field_77994_a;
                    if (itemsStored > 0) {
                        this.func_70298_a(stackIndex, itemsStored);
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                    ejectIntoWorld = false;
                    break;
                }
            }
            if (ejectIntoWorld) {
                this.ejectStack(ejectStack);
                this.func_70298_a(stackIndex, ejectStackSize);
                if (this.validateInventory()) {
                    this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), this.func_145838_q().func_149738_a(this.field_145850_b), 5);
                }
            }
        }
    }

    private void ejectStack(ItemStack stack) {
        float xOff = this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.45f;
        float yOff = -0.35f;
        float zOff = this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.45f;
        EntityItem item = new EntityItem(this.field_145850_b, (double)((float)this.field_174879_c.func_177958_n() + xOff), (double)((float)this.field_174879_c.func_177956_o() + yOff), (double)((float)this.field_174879_c.func_177952_p() + zOff), stack);
        item.field_70159_w = 0.0;
        item.field_70181_x = -0.01f;
        item.field_70179_y = 0.0;
        item.func_174869_p();
        this.field_145850_b.func_72838_d((Entity)item);
    }

    public void attemptToEjectXPFromInv() {
        boolean shouldResetEjectCount = true;
        if (this.containedXP > 19) {
            BlockPos down = this.field_174879_c.func_177977_b();
            boolean canEjectIntoWorld = false;
            if (this.field_145850_b.func_175623_d(down)) {
                canEjectIntoWorld = true;
            } else {
                Block block = this.field_145850_b.func_180495_p(down).func_177230_c();
                int meta = block.func_180651_a(this.field_145850_b.func_180495_p(down));
                if (block instanceof BlockMechMachines && (meta == 4 || meta == 12)) {
                    shouldResetEjectCount = this.attemptToEjectXPIntoHopper(down);
                } else if (block.func_176200_f((IBlockAccess)this.field_145850_b, down)) {
                    canEjectIntoWorld = true;
                } else if (!block.func_149688_o(this.field_145850_b.func_180495_p(down)).func_76220_a()) {
                    canEjectIntoWorld = true;
                }
            }
            if (canEjectIntoWorld) {
                if (this.xpDropDelay < 1) {
                    this.ejectXPOrb(20);
                    this.containedXP -= 20;
                } else {
                    shouldResetEjectCount = false;
                }
            }
        }
        if (shouldResetEjectCount) {
            this.resetXPEjectCount();
        } else {
            --this.xpDropDelay;
        }
    }

    private boolean attemptToEjectXPIntoHopper(BlockPos pos) {
        int spaceRemaining;
        short filterType;
        TileEntityFilteredHopper tile = (TileEntityFilteredHopper)this.field_145850_b.func_175625_s(pos);
        if (tile != null && (filterType = tile.filterType) == 6 && (spaceRemaining = 100 - tile.containedXP) > 0) {
            if (this.xpDropDelay < 1) {
                int xpEjected = 20;
                if (spaceRemaining < xpEjected) {
                    xpEjected = spaceRemaining;
                }
                tile.containedXP += xpEjected;
                this.containedXP -= xpEjected;
            } else {
                return false;
            }
        }
        return true;
    }

    private void resetXPEjectCount() {
        this.xpDropDelay = 10 + this.field_145850_b.field_73012_v.nextInt(3);
    }

    private void ejectXPOrb(int value) {
        double xOff = this.field_145850_b.field_73012_v.nextDouble() * 0.1 + 0.45;
        double yOff = -0.2;
        double zOff = this.field_145850_b.field_73012_v.nextDouble() * 0.1 + 0.45;
        EntityXPOrb orb = new EntityXPOrb(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + xOff, (double)this.field_174879_c.func_177956_o() + yOff, (double)this.field_174879_c.func_177952_p() + zOff, value);
        orb.field_70159_w = 0.0;
        orb.field_70181_x = 0.0;
        orb.field_70179_y = 0.0;
        this.field_145850_b.func_72838_d((Entity)orb);
    }

    public boolean attemptToSwallowXPOrb(World world, BlockPos pos, EntityXPOrb entity) {
        int remainingSpace = 100 - this.containedXP;
        if (remainingSpace > 0 && entity.field_70530_e > 0) {
            if (entity.field_70530_e <= remainingSpace) {
                this.containedXP += entity.field_70530_e;
                entity.func_70106_y();
                return true;
            }
            entity.field_70530_e -= remainingSpace;
            this.containedXP = 100;
        }
        return false;
    }

    @Override
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tag);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager mgr, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void processSouls() {
        boolean isOn = ((BlockMechMachines)BWRegistry.singleMachines).isMechanicalOn((IBlockAccess)this.field_145850_b, this.field_174879_c);
        BlockPos down = this.field_174879_c.func_177977_b();
        if (this.filterType == 6) {
            Block blockBelow = this.field_145850_b.func_180495_p(down).func_177230_c();
            if (this.soulsRetained > 0 && blockBelow instanceof ISoulSensitive && ((ISoulSensitive)blockBelow).isSoulSensitive((IBlockAccess)this.field_145850_b, down)) {
                int soulsConsumed = ((ISoulSensitive)blockBelow).processSouls(this.field_145850_b, down, this.soulsRetained);
                if (((ISoulSensitive)blockBelow).consumeSouls(this.field_145850_b, down, soulsConsumed)) {
                    this.soulsRetained -= soulsConsumed;
                }
            } else if (isOn) {
                this.soulsRetained = 0;
            } else if (this.soulsRetained > 7) {
                if (this.spawnGhast()) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_189105_bM, SoundCategory.BLOCKS, 1.0f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.8f);
                }
                if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == BWRegistry.singleMachines) {
                    ((BlockMechMachines)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).breakHopper(this.field_145850_b, this.field_174879_c);
                }
            }
        } else {
            this.soulsRetained = 0;
        }
    }

    private boolean areStatesEqual(IBlockState oldState, IBlockState newState) {
        boolean equal = true;
        if (oldState.func_177230_c() != newState.func_177230_c()) {
            equal = false;
        }
        if (equal) {
            for (IProperty oldProp : oldState.func_177228_b().keySet()) {
                for (IProperty newProp : newState.func_177228_b().keySet()) {
                    if (oldProp.func_177701_a() == newProp.func_177701_a()) {
                        boolean bl = equal = oldState.func_177229_b(oldProp) == oldState.func_177229_b(newProp);
                    }
                    if (equal) continue;
                    return false;
                }
            }
        }
        return equal;
    }

    private boolean spawnGhast() {
        EntityGhast ghast = new EntityGhast(this.field_145850_b);
        for (int i = 0; i < 200; ++i) {
            double xPos = (double)this.field_174879_c.func_177958_n() + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * 10.0;
            double yPos = this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextInt(21) - 10;
            double zPos = (double)this.field_174879_c.func_177952_p() + (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * 10.0;
            ghast.func_70012_b(xPos, yPos, zPos, this.field_145850_b.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (!ghast.func_70601_bi()) continue;
            this.field_145850_b.func_72838_d((Entity)ghast);
            return true;
        }
        return false;
    }

    public void increaseSoulCount(int numSouls) {
        this.soulsRetained += numSouls;
    }

    public ItemStack func_70304_b(int index) {
        return this.getStackInSlotOnClosing(index);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.contents.length; ++i) {
            this.contents[i] = null;
        }
    }

    public String func_70005_c_() {
        return "inv.filteredhopper.name";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    @Override
    public int getSubtype() {
        return this.filterType;
    }

    public double func_96107_aA() {
        return (double)this.field_174879_c.func_177958_n() + 0.5;
    }

    public double func_96109_aB() {
        return (double)this.field_174879_c.func_177956_o() + 0.5;
    }

    public double func_96108_aC() {
        return (double)this.field_174879_c.func_177952_p() + 0.5;
    }

    public static List<EntityXPOrb> getCollidingXPOrbs(World world, double x, double y, double z) {
        return world.func_72872_a(EntityXPOrb.class, new AxisAlignedBB(x - 0.5, y - 0.5, z - 0.5, x + 0.5, y + 1.0, z + 0.5));
    }

    @Override
    public int filterType() {
        return this.filterType;
    }

    public boolean[] getFilledSlots() {
        boolean[] slots = new boolean[19];
        for (int i = 0; i < 19; ++i) {
            slots[i] = this.contents[i] != null;
        }
        return slots;
    }

    @Override
    public void setSubtype(int type) {
        this.filterType = (short)Math.min(type, 7);
    }
}

