/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks.tile;

import betterwithmods.BWRegistry;
import betterwithmods.BWSounds;
import betterwithmods.blocks.BlockMechMachines;
import betterwithmods.craft.bulk.CraftingManagerMill;
import betterwithmods.util.InvUtils;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityMill
extends TileEntity
implements IInventory,
ITickable {
    private int grindType = 0;
    private final int timeToGrind = 200;
    private boolean validateContents = true;
    private boolean containsIngredientsToGrind;
    private ItemStack[] contents = new ItemStack[3];
    public int grindCounter = 0;

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        Block block = this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        if (block == null || !(block instanceof BlockMechMachines)) {
            return;
        }
        BlockMechMachines mill = (BlockMechMachines)block;
        if (this.validateContents) {
            this.validateContents();
        }
        if (mill.isMechanicalOn((IBlockAccess)this.field_145850_b, this.field_174879_c) && this.field_145850_b.field_73012_v.nextInt(6) == 0) {
            this.field_145850_b.func_184133_a(null, this.field_174879_c, BWSounds.STONEGRIND, SoundCategory.BLOCKS, 0.4f + this.field_145850_b.field_73012_v.nextFloat() * 0.1f, 0.5f + this.field_145850_b.field_73012_v.nextFloat() * 0.1f);
        }
        if (this.containsIngredientsToGrind && mill.isMechanicalOn((IBlockAccess)this.field_145850_b, this.field_174879_c)) {
            if (!this.field_145850_b.field_72995_K) {
                if (this.grindType == 2) {
                    if (this.field_145850_b.field_73012_v.nextInt(20) < 2) {
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_189105_bM, SoundCategory.BLOCKS, 0.75f, this.field_145850_b.field_73012_v.nextFloat() * 0.4f + 0.8f);
                    }
                } else if (this.grindType == 3 && this.field_145850_b.field_73012_v.nextInt(20) < 2) {
                    this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187863_gH, SoundCategory.BLOCKS, 2.0f, (this.field_145850_b.field_73012_v.nextFloat() - this.field_145850_b.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                }
            }
            ++this.grindCounter;
            if (this.grindCounter > 199) {
                this.grindContents();
                this.grindCounter = 0;
                this.validateContents = true;
            }
        }
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        NBTTagCompound items = tag.func_74775_l("Items");
        for (int i = 0; i < this.contents.length; ++i) {
            if (!items.func_74764_b("Item_" + i)) continue;
            this.func_70299_a(i, ItemStack.func_77949_a((NBTTagCompound)items.func_74775_l("Item_" + i)));
        }
        if (tag.func_74764_b("GrindCounter")) {
            this.grindCounter = tag.func_74762_e("GrindCounter");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound items = new NBTTagCompound();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i) == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            this.func_70301_a(i).func_77955_b(item);
            items.func_74782_a("Item_" + i, (NBTBase)item);
        }
        tag.func_74782_a("Items", (NBTBase)items);
        tag.func_74768_a("GrindCounter", this.grindCounter);
        return tag;
    }

    public int getGrindType() {
        return this.grindType;
    }

    public void setGrindType(int type) {
        this.grindType = type;
    }

    public int func_70302_i_() {
        return 3;
    }

    public ItemStack func_70301_a(int slot) {
        return this.contents[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return InvUtils.decrStackSize(this, slot, amount);
    }

    public ItemStack getStackInSlotOnClosing(int slot) {
        if (this.contents[slot] != null) {
            ItemStack stack = this.contents[slot];
            this.contents[slot] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.contents[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.isCompanionCubeInInventory()) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187871_gL, SoundCategory.BLOCKS, 0.5f, 1.0f);
            }
            this.validateContents = true;
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public void ejectStack(ItemStack stack) {
        int dir = 2 + this.field_145850_b.field_73012_v.nextInt(4);
        BlockPos offset = this.field_174879_c.func_177972_a(EnumFacing.func_82600_a((int)dir));
        float xOff = this.field_145850_b.field_73012_v.nextFloat() * 0.7f + 0.15f;
        float yOff = this.field_145850_b.field_73012_v.nextFloat() * 0.2f + 0.1f;
        float zOff = this.field_145850_b.field_73012_v.nextFloat() * 0.7f + 0.15f;
        EntityItem item = new EntityItem(this.field_145850_b, (double)((float)offset.func_177958_n() + xOff), (double)((float)offset.func_177956_o() + yOff), (double)((float)offset.func_177952_p() + zOff), stack);
        float velocity = 0.05f;
        item.field_70159_w = (float)this.field_145850_b.field_73012_v.nextGaussian() * velocity;
        item.field_70181_x = (float)this.field_145850_b.field_73012_v.nextGaussian() * velocity + 0.2f;
        item.field_70179_y = (float)this.field_145850_b.field_73012_v.nextGaussian() * velocity;
        switch (dir) {
            case 2: {
                item.field_70179_y = -velocity;
                break;
            }
            case 3: {
                item.field_70179_y = velocity;
                break;
            }
            case 4: {
                item.field_70159_w = -velocity;
                break;
            }
            default: {
                item.field_70159_w = velocity;
            }
        }
        item.func_174869_p();
        this.field_145850_b.func_72838_d((Entity)item);
    }

    public int getGrindProgressScaled(int scale) {
        return this.grindCounter * scale / 200;
    }

    public boolean isGrinding() {
        return this.grindCounter > 0;
    }

    public boolean isCompanionCubeInInventory() {
        for (int i = 0; i < 3; ++i) {
            Item item;
            if (this.contents[i] == null || (item = this.contents[i].func_77973_b()) == null || item != Item.func_150898_a((Block)BWRegistry.wolf)) continue;
            return true;
        }
        return false;
    }

    private boolean grindContents() {
        CraftingManagerMill mill = CraftingManagerMill.getInstance();
        List<Object> ingredients = mill.getValidCraftingIngredients(this);
        if (ingredients != null) {
            for (int i = 0; i < ingredients.size(); ++i) {
                ItemStack stack;
                if (!(ingredients.get(i) instanceof ItemStack) || (stack = ((ItemStack)ingredients.get(i)).func_77946_l()) == null) continue;
                Item item = stack.func_77973_b();
            }
            ItemStack[] output = mill.consumeIngredientsAndReturnResult(this);
            assert (output != null && output.length > 0);
            for (int i = 0; i < output.length; ++i) {
                ItemStack stack = output[i].func_77946_l();
                if (stack == null) continue;
                this.ejectStack(stack);
            }
            return true;
        }
        return false;
    }

    private void validateContents() {
        int oldGrindType = this.getGrindType();
        int newGrindType = 0;
        List<Object> ingredients = CraftingManagerMill.getInstance().getValidCraftingIngredients(this);
        if (ingredients != null) {
            this.containsIngredientsToGrind = true;
            newGrindType = 1;
            for (int i = 0; i < ingredients.size(); ++i) {
                ItemStack stack;
                if (!(ingredients.get(i) instanceof ItemStack) || (stack = ((ItemStack)ingredients.get(i)).func_77946_l()) == null) continue;
                Item item = stack.func_77973_b();
                if (item == Item.func_150898_a((Block)BWRegistry.wolf)) {
                    newGrindType = 3;
                } else {
                    if (item != Item.func_150898_a((Block)Blocks.field_150424_aL)) continue;
                    newGrindType = 2;
                }
                break;
            }
        } else {
            this.grindCounter = 0;
            this.containsIngredientsToGrind = false;
        }
        this.validateContents = false;
        if (oldGrindType != newGrindType) {
            this.grindType = newGrindType;
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("t", this.grindType);
        return new SPacketUpdateTileEntity(this.field_174879_c, 4, tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager mgr, SPacketUpdateTileEntity pkt) {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        NBTTagCompound tag = pkt.func_148857_g();
        if (tag.func_74764_b("t")) {
            if (tag.func_74762_e("t") != this.grindType) {
                this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), this.func_145838_q().func_149738_a(this.field_145850_b), 5);
            }
            this.grindType = tag.func_74762_e("t");
        }
    }

    public String func_70005_c_() {
        return "inv.mill.name";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public ItemStack func_70304_b(int index) {
        return this.getStackInSlotOnClosing(index);
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        for (int i = 0; i < this.contents.length; ++i) {
            this.contents[i] = null;
        }
    }
}

