/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks.tile.gen;

import betterwithmods.BWSounds;
import betterwithmods.blocks.BlockGen;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityMechGenerator
extends TileEntity
implements ITickable {
    public int radius;
    public byte runningState = 0;
    public float speed = 0.0f;
    public float runningSpeed = 0.4f;
    public float overpowerSpeed = 2.0f;
    public int overpowerTime = 30;
    public byte dyeIndex = 0;
    protected byte waterMod = 1;
    public float currentRotation = 0.0f;
    public float previousRotation = 0.0f;

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("RunningState")) {
            this.runningState = tag.func_74771_c("RunningState");
        }
        if (tag.func_74764_b("CurrentRotation")) {
            this.currentRotation = tag.func_74760_g("CurrentRotation");
        }
        if (tag.func_74764_b("RotationSpeed")) {
            this.previousRotation = tag.func_74760_g("RotationSpeed");
        }
        if (tag.func_74764_b("DyeIndex")) {
            this.dyeIndex = tag.func_74771_c("DyeIndex");
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        t.func_74774_a("RunningState", this.runningState);
        t.func_74776_a("CurrentRotation", this.currentRotation);
        t.func_74776_a("RotationSpeed", this.previousRotation);
        return t;
    }

    public float getCurrentRotation() {
        return this.currentRotation;
    }

    public float getPrevRotation() {
        return this.previousRotation;
    }

    public void func_73660_a() {
        if (this.runningState != 0) {
            this.previousRotation = (this.runningState > 1 ? this.runningSpeed * 5.0f : this.runningSpeed) * (float)this.waterMod;
            this.currentRotation += (float)(this.runningState > 1 ? 5 : (int)this.runningState) * this.runningSpeed * (float)this.waterMod;
            if (this.field_145850_b.field_73012_v.nextInt(100) == 0) {
                this.field_145850_b.func_184133_a(null, this.field_174879_c, BWSounds.WOODCREAK, SoundCategory.BLOCKS, 0.75f, this.field_145850_b.field_73012_v.nextFloat() * 0.25f + 0.25f);
            }
        }
        if (this.currentRotation >= 360.0f) {
            this.currentRotation -= 360.0f;
        }
        if (this.field_145850_b.func_72820_D() % 20L == 0L && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockGen) {
            this.verifyIntegrity();
            this.updateSpeed();
            if (this.runningState == 2 && this.overpowerTime < 1) {
                this.overpower();
            } else if (this.runningState != 2 && this.overpowerTime != 30) {
                this.overpowerTime = 30;
            } else if (this.runningState == 2 && this.overpowerTime > 0) {
                --this.overpowerTime;
            }
        }
    }

    public abstract void updateSpeed();

    public abstract void overpower();

    public abstract boolean isValid();

    public byte getRunningState() {
        return this.runningState;
    }

    public boolean verifyIntegrity() {
        return true;
    }

    public void setRunningState(int i) {
        boolean oldRun;
        BlockGen cfr_ignored_0 = (BlockGen)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        boolean newRun = oldRun = ((Boolean)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockGen.ISACTIVE)).booleanValue();
        this.runningState = (byte)i;
        if (this.runningState > 0) {
            newRun = true;
        } else if (this.runningState == 0) {
            newRun = false;
        }
        if (newRun != oldRun) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockGen.ISACTIVE, (Comparable)Boolean.valueOf(newRun)));
            this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), this.func_145838_q().func_149738_a(this.field_145850_b), 5);
        }
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void writeSpeedPacket(NBTTagCompound tag) {
        tag.func_74776_a("CurrentRotation", this.currentRotation);
        tag.func_74776_a("RotationSpeed", this.previousRotation);
    }

    public void readSpeedPacket(NBTTagCompound tag) {
        this.currentRotation = tag.func_74760_g("CurrentRotation");
        this.previousRotation = tag.func_74760_g("RotationSpeed");
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * 3.0;
    }
}

