/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks.tile.gen;

import betterwithmods.BWRegistry;
import betterwithmods.api.block.IAxle;
import betterwithmods.blocks.BlockWaterwheel;
import betterwithmods.blocks.tile.gen.TileEntityMechGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityWaterwheel
extends TileEntityMechGenerator {
    public TileEntityWaterwheel() {
        this.radius = 3;
        this.waterMod = 0;
    }

    public float getRotationState(float rotationTime) {
        if (this.runningState != 0) {
            return this.currentRotation + (float)this.runningState * this.speed * rotationTime * (float)this.waterMod;
        }
        return this.currentRotation;
    }

    @Override
    public boolean isValid() {
        boolean isAir = true;
        boolean hasWater = true;
        if (this.field_145850_b.func_180495_p(this.field_174879_c) != null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == BWRegistry.waterwheel) {
            IAxle axle = (IAxle)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
            int axis = axle.getAxisAlignment((IBlockAccess)this.field_145850_b, this.field_174879_c);
            for (int i = -2; i < 3; ++i) {
                for (int j = -2; j < 3; ++j) {
                    int xPos = axis == 1 ? i : 0;
                    int yPos = j;
                    int zPos = axis == 2 ? i : 0;
                    BlockPos offset = this.field_174879_c.func_177982_a(xPos, yPos, zPos);
                    if (j == -2) {
                        boolean bl = hasWater = this.field_145850_b.func_180495_p(offset).func_177230_c() instanceof BlockLiquid && this.field_145850_b.func_180495_p(offset).func_177230_c().func_149688_o(this.field_145850_b.func_180495_p(offset)) == Material.field_151586_h || this.field_145850_b.func_180495_p(offset).func_177230_c() instanceof IFluidBlock && this.field_145850_b.func_180495_p(offset).func_177230_c().func_149688_o(this.field_145850_b.func_180495_p(offset)) == Material.field_151586_h;
                    }
                    if (!hasWater && !(hasWater = this.sidesHaveWater())) break;
                    if (i == 0 && j == 0) continue;
                    if (j > -2) {
                        isAir = j != -2 && (i == -2 || i == 2) ? this.field_145850_b.func_175623_d(offset) || this.field_145850_b.func_180495_p(offset).func_177230_c() instanceof BlockLiquid && this.field_145850_b.func_180495_p(offset).func_177230_c().func_149688_o(this.field_145850_b.func_180495_p(offset)) == Material.field_151586_h || this.field_145850_b.func_180495_p(offset).func_177230_c() instanceof IFluidBlock && this.field_145850_b.func_180495_p(offset).func_177230_c().func_149688_o(this.field_145850_b.func_180495_p(offset)) == Material.field_151586_h : this.field_145850_b.func_175623_d(offset);
                    }
                    if (!isAir) break;
                }
                if (!isAir || !hasWater) break;
            }
        }
        return isAir && hasWater;
    }

    public boolean sidesHaveWater() {
        IAxle axle = (IAxle)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        int axis = axle.getAxisAlignment((IBlockAccess)this.field_145850_b, this.field_174879_c);
        int leftWater = 0;
        int rightWater = 0;
        boolean bottomIsUnobstructed = true;
        for (int i = -2; i < 3; ++i) {
            int xP1 = axis == 1 ? -2 : 0;
            int xP2 = axis == 1 ? 2 : 0;
            int zP1 = axis == 2 ? -2 : 0;
            int zP2 = axis == 2 ? 2 : 0;
            int xPos1 = xP1;
            int xPos2 = xP2;
            int yPos = i;
            int zPos1 = zP1;
            int zPos2 = zP2;
            BlockPos leftPos = this.field_174879_c.func_177982_a(xPos1, yPos, zPos1);
            Block leftBlock = this.field_145850_b.func_180495_p(leftPos).func_177230_c();
            BlockPos rightPos = this.field_174879_c.func_177982_a(xPos2, yPos, zPos2);
            Block rightBlock = this.field_145850_b.func_180495_p(rightPos).func_177230_c();
            if (leftBlock instanceof BlockLiquid || leftBlock instanceof IFluidBlock) {
                ++leftWater;
            } else if (rightBlock instanceof BlockLiquid || rightBlock instanceof IFluidBlock) {
                ++rightWater;
            }
            int xP = axis == 1 ? i : 0;
            int yP = -2;
            int zP = axis == 2 ? i : 0;
            BlockPos bPos = this.field_174879_c.func_177982_a(xP, yP, zP);
            boolean bl = bottomIsUnobstructed = this.field_145850_b.func_175623_d(bPos) || this.field_145850_b.func_180495_p(bPos).func_177230_c() instanceof BlockLiquid && this.field_145850_b.func_180495_p(bPos).func_177230_c().func_149688_o(this.field_145850_b.func_180495_p(bPos)) == Material.field_151586_h || this.field_145850_b.func_180495_p(bPos).func_177230_c() instanceof IFluidBlock && this.field_145850_b.func_180495_p(bPos).func_177230_c().func_149688_o(this.field_145850_b.func_180495_p(bPos)) == Material.field_151586_h;
            if (!bottomIsUnobstructed) break;
        }
        return !(!bottomIsUnobstructed || leftWater == 0 && rightWater == 0 || leftWater >= rightWater && leftWater <= rightWater);
    }

    @Override
    public void updateSpeed() {
        byte speed = 0;
        if (this.isValid()) {
            int i;
            float[] waterMeta = new float[]{0.0f, 0.0f, 0.0f};
            IAxle axle = (IAxle)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
            int axis = axle.getAxisAlignment((IBlockAccess)this.field_145850_b, this.field_174879_c);
            int leftWater = 0;
            int rightWater = 0;
            for (i = 0; i < 3; ++i) {
                int zP;
                int metaPos = i - 1;
                int xP = axis == 1 ? metaPos : 0;
                BlockPos lowPos = this.field_174879_c.func_177982_a(xP, -2, zP = axis == 2 ? metaPos : 0);
                if (this.field_145850_b.func_180495_p(lowPos).func_177230_c() instanceof BlockLiquid) {
                    int meta = ((BlockLiquid)this.field_145850_b.func_180495_p(lowPos).func_177230_c()).func_176201_c(this.field_145850_b.func_180495_p(lowPos));
                    BlockLiquid cfr_ignored_0 = (BlockLiquid)this.field_145850_b.func_180495_p(lowPos).func_177230_c();
                    waterMeta[i] = BlockLiquid.func_149801_b((int)meta);
                    continue;
                }
                if (!(this.field_145850_b.func_180495_p(lowPos).func_177230_c() instanceof IFluidBlock)) continue;
                int[] opp = new int[]{2, 1, 0};
                IFluidBlock fluid = (IFluidBlock)this.field_145850_b.func_180495_p(lowPos).func_177230_c();
                waterMeta[opp[i]] = fluid.getFilledPercentage(this.field_145850_b, lowPos);
            }
            for (i = -1; i < 3; ++i) {
                int xP1 = axis == 1 ? -2 : 0;
                int xP2 = axis == 1 ? 2 : 0;
                int zP1 = axis == 2 ? -2 : 0;
                int zP2 = axis == 2 ? 2 : 0;
                BlockPos leftPos = this.field_174879_c.func_177982_a(xP1, i, zP1);
                BlockPos rightPos = this.field_174879_c.func_177982_a(xP2, i, zP2);
                Block leftBlock = this.field_145850_b.func_180495_p(leftPos).func_177230_c();
                Block rightBlock = this.field_145850_b.func_180495_p(rightPos).func_177230_c();
                if (leftBlock instanceof BlockLiquid || leftBlock instanceof IFluidBlock) {
                    ++leftWater;
                    continue;
                }
                if (!(rightBlock instanceof BlockLiquid) && !(rightBlock instanceof IFluidBlock)) continue;
                ++rightWater;
            }
            this.waterMod = leftWater > rightWater || waterMeta[0] < waterMeta[1] && waterMeta[1] < waterMeta[2] && leftWater >= rightWater ? (byte)-1 : (rightWater > leftWater || waterMeta[0] > waterMeta[1] && waterMeta[1] > waterMeta[2] && rightWater >= leftWater ? (byte)1 : 0);
            if (this.waterMod != 0) {
                speed = 1;
            }
        }
        if (speed != this.runningState) {
            this.setRunningState(speed);
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockWaterwheel.ISACTIVE, (Comparable)Boolean.valueOf(speed > 0)));
            this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), this.func_145838_q().func_149738_a(this.field_145850_b), 5);
        }
    }

    @Override
    public void overpower() {
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager mgr, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockWaterwheel) {
            int xP = ((BlockWaterwheel)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).getAxisAlignment((IBlockAccess)this.field_145850_b, this.field_174879_c) == 1 ? this.radius : 0;
            int yP = this.radius;
            int zP = ((BlockWaterwheel)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).getAxisAlignment((IBlockAccess)this.field_145850_b, this.field_174879_c) == 2 ? this.radius : 0;
            return new AxisAlignedBB((double)(x - xP - 1), (double)(y - yP - 1), (double)(z - zP - 1), (double)(x + xP + 1), (double)(y + yP + 1), (double)(z + zP + 1));
        }
        return super.getRenderBoundingBox();
    }
}

