/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks.tile.gen;

import betterwithmods.BWRegistry;
import betterwithmods.api.block.IMechanicalBlock;
import betterwithmods.blocks.BlockAxle;
import betterwithmods.blocks.BlockWindmill;
import betterwithmods.blocks.tile.gen.IColor;
import betterwithmods.blocks.tile.gen.TileEntityMechGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityWindmillHorizontal
extends TileEntityMechGenerator
implements IColor {
    public int[] bladeMeta = new int[]{0, 0, 0, 0};

    public TileEntityWindmillHorizontal() {
        this.radius = 7;
    }

    public int getBladeColor(int blade) {
        return this.bladeMeta[blade];
    }

    @Override
    public int getColorFromBlade(int blade) {
        return this.bladeMeta[blade];
    }

    @Override
    public boolean dyeBlade(int dyeColor) {
        boolean dyed = false;
        if (this.bladeMeta[this.dyeIndex] != dyeColor) {
            this.bladeMeta[this.dyeIndex] = dyeColor;
            dyed = true;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.func_70296_d();
        }
        this.dyeIndex = (byte)(this.dyeIndex + 1);
        if (this.dyeIndex > 3) {
            this.dyeIndex = 0;
        }
        return dyed;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (int i = 0; i < 4; ++i) {
            if (!tag.func_74764_b("Color_" + i)) continue;
            this.bladeMeta[i] = tag.func_74762_e("Color_" + i);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        for (int i = 0; i < 4; ++i) {
            t.func_74768_a("Color_" + i, this.bladeMeta[i]);
        }
        t.func_74774_a("DyeIndex", this.dyeIndex);
        return t;
    }

    @Override
    public void updateSpeed() {
        int speed = 0;
        if (this.isValid() && !this.isGalacticraftDimension() && this.isNotOtherDimension()) {
            speed = this.field_145850_b.field_73011_w.func_186058_p() == DimensionType.OVERWORLD && (this.field_145850_b.func_72896_J() || this.field_145850_b.func_72911_I()) ? 2 : 1;
        }
        if (speed != this.runningState) {
            this.setRunningState(speed);
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockWindmill.ISACTIVE, (Comparable)Boolean.valueOf(speed > 0)));
            this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), this.func_145838_q().func_149738_a(this.field_145850_b), 5);
        }
    }

    public boolean isNotOtherDimension() {
        return this.field_145850_b.field_73011_w.func_186058_p() != DimensionType.NETHER && this.field_145850_b.field_73011_w.func_186058_p() != DimensionType.THE_END;
    }

    public boolean isGalacticraftDimension() {
        boolean isDimension = false;
        if (Loader.isModLoaded((String)"GalacticraftCore")) {
            isDimension = false;
        }
        return isDimension;
    }

    @Override
    public void overpower() {
        BlockWindmill block = (BlockWindmill)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        int align = block.getAxisAlignment((IBlockAccess)this.field_145850_b, this.field_174879_c);
        EnumFacing[] dir = BlockAxle.facings[align];
        for (int i = 0; i < 2; ++i) {
            BlockPos offset = this.field_174879_c.func_177972_a(dir[i]);
            Block axle = this.field_145850_b.func_180495_p(offset).func_177230_c();
            if (axle instanceof BlockAxle) {
                ((BlockAxle)axle).overpower(this.field_145850_b, offset);
                continue;
            }
            if (!(axle instanceof IMechanicalBlock) || !((IMechanicalBlock)axle).canInputPowerToSide((IBlockAccess)this.field_145850_b, offset, dir[i].func_176734_d())) continue;
            ((IMechanicalBlock)axle).overpower(this.field_145850_b, offset);
        }
    }

    @Override
    public boolean isValid() {
        boolean valid = true;
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == BWRegistry.windmillBlock) {
            BlockWindmill axle = (BlockWindmill)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
            int axis = axle.getAxisAlignment((IBlockAccess)this.field_145850_b, this.field_174879_c);
            for (int vert = -6; vert <= 6; ++vert) {
                for (int i = -6; i <= 6; ++i) {
                    int xP = axis == 1 ? i : 0;
                    int zP = axis == 2 ? i : 0;
                    int xPos = xP;
                    int yPos = vert;
                    int zPos = zP;
                    BlockPos offset = this.field_174879_c.func_177982_a(xPos, yPos, zPos);
                    if ((xP != 0 || yPos != 0 || zP != 0) && !(valid = this.field_145850_b.func_175623_d(offset))) break;
                }
                if (!valid) break;
            }
        }
        return valid && this.field_145850_b.func_175710_j(this.field_174879_c);
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager mgr, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockWindmill) {
            int xP = ((BlockWindmill)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).getAxisAlignment((IBlockAccess)this.field_145850_b, this.field_174879_c) == 1 ? this.radius : 0;
            int yP = this.radius;
            int zP = ((BlockWindmill)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c()).getAxisAlignment((IBlockAccess)this.field_145850_b, this.field_174879_c) == 2 ? this.radius : 0;
            return new AxisAlignedBB((double)(x - xP - 1), (double)(y - yP - 1), (double)(z - zP - 1), (double)(x + xP + 1), (double)(y + yP + 1), (double)(z + zP + 1));
        }
        return super.getRenderBoundingBox();
    }
}

