/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.blocks.tile.gen;

import betterwithmods.BWRegistry;
import betterwithmods.api.block.IMechanicalBlock;
import betterwithmods.blocks.BlockAxle;
import betterwithmods.blocks.BlockWindmill;
import betterwithmods.blocks.tile.gen.IColor;
import betterwithmods.blocks.tile.gen.TileEntityMechGenerator;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityWindmillVertical
extends TileEntityMechGenerator
implements IColor {
    public int[] bladeMeta = new int[]{0, 0, 0, 0, 0, 0, 0, 0};
    public int offsetY = 0;
    public boolean isValid = true;

    public int getBladeColor(int blade) {
        return this.bladeMeta[blade];
    }

    @Override
    public int getColorFromBlade(int blade) {
        return this.bladeMeta[blade];
    }

    @Override
    public boolean dyeBlade(int dyeColor) {
        boolean dyed = false;
        if (this.bladeMeta[this.dyeIndex] != dyeColor) {
            this.bladeMeta[this.dyeIndex] = dyeColor;
            dyed = true;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            this.func_70296_d();
        }
        this.dyeIndex = (byte)(this.dyeIndex + 1);
        if (this.dyeIndex > 7) {
            this.dyeIndex = 0;
        }
        return dyed;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (int i = 0; i < 8; ++i) {
            if (!tag.func_74764_b("Color_" + i)) continue;
            this.bladeMeta[i] = tag.func_74762_e("Color_" + i);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        for (int i = 0; i < 8; ++i) {
            t.func_74768_a("Color_" + i, this.bladeMeta[i]);
        }
        t.func_74774_a("DyeIndex", this.dyeIndex);
        return t;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int offset) {
        this.offsetY = offset;
    }

    @Override
    public boolean isValid() {
        return this.isMasterValid();
    }

    public boolean isSlaveValid(int offset) {
        boolean notBlocked = true;
        int airCounter = 0;
        for (int x = -4; x < 5; ++x) {
            for (int z = -4; z < 5; ++z) {
                int offX = x;
                int offY = offset;
                int offZ = z;
                BlockPos offPos = this.field_174879_c.func_177982_a(offX, offY, offZ);
                if (x == 0 && z == 0 && this.field_145850_b.func_180495_p(offPos).func_177230_c() instanceof BlockAxle && ((BlockAxle)this.field_145850_b.func_180495_p(offPos).func_177230_c()).getAxisAlignment((IBlockAccess)this.field_145850_b, offPos) == 0) continue;
                if (this.field_145850_b.field_73011_w.func_186058_p() == DimensionType.NETHER) {
                    notBlocked = this.field_145850_b.func_175623_d(offPos);
                } else if (this.field_145850_b.field_73011_w.func_186058_p() != DimensionType.NETHER) {
                    notBlocked = this.field_145850_b.func_175623_d(offPos);
                    if (this.field_145850_b.func_175710_j(offPos)) {
                        ++airCounter;
                    }
                }
                if (!notBlocked) break;
            }
            if (!notBlocked) break;
        }
        if (this.field_145850_b.field_73011_w.func_186058_p() != DimensionType.NETHER) {
            return notBlocked && airCounter > 25;
        }
        return notBlocked;
    }

    public boolean isMasterValid() {
        boolean valid = true;
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() == BWRegistry.windmillBlock) {
            for (int i = -3; i < 4 && (i == 0 || (valid = this.isSlaveValid(i))); ++i) {
            }
        }
        return valid;
    }

    @Override
    public boolean verifyIntegrity() {
        return this.masterHasIntegrity();
    }

    public boolean masterHasIntegrity() {
        boolean integrity = true;
        for (int offY = -3; offY < 4; ++offY) {
            int masterY = offY;
            BlockPos offset = this.field_174879_c.func_177982_a(0, masterY, 0);
            if (offY == 0) continue;
            boolean bl = integrity = this.field_145850_b.func_180495_p(offset).func_177230_c() instanceof BlockAxle && ((BlockAxle)this.field_145850_b.func_180495_p(offset).func_177230_c()).getAxisAlignment((IBlockAccess)this.field_145850_b, offset) == 0;
            if (integrity) continue;
            BlockWindmill.invalidatedVerticalWindmill(this.field_145850_b, this.field_174879_c);
            break;
        }
        return integrity;
    }

    @Override
    public void overpower() {
        BlockWindmill block = (BlockWindmill)this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c();
        int align = block.getAxisAlignment((IBlockAccess)this.field_145850_b, this.field_174879_c);
        EnumFacing[] dir = BlockAxle.facings[align];
        for (int i = 0; i < 2; ++i) {
            BlockPos offset = this.field_174879_c.func_177972_a(dir[i]);
            Block axle = this.field_145850_b.func_180495_p(offset).func_177230_c();
            if (axle instanceof BlockAxle) {
                ((BlockAxle)axle).overpower(this.field_145850_b, offset);
                continue;
            }
            if (!(axle instanceof IMechanicalBlock) || !((IMechanicalBlock)axle).canInputPowerToSide((IBlockAccess)this.field_145850_b, offset, dir[i].func_176734_d())) continue;
            ((IMechanicalBlock)axle).overpower(this.field_145850_b, offset);
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound tag = this.func_189517_E_();
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), tag);
    }

    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager mgr, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public void updateSpeed() {
        int speed = 0;
        if (this.isValid() && !this.isGalacticraftDimension() && this.isNotOtherDimension()) {
            speed = this.field_145850_b.func_72896_J() || this.field_145850_b.func_72911_I() ? 2 : 1;
        }
        if (speed != this.runningState && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockWindmill) {
            this.setRunningState(speed);
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockWindmill.ISACTIVE, (Comparable)Boolean.valueOf(speed > 0)));
            this.field_145850_b.func_180497_b(this.field_174879_c, this.func_145838_q(), this.func_145838_q().func_149738_a(this.field_145850_b), 5);
        }
    }

    public boolean isNotOtherDimension() {
        return this.field_145850_b.field_73011_w.func_186058_p() != DimensionType.THE_END;
    }

    public boolean isGalacticraftDimension() {
        boolean isDimension = false;
        if (Loader.isModLoaded((String)"GalacticraftCore")) {
            isDimension = false;
        }
        return isDimension;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() != null && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockWindmill) {
            return new AxisAlignedBB((double)(x - 4), (double)(y - 4), (double)(z - 4), (double)(x + 4), (double)(y + 4), (double)(z + 4));
        }
        return super.getRenderBoundingBox();
    }
}

