/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.craft.bulk;

import betterwithmods.craft.OreStack;
import betterwithmods.util.InvUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class BulkRecipe {
    protected ItemStack output = null;
    protected ItemStack secondary = null;
    protected ArrayList<Object> input = new ArrayList();
    protected ArrayList<Object> jeiInput = new ArrayList();
    private static int width;
    private static int depth;

    public BulkRecipe(String type, ItemStack output, Object ... input) {
        this(type, output, null, input);
    }

    public BulkRecipe(String type, ItemStack output, ItemStack secondaryOutput, Object ... input) {
        this.output = output.func_77946_l();
        if (secondaryOutput != null) {
            this.secondary = secondaryOutput.func_77946_l();
        }
        int place = -1;
        for (Object in : input) {
            ++place;
            if (in instanceof ItemStack) {
                this.input.add(((ItemStack)in).func_77946_l());
                this.jeiInput.add(((ItemStack)in).func_77946_l());
                continue;
            }
            if (in instanceof Item) {
                this.input.add(new ItemStack((Item)in));
                this.jeiInput.add(new ItemStack((Item)in));
                continue;
            }
            if (in instanceof Block) {
                this.input.add(new ItemStack((Block)in));
                this.jeiInput.add(new ItemStack((Block)in));
                continue;
            }
            if (in instanceof String) {
                if (place + 1 < input.length) {
                    if (input[place + 1] instanceof Integer) {
                        this.input.add(new OreStack((String)in, (Integer)input[place + 1]));
                        this.jeiInput.add(this.getOreList(new OreStack((String)in, (Integer)input[place + 1])));
                        continue;
                    }
                    this.input.add(new OreStack((String)in, 1));
                    this.jeiInput.add(this.getOreList(new OreStack((String)in, 1)));
                    continue;
                }
                this.input.add(new OreStack((String)in, 1));
                this.jeiInput.add(this.getOreList(new OreStack((String)in, 1)));
                continue;
            }
            if (in instanceof Integer) continue;
            if (in instanceof OreStack) {
                this.input.add(((OreStack)in).copy());
                this.jeiInput.add(this.getOreList(((OreStack)in).copy()));
                continue;
            }
            String ret = "Invalid " + type + " recipe: ";
            for (Object tmp : input) {
                ret = ret + tmp + ", ";
            }
            ret = ret + "Output: " + output;
            if (secondaryOutput != null) {
                ret = ret + ", Secondary: " + secondaryOutput;
            }
            throw new RuntimeException(ret);
        }
        if (place > 2) {
            depth = 2;
            width = place - 2;
        } else {
            depth = 1;
            width = place + 1;
        }
    }

    private List<ItemStack> getOreList(OreStack stack) {
        int stackSize = stack.getStackSize();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (stack.getOres() != null && !stack.getOres().isEmpty()) {
            for (ItemStack s : stack.getOres()) {
                list.add(new ItemStack(s.func_77973_b(), stackSize, s.func_77952_i()));
            }
        }
        return list;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public ItemStack getSecondary() {
        return this.secondary;
    }

    public ArrayList<Object> getInput() {
        return this.jeiInput;
    }

    public boolean matches(IInventory inv) {
        ArrayList<Object> required = new ArrayList<Object>(this.input);
        if (required != null && required.size() > 0) {
            for (Object obj : required) {
                Object stack;
                if (!(obj instanceof ItemStack ? (stack = (ItemStack)obj) != null && InvUtils.countItemsInInventory(inv, stack.func_77973_b(), stack.func_77952_i()) < ((ItemStack)stack).field_77994_a : obj instanceof OreStack && (stack = (OreStack)obj) != null && InvUtils.countOresInInv(inv, ((OreStack)stack).getOres()) < ((OreStack)stack).getStackSize())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean matches(BulkRecipe recipe) {
        if (this.getOutput() != null && recipe.getOutput() != null) {
            boolean match = this.stacksMatch(this.getOutput(), recipe.getOutput());
            if (match && (this.getSecondary() != null || recipe.getSecondary() != null)) {
                boolean bl = match = this.getSecondary() != null && recipe.getSecondary() != null;
                if (match) {
                    match = this.stacksMatch(this.getSecondary(), recipe.getSecondary());
                }
            }
            return match;
        }
        return false;
    }

    public boolean consumeInvIngredients(IInventory inv) {
        boolean success = true;
        ArrayList<Object> required = new ArrayList<Object>(this.input);
        if (required != null && required.size() > 0) {
            for (Object obj : required) {
                Object stack;
                if (obj instanceof ItemStack) {
                    stack = (ItemStack)obj;
                    if (stack == null || InvUtils.consumeItemsInInventory(inv, stack.func_77973_b(), stack.func_77952_i(), ((ItemStack)stack).field_77994_a)) continue;
                    success = false;
                    continue;
                }
                if (!(obj instanceof OreStack) || (stack = (OreStack)obj) == null || InvUtils.consumeOresInInventory(inv, ((OreStack)stack).getOres(), ((OreStack)stack).getStackSize())) continue;
                success = false;
            }
        }
        return success;
    }

    public boolean stacksMatch(ItemStack first, ItemStack second) {
        return first.func_77973_b() == second.func_77973_b() && first.func_77952_i() == second.func_77952_i() && first.field_77994_a == second.field_77994_a;
    }

    public boolean oresMatch(OreStack first, OreStack second) {
        return first.getOreName() == second.getOreName() && first.getStackSize() == second.getStackSize();
    }

    public int getWidth() {
        return width;
    }

    public int getDepth() {
        return depth;
    }
}

