/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.craft.bulk;

import betterwithmods.craft.bulk.BulkRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public abstract class CraftingManagerBulk {
    private String craftType;
    private List<BulkRecipe> recipes;

    public CraftingManagerBulk(String craftType) {
        this.craftType = craftType;
        this.recipes = new ArrayList<BulkRecipe>();
    }

    public void addOreRecipe(ItemStack output, Object[] inputs) {
        this.addOreRecipe(output, (ItemStack)null, inputs);
    }

    public void addOreRecipe(ItemStack output, ItemStack secondary, Object input) {
        Object[] inputs = new Object[]{input};
        this.addOreRecipe(output, secondary, inputs);
    }

    public void addOreRecipe(ItemStack output, Object input) {
        this.addOreRecipe(output, null, input);
    }

    public void addOreRecipe(ItemStack output, ItemStack secondary, Object[] inputs) {
        BulkRecipe recipe = this.createRecipe(output, secondary, inputs);
        this.recipes.add(recipe);
    }

    public void addRecipe(ItemStack output, ItemStack[] inputs) {
        this.addRecipe(output, null, inputs);
    }

    public void addRecipe(ItemStack output, ItemStack secondary, ItemStack input) {
        ItemStack[] inputs = new ItemStack[]{input.func_77946_l()};
        this.addRecipe(output, secondary, inputs);
    }

    public void addRecipe(ItemStack output, ItemStack input) {
        this.addRecipe(output, null, input);
    }

    public void addRecipe(ItemStack output, ItemStack secondary, ItemStack[] inputs) {
        BulkRecipe recipe = this.createRecipe(output, secondary, inputs);
        this.recipes.add(recipe);
    }

    public boolean removeRecipe(ItemStack output, Object[] inputs) {
        return this.removeRecipe(output, (ItemStack)null, inputs);
    }

    public boolean removeRecipe(ItemStack output, ItemStack secondary, Object input) {
        Object[] inputs = new Object[]{input};
        return this.removeRecipe(output, secondary, inputs);
    }

    public boolean removeRecipe(ItemStack output, Object input) {
        return this.removeRecipe(output, null, input);
    }

    public boolean removeRecipe(ItemStack output, ItemStack secondary, Object[] inputs) {
        BulkRecipe recipe = this.createRecipe(output, secondary, inputs);
        int matchingIndex = this.getMatchingRecipeIndex(recipe);
        if (matchingIndex >= 0) {
            this.recipes.remove(matchingIndex);
            return true;
        }
        return false;
    }

    public ItemStack[] getCraftingResult(IInventory inv) {
        for (BulkRecipe recipe : this.recipes) {
            if (!recipe.matches(inv)) continue;
            ItemStack[] ret = new ItemStack[1];
            if (recipe.getSecondary() != null) {
                ret = new ItemStack[2];
                ret[1] = recipe.getSecondary();
            }
            ret[0] = recipe.getOutput();
            return ret;
        }
        return null;
    }

    public List<Object> getValidCraftingIngredients(IInventory inv) {
        for (int i = 0; i < this.recipes.size(); ++i) {
            BulkRecipe recipe = this.recipes.get(i);
            if (!recipe.matches(inv)) continue;
            return recipe.getInput();
        }
        return null;
    }

    public ItemStack[] consumeIngredientsAndReturnResult(IInventory inv) {
        for (BulkRecipe recipe : this.recipes) {
            if (!recipe.matches(inv)) continue;
            ItemStack[] ret = new ItemStack[1];
            if (recipe.getSecondary() != null) {
                ret = new ItemStack[2];
                ret[1] = recipe.getSecondary();
            }
            ret[0] = recipe.getOutput();
            recipe.consumeInvIngredients(inv);
            return ret;
        }
        return null;
    }

    private BulkRecipe createRecipe(ItemStack output, ItemStack secondary, Object[] inputs) {
        Object[] inputArray = inputs;
        return new BulkRecipe(this.craftType, output, secondary, inputs);
    }

    private int getMatchingRecipeIndex(BulkRecipe recipe) {
        for (int i = 0; i < this.recipes.size(); ++i) {
            BulkRecipe tempRecipe = this.recipes.get(i);
            if (!tempRecipe.matches(recipe)) continue;
            return i;
        }
        return -1;
    }

    public List<BulkRecipe> getRecipes() {
        return this.recipes;
    }
}

