/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.event;

import betterwithmods.BWRegistry;
import betterwithmods.config.BWConfig;
import java.util.Random;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class MobDropEvent {
    private static int[] fearLevel = new int[]{1600, 1500, 1400, 1300, 1200, 1100, 1000, 900, 800, 700, 600, 500, 400, 300, 200, 100};
    private static Random rand = new Random();

    @SubscribeEvent
    public void mobDungProduction(LivingEvent.LivingUpdateEvent evt) {
        if (evt.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        if (evt.getEntityLiving() instanceof EntityAnimal) {
            EntityAnimal animal = (EntityAnimal)evt.getEntityLiving();
            if (animal instanceof EntityWolf) {
                if (!animal.field_70170_p.func_175678_i(animal.func_180425_c())) {
                    // empty if block
                }
                if (animal.func_70874_b() > 99) {
                    int light = animal.field_70170_p.func_175699_k(animal.func_180425_c());
                    if (animal.func_70874_b() == fearLevel[light]) {
                        evt.getEntityLiving().func_70099_a(new ItemStack(BWRegistry.material, 1, 5), 0.0f);
                        animal.func_70873_a(99);
                    }
                }
            }
            if (!(animal instanceof EntityRabbit)) {
                if (animal.func_70874_b() == 100) {
                    evt.getEntityLiving().func_70099_a(new ItemStack(BWRegistry.material, 1, 5), 0.0f);
                } else if (animal.func_70880_s() && rand.nextInt(1200) == 0) {
                    evt.getEntityLiving().func_70099_a(new ItemStack(BWRegistry.material, 1, 5), 0.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public void mobDiesBySaw(LivingDropsEvent evt) {
        if (evt.getSource().field_76373_n.equals("saw") || evt.getSource().field_76373_n.equals("choppingBlock")) {
            for (EntityItem item : evt.getDrops()) {
                ItemStack stack = item.func_92059_d();
                if (stack.func_77976_d() == 1 || !evt.getEntity().field_70170_p.field_73012_v.nextBoolean()) continue;
                item.func_92058_a(new ItemStack(stack.func_77973_b(), stack.field_77994_a + 1, stack.func_77952_i()));
            }
            if (evt.getEntityLiving() instanceof EntityAgeable) {
                this.addDrop(evt, new ItemStack(BWRegistry.material, 1, 5));
            }
            int headChance = evt.getEntityLiving().field_70170_p.field_73012_v.nextInt(12);
            if (evt.getSource().field_76373_n.equals("choppingBlock") && headChance < 5) {
                if (evt.getEntityLiving() instanceof EntitySkeleton) {
                    EntitySkeleton skeltal = (EntitySkeleton)evt.getEntityLiving();
                    this.addDrop(evt, new ItemStack(Items.field_151144_bL, 1, skeltal.func_82202_m()));
                } else if (evt.getEntityLiving() instanceof EntityZombie) {
                    this.addDrop(evt, new ItemStack(Items.field_151144_bL, 1, 2));
                } else if (evt.getEntityLiving() instanceof EntityCreeper) {
                    this.addDrop(evt, new ItemStack(Items.field_151144_bL, 1, 4));
                } else if (evt.getEntityLiving() instanceof EntityPlayer) {
                    EntityPlayer player = (EntityPlayer)evt.getEntityLiving();
                    ItemStack drop = new ItemStack(Items.field_151144_bL, 1, 3);
                    NBTTagCompound name = new NBTTagCompound();
                    name.func_74778_a("SkullOwner", player.getDisplayNameString());
                    drop.func_77982_d(name);
                    this.addDrop(evt, drop);
                }
            }
        }
    }

    @SubscribeEvent
    public void mobDrops(LivingDropsEvent evt) {
        if (!BWConfig.hardcoreGunpowder) {
            return;
        }
        if (evt.getEntity() instanceof EntityCreeper || evt.getEntity() instanceof EntityGhast) {
            for (EntityItem item : evt.getDrops()) {
                ItemStack stack = item.func_92059_d();
                if (stack.func_77973_b() != Items.field_151016_H) continue;
                if (rand.nextBoolean()) {
                    item.func_92058_a(new ItemStack(BWRegistry.material, stack.field_77994_a, 26));
                    continue;
                }
                item.func_92058_a(new ItemStack(BWRegistry.material, stack.field_77994_a, 25));
            }
        }
    }

    public void addDrop(LivingDropsEvent evt, ItemStack drop) {
        EntityItem item = new EntityItem(evt.getEntityLiving().field_70170_p, evt.getEntityLiving().field_70165_t, evt.getEntityLiving().field_70163_u, evt.getEntityLiving().field_70161_v, drop);
        item.func_174869_p();
        evt.getDrops().add(item);
    }
}

