/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.event;

import betterwithmods.config.BWConfig;
import betterwithmods.util.NetherSpawnWhitelist;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DimensionType;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class NetherSpawnEvent {
    private static Random rand = new Random();

    @SubscribeEvent
    public void giveEndermenEndStone(LivingSpawnEvent evt) {
        EntityLivingBase entity = evt.getEntityLiving();
        if (evt.getWorld().field_73011_w.func_186058_p() == DimensionType.THE_END && entity instanceof EntityEnderman && rand.nextInt(2000) == 0) {
            ((EntityEnderman)entity).func_175490_a(Blocks.field_150377_bs.func_176223_P());
        }
    }

    @SubscribeEvent
    public void generateMossNearSpawner(LivingSpawnEvent evt) {
        EntityLivingBase entity = evt.getEntityLiving();
        BlockPos pos = new BlockPos(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        boolean nearSpawner = evt.getWorld().func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150474_ac;
        BlockPos spawn = pos.func_177977_b();
        if (nearSpawner) {
            int x = rand.nextInt(9) - 4;
            int y = rand.nextInt(5) - 1;
            int z = rand.nextInt(9) - 4;
            BlockPos check = spawn.func_177982_a(x, y, z);
            IBlockState state = evt.getWorld().func_180495_p(check);
            if ((state.func_177230_c() == Blocks.field_150347_e || state.func_177230_c() == Blocks.field_150417_aV && state.func_177230_c().func_176201_c(state) == 0) && rand.nextInt(30) == 0) {
                IBlockState changeState = state.func_177230_c() == Blocks.field_150347_e ? Blocks.field_150341_Y.func_176223_P() : Blocks.field_150417_aV.func_176203_a(1);
                evt.getWorld().func_175656_a(check, changeState);
            }
        }
    }

    @SubscribeEvent
    public void denySlimeSpawns(LivingSpawnEvent.CheckSpawn evt) {
        if (evt.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (!BWConfig.slimeSpawn) {
            return;
        }
        if (evt.getWorld() != null && evt.getWorld().field_73011_w.func_186058_p() == DimensionType.OVERWORLD && evt.getEntityLiving() instanceof EntitySlime) {
            BlockPos pos = new BlockPos(evt.getEntity().field_70165_t, evt.getEntity().field_70163_u - 1.0, evt.getEntity().field_70161_v);
            if (evt.getWorld().func_180495_p(pos).func_185904_a() != Material.field_151577_b && evt.getWorld().func_180495_p(pos).func_185904_a() != Material.field_151576_e && evt.getWorld().func_180495_p(pos).func_185904_a() != Material.field_151578_c) {
                evt.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public void denyNetherSpawns(LivingSpawnEvent.CheckSpawn evt) {
        if (evt.getResult() == Event.Result.ALLOW) {
            return;
        }
        if (!BWConfig.netherSpawn) {
            return;
        }
        if (evt.getWorld() != null && evt.getWorld().field_73011_w.getDimension() == -1 && evt.getEntityLiving().isCreatureType(EnumCreatureType.MONSTER, false)) {
            int meta;
            double monX = evt.getEntity().field_70165_t;
            double monY = evt.getEntity().field_70163_u;
            double monZ = evt.getEntity().field_70161_v;
            int x = MathHelper.func_76128_c((double)monX);
            int y = MathHelper.func_76128_c((double)monY);
            int z = MathHelper.func_76128_c((double)monZ);
            BlockPos pos = new BlockPos(x, y - 1, z);
            Block block = evt.getWorld().func_180495_p(pos).func_177230_c();
            if (!NetherSpawnWhitelist.contains(block, meta = evt.getWorld().func_180495_p(pos).func_177230_c().func_176201_c(evt.getWorld().func_180495_p(pos)))) {
                evt.setResult(Event.Result.DENY);
            }
        }
    }
}

