/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.integration;

import betterwithmods.BWMod;
import betterwithmods.integration.tcon.TraitMending;
import betterwithmods.util.NetherSpawnWhitelist;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;
import slimeknights.mantle.util.RecipeMatch;
import slimeknights.tconstruct.library.MaterialIntegration;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.client.MaterialRenderInfo;
import slimeknights.tconstruct.library.fluid.FluidMolten;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.smeltery.MeltingRecipe;
import slimeknights.tconstruct.library.traits.AbstractTrait;
import slimeknights.tconstruct.library.traits.ITrait;
import slimeknights.tconstruct.tools.TinkerMaterials;

public class TConstruct {
    public static final Material soulforgedSteel = TConstruct.mat("soulforgedSteel", 0x4D4D4D);
    public static final Material hellfire = TConstruct.mat("hellfire", 14426647);
    public static AbstractTrait mending;
    public static FluidMolten soulforgeFluid;
    public static FluidMolten hellfireFluid;

    public static void init() {
        mending = new TraitMending();
        if (BWMod.proxy.isClientside()) {
            TConstruct.registerRenderInfo(soulforgedSteel, 0x4D4D4D, 0.1f, 0.3f, 0.1f);
        }
        soulforgeFluid = TConstruct.fluidMetal("soulforged_steel", 0x4D4D4D);
        soulforgeFluid.setTemperature(681);
        soulforgedSteel.addItem("ingotSoulforgedSteel", 1, 144);
        soulforgedSteel.addTrait((ITrait)mending);
        if (BWMod.proxy.isClientside()) {
            TConstruct.registerRenderInfo(hellfire, 14426647, 0.0f, 0.2f, 0.0f);
        }
        hellfireFluid = TConstruct.fluidMetal("hellfire", 14426647);
        hellfireFluid.setTemperature(850);
        hellfire.addItem("ingotHellfire", 1, 144);
        hellfire.addTrait((ITrait)TinkerMaterials.autosmelt);
        TinkerRegistry.addMaterialStats((Material)soulforgedSteel, (IMaterialStats)new HeadMaterialStats(875, 12.0f, 6.0f, 3), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(1.0f, 225), new ExtraMaterialStats(50)});
        TinkerRegistry.addMaterialStats((Material)hellfire, (IMaterialStats)new HeadMaterialStats(325, 8.0f, 4.0f, 2), (IMaterialStats[])new IMaterialStats[]{new HandleMaterialStats(0.75f, 75), new ExtraMaterialStats(25)});
        TConstruct.registerMaterial(soulforgedSteel, (Fluid)soulforgeFluid, "SoulforgedSteel");
        TConstruct.registerMaterial(hellfire, (Fluid)hellfireFluid, "Hellfire");
        TConstruct.fixHellfireDust();
        TConstruct.netherWhitelist();
    }

    private static void netherWhitelist() {
        Block ore = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("tconstruct", "ore"));
        NetherSpawnWhitelist.addBlock(ore, 0);
        NetherSpawnWhitelist.addBlock(ore, 1);
        NetherSpawnWhitelist.addBlock((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("tconstruct", "slime_congealed")), 3);
        NetherSpawnWhitelist.addBlock((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("tconstruct", "slime_congealed")), 4);
        NetherSpawnWhitelist.addBlock((Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("tconstruct", "slime_dirt")), 3);
        Block slimeGrass = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation("tconstruct", "slime_grass"));
        NetherSpawnWhitelist.addBlock(slimeGrass, 4);
        NetherSpawnWhitelist.addBlock(slimeGrass, 9);
        NetherSpawnWhitelist.addBlock(slimeGrass, 14);
    }

    private static void registerMaterial(Material material, Fluid fluid, String oreSuffix) {
        MaterialIntegration mat = new MaterialIntegration(material, fluid, oreSuffix).setRepresentativeItem("ingot" + oreSuffix);
        mat.integrate();
        mat.integrateRecipes();
        mat.registerRepresentativeItem();
    }

    private static Material mat(String name, int color) {
        Material mat = new Material(name, color);
        TinkerMaterials.materials.add(mat);
        return mat;
    }

    private static FluidMolten fluidMetal(String name, int color) {
        FluidMolten fluid = new FluidMolten(name, color);
        return TConstruct.registerFluid(fluid);
    }

    private static <T extends Fluid> T registerFluid(T fluid) {
        fluid.setUnlocalizedName("betterwithmods:" + fluid.getName());
        FluidRegistry.registerFluid(fluid);
        return fluid;
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerRenderInfo(Material material, int color, float shininess, float brightness, float hueshift) {
        material.setRenderInfo((MaterialRenderInfo)new MaterialRenderInfo.Metal(color, shininess, brightness, hueshift));
    }

    private static void fixHellfireDust() {
        Pair dustOre = Pair.of((Object)OreDictionary.getOres((String)"powderedHellfire"), (Object)18);
        TinkerRegistry.registerMelting((MeltingRecipe)new MeltingRecipe(RecipeMatch.of((List)((List)dustOre.getLeft()), (int)((Integer)dustOre.getRight())), (Fluid)hellfireFluid));
    }
}

