/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.items;

import betterwithmods.BWRegistry;
import betterwithmods.blocks.BlockAxle;
import betterwithmods.blocks.BlockWaterwheel;
import betterwithmods.blocks.BlockWindmill;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemMechanical
extends Item {
    public String[] names = new String[]{"Windmill", "Waterwheel", "WindmillVertical"};

    public ItemMechanical() {
        this.field_77777_bU = 1;
        this.func_77627_a(true);
        this.func_77655_b("bwm:powerSource");
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block == BWRegistry.axle) {
            int axis = ((BlockAxle)block).getAxisAlignment((IBlockAccess)world, pos);
            if (axis == 0 && stack.func_77952_i() == 2) {
                if (this.isVerticalWindmillValid(player, world, pos, hitY)) {
                    --stack.field_77994_a;
                }
            } else if (axis != 0 && stack.func_77952_i() != 2 && this.isHorizontalDeviceValid(player, world, pos, stack.func_77952_i(), axis)) {
                --stack.field_77994_a;
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private boolean isHorizontalDeviceValid(EntityPlayer player, World world, BlockPos pos, int meta, int axis) {
        boolean valid = false;
        if (meta == 1 && this.validateWaterwheel(world, pos, axis)) {
            if (axis > 0) {
                world.func_175656_a(pos, ((BlockWaterwheel)BWRegistry.waterwheel).getWaterwheelState(axis));
                valid = true;
            }
        } else if (meta == 1 && world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString("Not enough room to place the waterwheel. Need a 5x5 area to work."));
        }
        if (meta == 0 && this.validateWindmill(world, pos, axis)) {
            if (axis > 0) {
                world.func_175656_a(pos, ((BlockWindmill)BWRegistry.windmillBlock).getWindmillState(axis));
                valid = true;
            }
        } else if (meta == 0 && world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString("Not enough room to place the windmill. Need a 13x13 area to work."));
        }
        return valid;
    }

    public boolean validateWaterwheel(World world, BlockPos pos, int axis) {
        return this.validateHorizontal(world, pos, 2, axis, true);
    }

    public boolean validateWindmill(World world, BlockPos pos, int axis) {
        return this.validateHorizontal(world, pos, 6, axis, false);
    }

    public boolean validateHorizontal(World world, BlockPos pos, int radius, int axis, boolean isWheel) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        boolean valid = true;
        for (int vert = -radius; vert <= radius; ++vert) {
            for (int i = -radius; i <= radius; ++i) {
                int xP = axis == 1 ? i : 0;
                int zP = axis == 2 ? i : 0;
                int xPos = x + xP;
                int yPos = y + vert;
                int zPos = z + zP;
                BlockPos checkPos = new BlockPos(xPos, yPos, zPos);
                if (yPos == y - radius && isWheel) {
                    valid = world.func_175623_d(checkPos) || world.func_72875_a(new AxisAlignedBB((double)xPos, (double)yPos, (double)zPos, (double)(xPos + 1), (double)(yPos + 1), (double)(zPos + 1)), Material.field_151586_h);
                } else {
                    if (xP == 0 && yPos == y && zP == 0) continue;
                    valid = isWheel && (xP == -radius || xP == radius || zP == -radius || zP == radius) ? world.func_175623_d(checkPos) || world.func_72875_a(new AxisAlignedBB((double)xPos, (double)yPos, (double)zPos, (double)(xPos + 1), (double)(yPos + 1), (double)(zPos + 1)), Material.field_151586_h) : world.func_175623_d(checkPos);
                }
                if (!valid) break;
            }
            if (!valid) break;
        }
        return valid;
    }

    private boolean isVerticalWindmillValid(EntityPlayer player, World world, BlockPos pos, float flY) {
        boolean valid = false;
        int yPos = 0;
        yPos = flY > 0.5f ? (yPos += 3) : (yPos -= 3);
        BlockPos target = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + yPos, pos.func_177952_p());
        if (this.checkForSupportingAxles(world, target)) {
            if (this.validateArea(player, world, target)) {
                world.func_175656_a(target, BWRegistry.windmillBlock.func_176223_P());
                valid = true;
            } else if (world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentString("Not enough room to place the windmill. Need a 9x9 area with a height of seven to work."));
            }
        } else if (world.field_72995_K) {
            player.func_145747_a((ITextComponent)new TextComponentString("Too few vertical axles in column to place here. (Need seven)"));
        }
        return valid;
    }

    public boolean validateArea(EntityPlayer player, World world, BlockPos pos) {
        int i;
        BlockPos target;
        int zPos;
        int yPos;
        int xPos;
        int z;
        int y;
        int x;
        boolean clear = true;
        for (int yP = -4; yP < 5; ++yP) {
            for (int xP = -4; xP < 5; ++xP) {
                for (int zP = -4; zP < 5; ++zP) {
                    x = pos.func_177958_n();
                    y = pos.func_177956_o();
                    z = pos.func_177952_p();
                    xPos = xP;
                    yPos = yP;
                    zPos = zP;
                    target = new BlockPos(x + xPos, y + yPos, z + zPos);
                    if (x + xPos != x && z + zPos != z && yP != -4 && yP != 4) {
                        clear = world.func_175623_d(target);
                    }
                    if ((yP == -4 || yP == 4) && xP == 0 && zP == 0) {
                        boolean bl = clear = !(world.func_180495_p(target).func_177230_c() instanceof BlockWindmill);
                    }
                    if (clear) continue;
                    if (!world.field_72995_K) break;
                    player.func_145747_a((ITextComponent)new TextComponentString("Blockage at x:" + (x + xPos) + " y:" + (y + yPos) + " z:" + (z + zPos)));
                    break;
                }
                if (!clear) break;
            }
            if (!clear) break;
        }
        for (i = -8; i < 8; ++i) {
            for (int j = -8; j < 7; ++j) {
                for (int k = -8; k < 8 && clear; ++k) {
                    x = pos.func_177958_n();
                    y = pos.func_177956_o();
                    z = pos.func_177952_p();
                    xPos = i;
                    yPos = j;
                    zPos = k;
                    target = pos.func_177982_a(xPos, yPos, zPos);
                    if (i > -5 && i < 5 && k > -5 && k < 5) continue;
                    if (world.func_180495_p(target).func_177230_c() instanceof BlockWindmill || world.func_180495_p(target).func_177230_c() instanceof BlockWaterwheel) {
                        clear = false;
                    }
                    if (!clear) break;
                }
                if (!clear) break;
            }
            if (!clear) break;
        }
        for (i = 5; i < 8; ++i) {
            int yMin = -i;
            int yMax = i;
            BlockPos minPos = pos.func_177982_a(0, yMin, 0);
            BlockPos maxPos = pos.func_177982_a(0, yMax, 0);
            if (!clear) break;
            if (world.func_180495_p(minPos).func_177230_c() instanceof BlockWindmill) {
                clear = false;
            }
            if (!clear) break;
            if (world.func_180495_p(maxPos).func_177230_c() instanceof BlockWindmill) {
                clear = false;
            }
            if (!clear) break;
        }
        return clear;
    }

    private boolean checkForSupportingAxles(World world, BlockPos pos) {
        int i = -3;
        while (i <= 3) {
            int yPos;
            BlockPos target;
            Block targetBlock;
            if ((targetBlock = world.func_180495_p(target = pos.func_177982_a(0, yPos = i++, 0)).func_177230_c()) == BWRegistry.axle) {
                int axis = ((BlockAxle)targetBlock).getAxisAlignment((IBlockAccess)world, target);
                if (axis == 0) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < 3; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public String func_77667_c(ItemStack stack) {
        return super.func_77658_a() + "." + this.names[stack.func_77952_i()];
    }
}

