/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.proxy;

import betterwithmods.BWRegistry;
import betterwithmods.blocks.BlockPlanter;
import betterwithmods.blocks.ItemBlockPlanter;
import betterwithmods.blocks.tile.gen.TileEntityWaterwheel;
import betterwithmods.blocks.tile.gen.TileEntityWindmillHorizontal;
import betterwithmods.blocks.tile.gen.TileEntityWindmillVertical;
import betterwithmods.client.BWStateMapper;
import betterwithmods.client.model.TESRVerticalWindmill;
import betterwithmods.client.model.TESRWaterwheel;
import betterwithmods.client.model.TESRWindmill;
import betterwithmods.entity.EntityDynamite;
import betterwithmods.proxy.CommonProxy;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderSnowball;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class ClientProxy
extends CommonProxy {
    @Override
    public void registerRenderInformation() {
        this.registerItemModel(Item.func_150898_a((Block)BWRegistry.axle), 0, "betterwithmods:axle");
        this.registerItemModel(Item.func_150898_a((Block)BWRegistry.gearbox), 0, "betterwithmods:gearbox");
        this.registerItemModel(Item.func_150898_a((Block)BWRegistry.saw), 0, "betterwithmods:saw");
        this.registerItemModel(Item.func_150898_a((Block)BWRegistry.stokedFlame), 0, "betterwithmods:stoked_flame");
        ModelLoader.setCustomStateMapper((Block)BWRegistry.stokedFlame, (IStateMapper)new BWStateMapper("betterwithmods:stoked_flame"));
        this.registerItemModel(Item.func_150898_a((Block)BWRegistry.anchor), 0, "betterwithmods:anchor");
        String[] variant = new String[]{"potterytype=crucible", "potterytype=planter", "potterytype=urn"};
        this.registerBlock("betterwithmods:unfired_pottery", BWRegistry.unfiredPottery, variant);
        variant = new String[]{"plantertype=empty", "plantertype=dirt", "plantertype=grass", "plantertype=soul_sand", "plantertype=fertile", "plantertype=sand", "plantertype=water_still", "plantertype=gravel", "plantertype=red_sand"};
        this.registerBlock("betterwithmods:planter", BWRegistry.planter, variant);
        variant = new String[]{"underhopper=false,urntype=empty", "underhopper=false,urntype=12", "underhopper=false,urntype=25", "underhopper=false,urntype=37", "underhopper=false,urntype=50", "underhopper=false,urntype=62", "underhopper=false,urntype=75", "underhopper=false,urntype=87", "underhopper=false,urntype=filled", "underhopper=false,urntype=void"};
        this.registerBlock("betterwithmods:urn", BWRegistry.urn, variant);
        this.registerItemModel(Item.func_150898_a((Block)BWRegistry.booster), 0, "betterwithmods:gear_rail");
        String[] names = new String[]{"gear", "nethercoal", "hemp", "hemp_fibers", "hemp_cloth", "dung", "tanned_leather", "scoured_leather", "leather_strap", "leather_belt", "wood_blade", "windmill_blade", "glue", "tallow", "ingot_steel", "ground_netherrack", "hellfire_dust", "concentrated_hellfire", "coal_dust", "filament", "polished_lapis", "potash", "sawdust", "soul_dust", "screw", "brimstone", "niter", "element", "fuse", "blasting_oil", "nugget_iron", "nugget_steel", "leather_cut", "tanned_leather_cut", "scoured_leather_cut", "redstone_latch", "nether_sludge", "flour", "haft", "charcoal_dust", "sharpening_stone", "knife_blade"};
        for (int i = 0; i < 42; ++i) {
            this.registerItemModel(BWRegistry.material, i, "betterwithmods:" + names[i]);
        }
        String[] bark = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "blood_wood"};
        for (int i = 0; i < 6; ++i) {
            this.registerItemModel(BWRegistry.bark, i, "betterwithmods:bark_" + bark[i]);
        }
        this.registerItemModel(Item.func_150898_a((Block)BWRegistry.pane), 2, "betterwithmods:wicker");
        String[] woodTypes = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak"};
        for (int i = 0; i < woodTypes.length; ++i) {
            this.registerItemModel(Item.func_150898_a((Block)BWRegistry.grate), i, "betterwithmods:grate_" + woodTypes[i]);
            this.registerItemModel(Item.func_150898_a((Block)BWRegistry.slats), i, "betterwithmods:slats_" + woodTypes[i]);
        }
        variant = new String[]{"axis=y,variant=oak", "axis=y,variant=spruce", "axis=y,variant=birch", "axis=y,variant=jungle"};
        this.registerBlock("betterwithmods:debarked_old", BWRegistry.debarkedOld, variant);
        variant = new String[]{"axis=y,variant=acacia", "axis=y,variant=dark_oak"};
        this.registerBlock("betterwithmods:debarked_new", BWRegistry.debarkedNew, variant);
        this.registerItemModel(Item.func_150898_a((Block)BWRegistry.hemp), 0, "betterwithmods:hemp_seed");
        this.registerItemModel(Item.func_150898_a((Block)BWRegistry.rope), 0, "betterwithmods:rope");
        this.registerBlock("betterwithmods:hand_crank", BWRegistry.handCrank, "stage=0");
        this.registerItemModel(Item.func_150898_a((Block)BWRegistry.hibachi), 0, "betterwithmods:hibachi");
        this.registerItemModel(Item.func_150898_a((Block)BWRegistry.bellows), 0, "betterwithmods:bellows");
        this.registerItemModel(Item.func_150898_a((Block)BWRegistry.lens), 0, "betterwithmods:lens");
        this.registerMechMachines();
        this.registerItemModel(Item.func_150898_a((Block)BWRegistry.kiln), 0, "betterwithmods:kiln");
        this.registerItemModel(Item.func_150898_a((Block)BWRegistry.detector), 0, "betterwithmods:detector");
        variant = new String[]{"blocktype=chopping", "blocktype=chopping_blood", "blocktype=steel", "blocktype=hellfire", "blocktype=rope", "blocktype=flint"};
        this.registerBlock("betterwithmods:aesthetic", BWRegistry.aesthetic, variant);
        this.registerItemModel(BWRegistry.windmill, 0, "betterwithmods:windmill");
        this.registerItemModel(BWRegistry.windmill, 1, "betterwithmods:waterwheel");
        this.registerItemModel(BWRegistry.windmill, 2, "betterwithmods:windmill_vertical");
        this.registerItemModel(BWRegistry.donut, 0, "betterwithmods:donut");
        this.registerItemModel(BWRegistry.knife, 0, "betterwithmods:iron_knife");
        this.registerItemModel(BWRegistry.dynamite, 0, "betterwithmods:dynamite");
        this.registerItemModel(BWRegistry.fertilizer, 0, "betterwithmods:fertilizer");
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWindmillHorizontal.class, (TileEntitySpecialRenderer)new TESRWindmill());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWindmillVertical.class, (TileEntitySpecialRenderer)new TESRVerticalWindmill());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityWaterwheel.class, (TileEntitySpecialRenderer)new TESRWaterwheel());
        this.registerMiniBlockNBT(BWRegistry.woodSiding, "betterwithmods:wood_siding");
        this.registerMiniBlockNBT(BWRegistry.woodMoulding, "betterwithmods:wood_moulding");
        this.registerMiniBlockNBT(BWRegistry.woodCorner, "betterwithmods:wood_corner");
        this.registerFurnitureModel(BWRegistry.woodBench, 6, "betterwithmods:wood_bench");
        this.registerFurnitureModel(BWRegistry.woodTable, 6, "betterwithmods:wood_table");
        ModelLoader.setCustomStateMapper((Block)BWRegistry.windmillBlock, (IStateMapper)new BWStateMapper("betterwithmods:windmill_block"));
        this.registerBlock("betterwithmods:block_dispenser", BWRegistry.blockDispenser, "facing=north,triggered=false");
        this.registerBlock("betterwithmods:companion_cube", BWRegistry.wolf, "facing=north");
        this.registerTool(BWRegistry.steelSword, "betterwithmods:steel_sword");
        this.registerTool(BWRegistry.steelShovel, "betterwithmods:steel_shovel");
        this.registerTool(BWRegistry.steelPickaxe, "betterwithmods:steel_pickaxe");
        this.registerTool(BWRegistry.steelHoe, "betterwithmods:steel_hoe");
        this.registerTool(BWRegistry.steelAxe, "betterwithmods:steel_axe");
        variant = new String[]{"active=false,type=oak", "active=false,type=spruce", "active=false,type=birch", "active=false,type=jungle", "active=false,type=acacia", "active=false,type=dark_oak"};
        this.registerBlock("betterwithmods:bamboo_chime", BWRegistry.bambooChime, variant);
        this.registerBlock("betterwithmods:metal_chime", BWRegistry.metalChime, variant);
    }

    @Override
    public void registerColors() {
        BlockColors col = Minecraft.func_71410_x().func_184125_al();
        col.func_186722_a(new IBlockColor(){

            public int func_186720_a(IBlockState state, @Nullable IBlockAccess worldIn, @Nullable BlockPos pos, int tintIndex) {
                if (state.func_177230_c() instanceof BlockPlanter) {
                    return ((BlockPlanter)state.func_177230_c()).colorMultiplier(state, worldIn, pos, tintIndex);
                }
                return -1;
            }
        }, new Block[]{BWRegistry.planter});
        ItemColors itCol = Minecraft.func_71410_x().getItemColors();
        itCol.func_186731_a(new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                if (stack.func_77973_b() instanceof ItemBlock && stack.func_77973_b() instanceof ItemBlockPlanter) {
                    return ((ItemBlockPlanter)stack.func_77973_b()).getColorFromItemstack(stack, tintIndex);
                }
                return -1;
            }
        }, new Block[]{BWRegistry.planter});
    }

    private void registerMechMachines() {
        Block block = BWRegistry.singleMachines;
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new BWStateMapper("betterwithmods:single_machine"));
        Item item = Item.func_150898_a((Block)block);
        this.registerItemModel(item, 0, "betterwithmods:single_machine");
        this.registerItemModel(item, 2, "betterwithmods:crucible");
        this.registerItemModel(item, 3, "betterwithmods:cauldron");
        this.registerItemModel(item, 4, "betterwithmods:hopper");
        this.registerItemModel(item, 5, "betterwithmods:turntable");
    }

    private void registerFurnitureModel(Block block, int maxMeta, String location) {
        for (int i = 0; i < maxMeta; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)i, (ModelResourceLocation)new ModelResourceLocation(location, "supported=false,type=" + i));
        }
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new BWStateMapper(location));
    }

    @Override
    public void postRender() {
        RenderingRegistry.registerEntityRenderingHandler(EntityDynamite.class, (Render)new RenderSnowball(Minecraft.func_71410_x().func_175598_ae(), BWRegistry.dynamite, Minecraft.func_71410_x().func_175599_af()));
    }

    private void registerItemModel(Item item, int meta, String name) {
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)meta, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
    }

    private void registerBlock(String location, Block block, String ... variants) {
        for (int i = 0; i < variants.length; ++i) {
            if (variants[i].equals("")) continue;
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)i, (ModelResourceLocation)new ModelResourceLocation(location, variants[i]));
        }
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new BWStateMapper(location));
    }

    private void registerTool(Item item, final String name) {
        ItemMeshDefinition def = new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                return new ModelResourceLocation(name, "inventory");
            }
        };
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)def);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(name, "inventory")});
    }

    private void registerMiniBlockNBT(Block block, final String name) {
        Item item = Item.func_150898_a((Block)block);
        final String[] woodType = new String[]{"_oak", "_spruce", "_birch", "_jungle", "_acacia", "_dark_oak"};
        ItemMeshDefinition def = new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                if (stack.func_77942_o()) {
                    if (stack.func_77978_p().func_74764_b("type")) {
                        return new ModelResourceLocation(name + woodType[stack.func_77978_p().func_74762_e("type")], "inventory");
                    }
                } else if (stack.func_77952_i() < 6) {
                    return new ModelResourceLocation(name + woodType[stack.func_77952_i()], "inventory");
                }
                return new ModelResourceLocation(name + "_oak", "inventory");
            }
        };
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)def);
        ModelResourceLocation[] resource = new ModelResourceLocation[6];
        for (int i = 0; i < 6; ++i) {
            resource[i] = new ModelResourceLocation(name + woodType[i], "inventory");
        }
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])resource);
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new BWStateMapper(name));
    }

    @Override
    public boolean isClientside() {
        return true;
    }
}

