/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class InvUtils {
    public static ArrayList<ItemStack> dustNames = InvUtils.getOreNames("dust");
    public static ArrayList<ItemStack> ingotNames = InvUtils.getOreNames("ingot");
    public static ArrayList<ItemStack> cropNames = InvUtils.getOreNames("crop");
    public static Predicate<EntityLivingBase> GET_VALID_BDISP_ENTITIES = new Predicate<EntityLivingBase>(){

        public boolean apply(EntityLivingBase entity) {
            return !entity.field_70128_L && (entity instanceof EntityWolf || entity instanceof EntitySheep || entity instanceof EntityChicken);
        }
    };

    private static ArrayList<ItemStack> getOreNames(String prefix) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (String name : OreDictionary.getOreNames()) {
            if (!name.startsWith(prefix) || OreDictionary.getOres((String)name).size() <= 0) continue;
            list.addAll(OreDictionary.getOres((String)name));
        }
        return list;
    }

    public static void ejectInventoryContents(World world, BlockPos pos, IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null) continue;
            float fX = world.field_73012_v.nextFloat() * 0.7f + 0.15f;
            float fY = world.field_73012_v.nextFloat() * 0.7f + 0.15f;
            float fZ = world.field_73012_v.nextFloat() * 0.7f + 0.15f;
            while (stack.field_77994_a > 0) {
                int j = world.field_73012_v.nextInt(21) + 10;
                if (j > stack.field_77994_a) {
                    j = stack.field_77994_a;
                }
                stack.field_77994_a -= j;
                EntityItem item = new EntityItem(world, (double)((float)pos.func_177958_n() + fX), (double)((float)pos.func_177956_o() + fY), (double)((float)pos.func_177952_p() + fZ), new ItemStack(stack.func_77973_b(), j, stack.func_77952_i()));
                float f1 = 0.05f;
                item.field_70159_w = (float)world.field_73012_v.nextGaussian() * f1;
                item.field_70181_x = (float)world.field_73012_v.nextGaussian() * f1 + 0.2f;
                item.field_70179_y = (float)world.field_73012_v.nextGaussian() * f1;
                InvUtils.copyTags(item.func_92059_d(), stack);
                world.func_72838_d((Entity)item);
            }
        }
    }

    public static void clearInventory(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null) continue;
            inv.func_70299_a(i, null);
        }
    }

    public static void copyTags(ItemStack destStack, ItemStack sourceStack) {
        if (sourceStack.func_77942_o()) {
            destStack.func_77982_d((NBTTagCompound)sourceStack.func_77978_p().func_74737_b());
        }
    }

    public static ItemStack decrStackSize(IInventory inv, int slot, int amount) {
        if (inv.func_70301_a(slot) != null) {
            if (inv.func_70301_a((int)slot).field_77994_a <= amount) {
                ItemStack stack = inv.func_70301_a(slot);
                inv.func_70299_a(slot, null);
                return stack;
            }
            ItemStack splitStack = inv.func_70301_a(slot).func_77979_a(amount);
            if (inv.func_70301_a((int)slot).field_77994_a < 1) {
                inv.func_70299_a(slot, null);
            } else {
                inv.func_70296_d();
            }
            return splitStack;
        }
        return null;
    }

    public static boolean addSingleItemToInv(IInventory inv, Item item, int meta) {
        ItemStack stack = new ItemStack(item, 1, meta);
        return InvUtils.addItemStackToInv(inv, stack);
    }

    public static boolean addItemStackToInv(IInventory inv, ItemStack stack) {
        return InvUtils.addItemStackToInvInSlotRange(inv, stack, 0, inv.func_70302_i_() - 1);
    }

    public static boolean addItemStackToInvInSlotRange(IInventory inv, ItemStack stack, int minSlot, int maxSlot) {
        if (!stack.func_77951_h() && InvUtils.attemptToMergeWithExistingStacksInRange(inv, stack, minSlot, maxSlot)) {
            return true;
        }
        return InvUtils.attemptToPlaceInEmptySlotInRange(inv, stack, minSlot, maxSlot);
    }

    private static boolean canStacksMerge(ItemStack source, ItemStack dest, int sizeLimit) {
        return dest != null && dest.func_77973_b() == source.func_77973_b() && dest.func_77985_e() && dest.field_77994_a < dest.func_77976_d() && dest.field_77994_a < sizeLimit && (!dest.func_77981_g() || dest.func_77952_i() == source.func_77952_i()) && ItemStack.func_77970_a((ItemStack)dest, (ItemStack)source);
    }

    private static int findSlotToMergeStackInRange(IInventory inv, ItemStack stack, int minSlot, int maxSlot) {
        int stackLimit = inv.func_70297_j_();
        for (int i = minSlot; i <= maxSlot; ++i) {
            ItemStack tempStack = inv.func_70301_a(i);
            if (!InvUtils.canStacksMerge(stack, tempStack, stackLimit)) continue;
            return i;
        }
        return -1;
    }

    private static boolean attemptToMergeWithExistingStacksInRange(IInventory inv, ItemStack stack, int minSlot, int maxSlot) {
        int mergeSlot = InvUtils.findSlotToMergeStackInRange(inv, stack, minSlot, maxSlot);
        while (mergeSlot >= 0) {
            int numItemsToStore = stack.field_77994_a;
            ItemStack tempStack = inv.func_70301_a(mergeSlot);
            if (numItemsToStore > tempStack.func_77976_d() - tempStack.field_77994_a) {
                numItemsToStore = tempStack.func_77976_d() - tempStack.field_77994_a;
            }
            if (numItemsToStore > inv.func_70297_j_() - tempStack.field_77994_a) {
                numItemsToStore = inv.func_70297_j_() - tempStack.field_77994_a;
            }
            if (numItemsToStore == 0) {
                return false;
            }
            stack.field_77994_a -= numItemsToStore;
            tempStack.field_77994_a += numItemsToStore;
            inv.func_70299_a(mergeSlot, tempStack);
            if (stack.field_77994_a < 1) {
                return true;
            }
            mergeSlot = InvUtils.findSlotToMergeStackInRange(inv, stack, minSlot, maxSlot);
        }
        return false;
    }

    private static boolean attemptToPlaceInEmptySlotInRange(IInventory inv, ItemStack stack, int minSlot, int maxSlot) {
        Item item = stack.func_77973_b();
        int meta = stack.func_77952_i();
        int slot = InvUtils.getFirstEmptyStackInRange(inv, minSlot, maxSlot);
        while (slot >= 0) {
            int numItemsToStore = stack.field_77994_a;
            if (numItemsToStore > inv.func_70297_j_()) {
                numItemsToStore = inv.func_70297_j_();
            }
            ItemStack newStack = new ItemStack(item, numItemsToStore, meta);
            InvUtils.copyTags(newStack, stack);
            inv.func_70299_a(slot, newStack);
            stack.field_77994_a -= numItemsToStore;
            if (stack.field_77994_a <= 0) {
                return true;
            }
            slot = InvUtils.getFirstEmptyStackInRange(inv, minSlot, maxSlot);
        }
        return false;
    }

    public static int getFirstOccupiedStackInRange(IInventory inv, int minSlot, int maxSlot) {
        for (int slot = minSlot; slot <= maxSlot; ++slot) {
            if (inv.func_70301_a(slot) == null) continue;
            return slot;
        }
        return -1;
    }

    public static int getFirstEmptyStackInRange(IInventory inv, int minSlot, int maxSlot) {
        for (int slot = minSlot; slot <= maxSlot; ++slot) {
            if (inv.func_70301_a(slot) != null) continue;
            return slot;
        }
        return -1;
    }

    public static int getOccupiedStacks(IInventory inv) {
        return InvUtils.getOccupiedStacks(inv, 0, inv.func_70302_i_() - 1);
    }

    public static int getOccupiedStacks(IInventory inv, int min, int max) {
        int count = 0;
        for (int i = min; i <= max; ++i) {
            if (inv.func_70301_a(i) == null) continue;
            ++count;
        }
        return count;
    }

    public static int countItemsInInventory(IInventory inv, Item item) {
        return InvUtils.countItemsInInventory(inv, item, Short.MAX_VALUE);
    }

    public static int countItemsInInventory(IInventory inv, Item item, int meta) {
        int itemCount = 0;
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item || meta != Short.MAX_VALUE && stack.func_77952_i() != meta) continue;
            itemCount += inv.func_70301_a((int)i).field_77994_a;
        }
        return itemCount;
    }

    public static int countOresInInv(IInventory inv, List<ItemStack> list) {
        int ret = 0;
        if (list != null && !list.isEmpty() && list.size() > 0) {
            block0: for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null) continue;
                for (int o = 0; o < list.size(); ++o) {
                    Item oreItem = list.get(o).func_77973_b();
                    int oreMeta = list.get(o).func_77952_i();
                    if (!OreDictionary.itemMatches((ItemStack)new ItemStack(stack.func_77973_b(), 1, stack.func_77952_i()), (ItemStack)new ItemStack(oreItem, 1, oreMeta), (boolean)false)) continue;
                    ret += stack.field_77994_a;
                    continue block0;
                }
            }
        }
        return ret;
    }

    public static int countOresInInventory(IInventory inv, ArrayList<ItemStack> ores) {
        int ret = 0;
        if (ores != null && !ores.isEmpty() && ores.size() > 0) {
            for (int i = 0; i < ores.size(); ++i) {
                Item item = ores.get(i).func_77973_b();
                int meta = ores.get(i).func_77952_i();
                ret += InvUtils.countItemsInInventory(inv, item, meta);
            }
        }
        return ret;
    }

    public static boolean consumeItemsInInventory(IInventory inv, Item item, int meta, int stackSize) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack == null || stack.func_77973_b() != item || meta != Short.MAX_VALUE && stack.func_77952_i() != meta) continue;
            if (stack.field_77994_a >= stackSize) {
                InvUtils.decrStackSize(inv, i, stackSize);
                return false;
            }
            stackSize -= stack.field_77994_a;
            inv.func_70299_a(i, null);
        }
        return false;
    }

    public static boolean consumeOresInInventory(IInventory inv, List<ItemStack> list, int stackSize) {
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                ItemStack tempStack = list.get(i);
                Item item = tempStack.func_77973_b();
                int meta = tempStack.func_77952_i();
                for (int j = 0; j < inv.func_70302_i_(); ++j) {
                    ItemStack stack = inv.func_70301_a(j);
                    if (stack == null || stack.func_77973_b() != item || stack.func_77952_i() != meta && meta != Short.MAX_VALUE) continue;
                    if (stack.field_77994_a >= stackSize) {
                        InvUtils.decrStackSize(inv, j, stackSize);
                        return false;
                    }
                    stackSize -= stack.field_77994_a;
                    inv.func_70299_a(j, null);
                }
            }
        }
        return false;
    }

    public static int getFirstOccupiedStackNotOfItem(IInventory inv, Item item) {
        return InvUtils.getFirstOccupiedStackNotOfItem(inv, item, Short.MAX_VALUE);
    }

    public static int getFirstOccupiedStackNotOfItem(IInventory inv, Item item, int meta) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null) continue;
            int tempMeta = inv.func_70301_a(i).func_77952_i();
            if (inv.func_70301_a(i).func_77973_b() == item || meta != Short.MAX_VALUE && tempMeta == meta) continue;
            return i;
        }
        return -1;
    }

    public static int getFirstOccupiedStackOfItem(IInventory inv, Item item) {
        return InvUtils.getFirstOccupiedStackOfItem(inv, item, Short.MAX_VALUE);
    }

    public static int getFirstOccupiedStackOfItem(IInventory inv, Item item, int meta) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            if (inv.func_70301_a(i) == null) continue;
            int tempMeta = inv.func_70301_a(i).func_77952_i();
            if (inv.func_70301_a(i).func_77973_b() != item || meta != Short.MAX_VALUE && tempMeta != meta) continue;
            return i;
        }
        return -1;
    }

    public static void ejectStackWithOffset(World world, BlockPos pos, ItemStack stack) {
        float xOff = world.field_73012_v.nextFloat() * 0.7f + 0.15f;
        float yOff = world.field_73012_v.nextFloat() * 0.2f + 0.1f;
        float zOff = world.field_73012_v.nextFloat() * 0.7f + 0.15f;
        InvUtils.ejectStack(world, (float)pos.func_177958_n() + xOff, (float)pos.func_177956_o() + yOff, (float)pos.func_177952_p() + zOff, stack);
    }

    public static void ejectStack(World world, double x, double y, double z, ItemStack stack) {
        EntityItem item = new EntityItem(world, x, y, z, stack);
        float velocity = 0.05f;
        item.field_70159_w = (float)world.field_73012_v.nextGaussian() * velocity;
        item.field_70181_x = (float)world.field_73012_v.nextGaussian() * velocity + 0.2f;
        item.field_70179_y = (float)world.field_73012_v.nextGaussian() * velocity;
        item.func_174869_p();
        world.func_72838_d((Entity)item);
    }
}

