/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.util;

import betterwithmods.BWRegistry;
import betterwithmods.api.block.IAxle;
import betterwithmods.api.block.IMechanicalBlock;
import betterwithmods.blocks.BlockAxle;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MechanicalUtil {
    public static boolean isBlockPoweredByAxleOnSide(World world, BlockPos pos, EnumFacing dir) {
        IAxle axle;
        BlockPos pos2 = pos.func_177972_a(dir);
        Block block = world.func_180495_p(pos2).func_177230_c();
        return MechanicalUtil.isAxle(block) && (axle = (IAxle)block).isAxleOrientedToFacing((IBlockAccess)world, pos2, dir) && axle.getPowerLevel((IBlockAccess)world, pos2) > 0;
    }

    public static boolean isAxle(Block block) {
        return block instanceof IAxle;
    }

    public static boolean isPoweredByCrank(World world, BlockPos pos) {
        for (int i = 1; i < 6; ++i) {
            if (!MechanicalUtil.isPoweredByCrankOnSide(world, pos, EnumFacing.func_82600_a((int)i))) continue;
            return true;
        }
        return false;
    }

    public static boolean isPoweredByCrankOnSide(World world, BlockPos pos, EnumFacing dir) {
        IMechanicalBlock mech;
        BlockPos offset = pos.func_177972_a(dir);
        Block block = world.func_180495_p(offset).func_177230_c();
        return block == BWRegistry.handCrank && (mech = (IMechanicalBlock)block).isOutputtingMechPower(world, offset);
    }

    public static boolean isBlockPoweredByAxle(World world, BlockPos pos, IMechanicalBlock block) {
        for (int i = 0; i < 6; ++i) {
            if (!block.canInputPowerToSide((IBlockAccess)world, pos, EnumFacing.func_82600_a((int)i)) || !MechanicalUtil.isBlockPoweredByAxleOnSide(world, pos, EnumFacing.func_82600_a((int)i))) continue;
            return true;
        }
        return false;
    }

    public static void destoryHorizontalAxles(World world, BlockPos pos) {
        for (int i = 2; i < 6; ++i) {
            BlockAxle axle;
            Block block = world.func_180495_p(pos).func_177230_c();
            if (!MechanicalUtil.isAxle(block) || !(axle = (BlockAxle)block).isAxleOrientedToFacing((IBlockAccess)world, pos, EnumFacing.func_82600_a((int)i))) continue;
            axle.breakAxle(world, pos);
        }
    }
}

