/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods;

import betterwithmods.client.BWGuiHandler;
import betterwithmods.common.BWIMCHandler;
import betterwithmods.common.BWRegistry;
import betterwithmods.event.BlastingOilEvent;
import betterwithmods.event.BreedingHardnessEvent;
import betterwithmods.event.FakePlayerHandler;
import betterwithmods.event.FeedWolfchopEvent;
import betterwithmods.event.PotionEventHandler;
import betterwithmods.module.ModuleLoader;
import betterwithmods.network.MessageFat;
import betterwithmods.network.MessageGuiShake;
import betterwithmods.network.MessageSyncModule;
import betterwithmods.network.ModuleSync;
import betterwithmods.network.NetworkHandler;
import betterwithmods.proxy.IProxy;
import com.google.common.collect.ImmutableList;
import net.minecraft.world.MinecraftException;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLConstructionEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="betterwithmods", name="Better With Mods", version="1.2.9-1.11.2", dependencies="before:survivalist;after:mantle;after:tconstruct;after:minechem;after:natura;after:terrafirmacraft;after:immersiveengineering;after:mekanism;after:thermalexpansion", guiFactory="betterwithmods.client.gui.BWGuiFactory", acceptedMinecraftVersions="[1.11.2]")
public class BWMod {
    public static final String MODID = "betterwithmods";
    public static final String VERSION = "1.2.9-1.11.2";
    public static final String NAME = "Better With Mods";
    public static final String DEPENDENCIES = "before:survivalist;after:mantle;after:tconstruct;after:minechem;after:natura;after:terrafirmacraft;after:immersiveengineering;after:mekanism;after:thermalexpansion";
    public static Logger logger;
    @SidedProxy(serverSide="betterwithmods.proxy.ServerProxy", clientSide="betterwithmods.proxy.ClientProxy")
    public static IProxy proxy;
    @Mod.Instance(value="betterwithmods")
    public static BWMod instance;

    private static void registerEventHandlers() {
        MinecraftForge.EVENT_BUS.register((Object)new FakePlayerHandler());
        MinecraftForge.EVENT_BUS.register((Object)new PotionEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new BlastingOilEvent());
        MinecraftForge.EVENT_BUS.register((Object)new BreedingHardnessEvent());
        MinecraftForge.EVENT_BUS.register((Object)new FeedWolfchopEvent());
    }

    @Mod.EventHandler
    public void onConstruct(FMLConstructionEvent event) {
        ForgeModContainer.fullBoundingBoxLadders = true;
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        logger = evt.getModLog();
        ModuleLoader.preInit(evt);
        BWRegistry.preInit();
        NetworkHandler.register(MessageSyncModule.class, Side.CLIENT);
        NetworkHandler.register(MessageGuiShake.class, Side.CLIENT);
        NetworkHandler.register(MessageFat.class, Side.CLIENT);
        proxy.preInit(evt);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        BWRegistry.init();
        ModuleLoader.init(evt);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new BWGuiHandler());
        proxy.init(evt);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        BWRegistry.postInit();
        ModuleLoader.postInit(evt);
        BWMod.registerEventHandlers();
        if (evt.getSide().isServer()) {
            MinecraftForge.EVENT_BUS.register((Object)new ModuleSync());
        }
        proxy.postInit(evt);
    }

    @Mod.EventHandler
    public void processIMCMessages(FMLInterModComms.IMCEvent evt) {
        BWIMCHandler.processIMC((ImmutableList<FMLInterModComms.IMCMessage>)evt.getMessages());
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent evt) {
        ModuleLoader.serverStarting(evt);
    }

    @Mod.EventHandler
    public void remap(FMLMissingMappingsEvent evt) throws MinecraftException {
        for (FMLMissingMappingsEvent.MissingMapping mapping : evt.get()) {
            switch (mapping.type) {
                case ITEM: {
                    break;
                }
            }
        }
    }
}

