/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.model;

import betterwithmods.client.model.render.RenderUtils;
import betterwithmods.common.blocks.tile.TileEntityCauldron;
import betterwithmods.common.blocks.tile.TileEntityCookingPot;
import betterwithmods.common.blocks.tile.TileEntityCrucible;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;

public class TESRCookingPot
extends TileEntitySpecialRenderer<TileEntityCookingPot> {
    private int occupiedStacks;

    public void renderTileEntityFast(@Nonnull TileEntityCookingPot tile, double x, double y, double z, float partialTick, int breakStage, @Nonnull VertexBuffer renderer) {
        if (tile != null) {
            if (this.occupiedStacks != tile.filledSlots()) {
                this.occupiedStacks = tile.filledSlots();
            }
            if (this.occupiedStacks != 0) {
                float fillOffset = 0.75f * this.occupationMod(tile);
                RenderUtils.renderFill(this.getResource(tile), tile.func_174877_v(), x, y, z, 0.123, 0.125, 0.123, 0.877, 0.248 + (double)fillOffset, 0.877);
            }
        }
    }

    private ResourceLocation getResource(TileEntityCookingPot tile) {
        if (tile instanceof TileEntityCauldron) {
            return new ResourceLocation("betterwithmods", "blocks/cauldron_contents");
        }
        if (tile instanceof TileEntityCrucible) {
            return new ResourceLocation("minecraft", "blocks/gravel");
        }
        return null;
    }

    private float occupationMod(TileEntityCookingPot tile) {
        float visibleSlots = tile.getMaxVisibleSlots();
        return (float)this.occupiedStacks / visibleSlots;
    }
}

