/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.client.model.render;

import betterwithmods.client.model.filters.ModelGrate;
import betterwithmods.client.model.filters.ModelOpaque;
import betterwithmods.client.model.filters.ModelSlats;
import betterwithmods.client.model.filters.ModelTransparent;
import betterwithmods.client.model.filters.ModelWithResource;
import betterwithmods.common.BWMBlocks;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.opengl.GL11;

public class RenderUtils {
    protected static final Minecraft minecraft = Minecraft.func_71410_x();
    private static HashMap<String, ModelWithResource> filterLocations = new HashMap();
    private static RenderItem renderItem;

    public static boolean filterContains(ItemStack stack) {
        return !stack.func_190926_b() && filterLocations.containsKey(stack.func_77973_b().toString() + stack.func_77960_j());
    }

    public static ModelWithResource getModelFromStack(ItemStack stack) {
        if (RenderUtils.filterContains(stack)) {
            return filterLocations.get(stack.func_77973_b().toString() + stack.func_77960_j());
        }
        return null;
    }

    public static void addFilter(ItemStack stack, ModelWithResource resource) {
        String stackString = stack.func_77973_b().toString() + stack.func_77960_j();
        filterLocations.put(stackString, resource);
    }

    public static void registerFilters() {
        String[] woodTypes = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "dark_oak"};
        for (int i = 0; i < 6; ++i) {
            RenderUtils.addFilter(new ItemStack(BWMBlocks.SLATS, 1, i), new ModelSlats(new ResourceLocation("betterwithmods", "textures/blocks/wood_side_" + woodTypes[i] + ".png")));
            RenderUtils.addFilter(new ItemStack(BWMBlocks.GRATE, 1, i), new ModelGrate(new ResourceLocation("betterwithmods", "textures/blocks/wood_side_" + woodTypes[i] + ".png")));
        }
        RenderUtils.addFilter(new ItemStack(BWMBlocks.PANE, 1, 2), new ModelOpaque(new ResourceLocation("betterwithmods", "textures/blocks/wicker.png")));
        RenderUtils.addFilter(new ItemStack(Blocks.field_150425_aM), new ModelOpaque(new ResourceLocation("minecraft", "textures/blocks/soul_sand.png")));
        RenderUtils.addFilter(new ItemStack(Blocks.field_150411_aY), new ModelTransparent(new ResourceLocation("minecraft", "textures/blocks/iron_bars.png")));
        RenderUtils.addFilter(new ItemStack(Blocks.field_150468_ap), new ModelTransparent(new ResourceLocation("minecraft", "textures/blocks/ladder.png")));
        RenderUtils.addFilter(new ItemStack(Blocks.field_150415_aT), new ModelTransparent(new ResourceLocation("minecraft", "textures/blocks/trapdoor.png")));
        RenderUtils.addFilter(new ItemStack(Blocks.field_180400_cw), new ModelTransparent(new ResourceLocation("minecraft", "textures/blocks/iron_trapdoor.png")));
    }

    public static void renderFill(ResourceLocation textureLocation, BlockPos pos, double x, double y, double z, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        Tessellator t = Tessellator.func_178181_a();
        VertexBuffer renderer = t.func_178180_c();
        renderer.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        RenderUtils.minecraft.field_71446_o.func_110577_a(TextureMap.field_110575_b);
        int brightness = RenderUtils.minecraft.field_71441_e.func_175626_b(pos, RenderUtils.minecraft.field_71441_e.func_175699_k(pos));
        RenderUtils.preRender(x, y, z);
        TextureAtlasSprite sprite = minecraft.func_147117_R().getTextureExtry(textureLocation.toString());
        RenderUtils.drawTexturedQuad(renderer, sprite, minX, minY, minZ, maxX - minX, maxY - minY, maxZ - minZ, brightness, EnumFacing.UP);
        RenderUtils.drawTexturedQuad(renderer, sprite, minX, minY, minZ, maxX - minX, maxY - minY, maxZ - minZ, brightness, EnumFacing.WEST);
        RenderUtils.drawTexturedQuad(renderer, sprite, minX, minY, minZ, maxX - minX, maxY - minY, maxZ - minZ, brightness, EnumFacing.EAST);
        RenderUtils.drawTexturedQuad(renderer, sprite, minX, minY, minZ, maxX - minX, maxY - minY, maxZ - minZ, brightness, EnumFacing.NORTH);
        RenderUtils.drawTexturedQuad(renderer, sprite, minX, minY, minZ, maxX - minX, maxY - minY, maxZ - minZ, brightness, EnumFacing.SOUTH);
        t.func_78381_a();
        RenderUtils.postRender();
    }

    private static void preRender(double x, double y, double z) {
        GlStateManager.func_179094_E();
        RenderHelper.func_74518_a();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (Minecraft.func_71379_u()) {
            GL11.glShadeModel((int)7425);
        } else {
            GL11.glShadeModel((int)7424);
        }
        GlStateManager.func_179137_b((double)x, (double)y, (double)z);
    }

    private static void postRender() {
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
        RenderHelper.func_74519_b();
    }

    private static void drawTexturedQuad(VertexBuffer renderer, TextureAtlasSprite sprite, double x, double y, double z, double w, double h, double d, int brightness, EnumFacing facing) {
        double maxV;
        double minV;
        double maxU;
        double minU;
        double zt2;
        double yt2;
        double xt2;
        if (sprite == null) {
            sprite = minecraft.func_147117_R().func_174944_f();
        }
        int light1 = brightness >> 16 & 0xFFFF;
        int light2 = brightness & 0xFFFF;
        int r = 255;
        int g = 255;
        int b = 255;
        int a = 255;
        double size = 16.0;
        double x2 = x + w;
        double y2 = y + h;
        double z2 = z + d;
        double xt1 = x % 1.0;
        for (xt2 = xt1 + w; xt2 > 1.0; xt2 -= 1.0) {
        }
        double yt1 = y % 1.0;
        for (yt2 = yt1 + h; yt2 > 1.0; yt2 -= 1.0) {
        }
        double zt1 = z % 1.0;
        for (zt2 = zt1 + d; zt2 > 1.0; zt2 -= 1.0) {
        }
        switch (facing) {
            case DOWN: 
            case UP: {
                minU = sprite.func_94214_a(xt1 * size);
                maxU = sprite.func_94214_a(xt2 * size);
                minV = sprite.func_94207_b(zt1 * size);
                maxV = sprite.func_94207_b(zt2 * size);
                break;
            }
            case NORTH: 
            case SOUTH: {
                minU = sprite.func_94214_a(xt2 * size);
                maxU = sprite.func_94214_a(xt1 * size);
                minV = sprite.func_94207_b(yt1 * size);
                maxV = sprite.func_94207_b(yt2 * size);
                break;
            }
            case WEST: 
            case EAST: {
                minU = sprite.func_94214_a(zt2 * size);
                maxU = sprite.func_94214_a(zt1 * size);
                minV = sprite.func_94207_b(yt1 * size);
                maxV = sprite.func_94207_b(yt2 * size);
                break;
            }
            default: {
                minU = sprite.func_94209_e();
                maxU = sprite.func_94212_f();
                minV = sprite.func_94206_g();
                maxV = sprite.func_94210_h();
            }
        }
        switch (facing) {
            case DOWN: {
                renderer.func_181662_b(x, y, z).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y, z).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x, y, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case UP: {
                renderer.func_181662_b(x, y2, z).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x, y2, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case NORTH: {
                renderer.func_181662_b(x, y, z).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x, y2, z).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y, z).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case SOUTH: {
                renderer.func_181662_b(x, y, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x, y2, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case WEST: {
                renderer.func_181662_b(x, y, z).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x, y, z2).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x, y2, z2).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x, y2, z).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                break;
            }
            case EAST: {
                renderer.func_181662_b(x2, y, z).func_181669_b(r, g, b, a).func_187315_a(minU, maxV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z).func_181669_b(r, g, b, a).func_187315_a(minU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y2, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, minV).func_187314_a(light1, light2).func_181675_d();
                renderer.func_181662_b(x2, y, z2).func_181669_b(r, g, b, a).func_187315_a(maxU, maxV).func_187314_a(light1, light2).func_181675_d();
            }
        }
    }

    public static TextureAtlasSprite getSprite(ItemStack stack) {
        if (renderItem == null) {
            renderItem = Minecraft.func_71410_x().func_175599_af();
        }
        return renderItem.func_184393_a(stack, null, null).func_177554_e();
    }

    public static ResourceLocation getResourceLocation(ItemStack stack) {
        TextureAtlasSprite sprite = RenderUtils.getSprite(stack);
        String iconLoc = sprite.func_94215_i();
        String domain = iconLoc.substring(0, iconLoc.indexOf(58));
        String resource = iconLoc.substring(iconLoc.indexOf(58) + 1, iconLoc.length());
        return new ResourceLocation(domain, "textures/" + resource + ".png");
    }
}

