/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.blocks.BlockAesthetic;
import betterwithmods.common.blocks.BlockRawPastry;
import betterwithmods.common.items.ItemBark;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.common.registry.OreStack;
import betterwithmods.util.RecipeUtils;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFishFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class BWOreDictionary {
    public static List<ItemStack> seedNames;
    public static List<ItemStack> cropNames;
    public static List<ItemStack> dustNames;
    public static List<ItemStack> oreNames;
    public static List<ItemStack> ingotNames;
    public static List<Wood> woods;
    public static List<ItemStack> planks;
    public static List<ItemStack> logs;

    public static void registerOres() {
        BWOreDictionary.registerOre("book", BWMItems.MANUAL);
        BWOreDictionary.registerOre("gearSoulforgedSteel", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.STEEL_GEAR));
        BWOreDictionary.registerOre("gearWood", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GEAR));
        BWOreDictionary.registerOre("cropHemp", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HEMP));
        BWOreDictionary.registerOre("dyeBrown", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.DUNG));
        BWOreDictionary.registerOre("dung", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.DUNG));
        BWOreDictionary.registerOre("slimeball", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GLUE));
        BWOreDictionary.registerOre("ingotSoulforgedSteel", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.INGOT_STEEL));
        BWOreDictionary.registerOre("dustNetherrack", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GROUND_NETHERRACK));
        BWOreDictionary.registerOre("dustHellfire", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HELLFIRE_DUST));
        BWOreDictionary.registerOre("dustSoul", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SOUL_DUST));
        BWOreDictionary.registerOre("ingotConcentratedHellfire", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.CONCENTRATED_HELLFIRE));
        BWOreDictionary.registerOre("dustCoal", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.COAL_DUST));
        BWOreDictionary.registerOre("dustPotash", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.POTASH));
        BWOreDictionary.registerOre("dustWood", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SAWDUST));
        BWOreDictionary.registerOre("dustSulfur", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.BRIMSTONE));
        BWOreDictionary.registerOre("dustSaltpeter", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.NITER));
        BWOreDictionary.registerOre("nuggetIron", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.NUGGET_IRON));
        BWOreDictionary.registerOre("nuggetSoulforgedSteel", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.NUGGET_STEEL));
        BWOreDictionary.registerOre("foodFlour", BlockRawPastry.getStack(BlockRawPastry.EnumType.BREAD));
        BWOreDictionary.registerOre("dustCharcoal", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.CHARCOAL_DUST));
        BWOreDictionary.registerOre("foodCocoapowder", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.COCOA_POWDER));
        BWOreDictionary.registerOre("dustCarbon", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.COAL_DUST), ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.CHARCOAL_DUST));
        BWOreDictionary.registerOre("coal", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.NETHERCOAL));
        BWOreDictionary.registerOre("foodChocolatebar", new ItemStack(BWMItems.CHOCOLATE));
        BWOreDictionary.registerOre("blockSoulforgedSteel", new ItemStack(BWMBlocks.AESTHETIC, 1, 2));
        BWOreDictionary.registerOre("blockConcentratedHellfire", new ItemStack(BWMBlocks.AESTHETIC, 1, 3));
        BWOreDictionary.registerOre("barkWood", new ItemStack(BWMItems.BARK, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("barkOak", new ItemStack(BWMItems.BARK, 1, 0));
        BWOreDictionary.registerOre("barkSpruce", new ItemStack(BWMItems.BARK, 1, 1));
        BWOreDictionary.registerOre("barkBirch", new ItemStack(BWMItems.BARK, 1, 2));
        BWOreDictionary.registerOre("barkJungle", new ItemStack(BWMItems.BARK, 1, 3));
        BWOreDictionary.registerOre("barkAcacia", new ItemStack(BWMItems.BARK, 1, 4));
        BWOreDictionary.registerOre("barkDarkOak", new ItemStack(BWMItems.BARK, 1, 5));
        BWOreDictionary.registerOre("hideScoured", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SCOURED_LEATHER));
        BWOreDictionary.registerOre("hideTanned", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.TANNED_LEATHER));
        BWOreDictionary.registerOre("slabWood", new ItemStack(BWMBlocks.WOOD_SIDING, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("sidingWood", new ItemStack(BWMBlocks.WOOD_SIDING, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("mouldingWood", new ItemStack(BWMBlocks.WOOD_MOULDING, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("cornerWood", new ItemStack(BWMBlocks.WOOD_CORNER, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("sidingStone", new ItemStack(BWMBlocks.STONE_SIDING, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("mouldingStone", new ItemStack(BWMBlocks.STONE_MOULDING, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("cornerStone", new ItemStack(BWMBlocks.STONE_CORNER, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("fiberHemp", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HEMP_FIBERS));
        BWOreDictionary.registerOre("fabricHemp", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.HEMP_CLOTH));
        BWOreDictionary.registerOre("ingotDiamond", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.DIAMOND_INGOT));
        BWOreDictionary.registerOre("nuggetDiamond", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.DIAMOND_NUGGET));
        BWOreDictionary.registerOre("listAllmeat", Items.field_151147_al, Items.field_151082_bd, Items.field_151076_bf, Items.field_151115_aP, Items.field_179561_bm, BWMItems.MYSTERY_MEAT);
        BWOreDictionary.registerOre("listAllmeat", new ItemStack(Items.field_151115_aP, 1, ItemFishFood.FishType.SALMON.func_150976_a()));
        BWOreDictionary.registerOre("listAllmeatcooked", Items.field_151157_am, Items.field_151083_be, Items.field_151077_bg, Items.field_179566_aV, Items.field_179557_bn, Items.field_179559_bp, BWMItems.COOKED_MYSTERY_MEAT);
        BWOreDictionary.registerOre("listAllmeatcooked", new ItemStack(Items.field_179566_aV, 1, ItemFishFood.FishType.SALMON.func_150976_a()));
        BWOreDictionary.registerOre("tallow", ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.TALLOW));
        BWOreDictionary.registerOre("blockHellfire", new ItemStack(BWMBlocks.AESTHETIC, 1, BlockAesthetic.EnumType.HELLFIRE.getMeta()));
        BWOreDictionary.registerOre("blockPlanter", new ItemStack(BWMBlocks.PLANTER, 1, Short.MAX_VALUE));
        BWOreDictionary.registerOre("pile", new ItemStack(BWMItems.DIRT_PILE), new ItemStack(BWMItems.SAND_PILE), new ItemStack(BWMItems.RED_SAND_PILE), new ItemStack(BWMItems.GRAVEL_PILE));
        Collections.addAll(woods, new Wood(new ItemStack(Blocks.field_150364_r, 1, 0), new ItemStack(Blocks.field_150344_f, 1, 0), ItemBark.getStack("oak", 1)), new Wood(new ItemStack(Blocks.field_150364_r, 1, 1), new ItemStack(Blocks.field_150344_f, 1, 1), ItemBark.getStack("spruce", 1)), new Wood(new ItemStack(Blocks.field_150364_r, 1, 2), new ItemStack(Blocks.field_150344_f, 1, 2), ItemBark.getStack("birch", 1)), new Wood(new ItemStack(Blocks.field_150364_r, 1, 3), new ItemStack(Blocks.field_150344_f, 1, 3), ItemBark.getStack("jungle", 1)), new Wood(new ItemStack(Blocks.field_150363_s, 1, 0), new ItemStack(Blocks.field_150344_f, 1, 4), ItemBark.getStack("acacia", 1)), new Wood(new ItemStack(Blocks.field_150363_s, 1, 1), new ItemStack(Blocks.field_150344_f, 1, 5), ItemBark.getStack("dark_oak", 1)));
    }

    public static void registerWood(ItemStack log, ItemStack plank, ItemStack bark) {
        woods.add(new Wood(log, plank, bark));
    }

    public static void registerOre(String ore, ItemStack ... items) {
        for (ItemStack i : items) {
            OreDictionary.registerOre((String)ore, (ItemStack)i);
        }
    }

    public static void registerOre(String ore, Item ... items) {
        for (Item item : items) {
            BWOreDictionary.registerOre(ore, new ItemStack(item));
        }
    }

    public static void postInitOreDictGathering() {
        dustNames = BWOreDictionary.getOreNames("dust");
        oreNames = BWOreDictionary.getOreNames("ore");
        ingotNames = BWOreDictionary.getOreNames("ingot");
        cropNames = BWOreDictionary.getOreNames("crop");
        seedNames = BWOreDictionary.getOreNames("seed");
        List logs = OreDictionary.getOres((String)"logWood").stream().filter(stack -> !stack.func_77973_b().getRegistryName().func_110624_b().equalsIgnoreCase("minecraft")).collect(Collectors.toList());
        for (ItemStack log : logs) {
            if (log.func_77960_j() == Short.MAX_VALUE) {
                for (int i = 0; i <= 4; ++i) {
                    ItemStack plank = RecipeUtils.getRecipeOutput(new ItemStack(log.func_77973_b(), 1, i));
                    System.out.println(plank);
                    if (!BWOreDictionary.isOre(plank, "plankWood")) continue;
                    Wood wood = new Wood(new ItemStack(log.func_77973_b(), 1, i), plank);
                    woods.add(wood);
                }
                continue;
            }
            ItemStack plank = RecipeUtils.getRecipeOutput(log);
            System.out.println(plank);
            if (!BWOreDictionary.isOre(plank, "plankWood")) continue;
            Wood wood = new Wood(log, plank);
            woods.add(wood);
        }
    }

    public static String getSuffix(ItemStack stack, String startingPrefix) {
        return IntStream.of(OreDictionary.getOreIDs((ItemStack)stack)).mapToObj(OreDictionary::getOreName).map(ore -> ore.substring(startingPrefix.length())).findFirst().orElse(null);
    }

    public static List<ItemStack> getOreNames(String prefix) {
        return Arrays.stream(OreDictionary.getOreNames()).filter(n -> n.startsWith(prefix)).flatMap(n -> OreDictionary.getOres((String)n).stream()).collect(Collectors.toList());
    }

    public static int listContains(Object obj, List<Object> list) {
        if (list != null && list.size() > 0 && !list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Object toCheck;
                Object stack;
                if (obj instanceof ItemStack && list.get(i) instanceof ItemStack) {
                    stack = (ItemStack)obj;
                    toCheck = (ItemStack)list.get(i);
                    if (!ItemStack.func_179545_c((ItemStack)stack, (ItemStack)toCheck)) continue;
                    if (toCheck.func_77942_o()) {
                        if (!ItemStack.func_77970_a((ItemStack)stack, (ItemStack)toCheck)) continue;
                        return i;
                    }
                    if (stack.func_77942_o()) {
                        return -1;
                    }
                    return i;
                }
                if (!(obj instanceof OreStack) || !(list.get(i) instanceof OreStack)) continue;
                stack = (OreStack)obj;
                toCheck = (OreStack)list.get(i);
                if (!((OreStack)stack).getOreName().equals(((OreStack)toCheck).getOreName())) continue;
                return i;
            }
        }
        return -1;
    }

    public static boolean isOre(ItemStack stack, String ore) {
        return BWOreDictionary.listContains(stack, (List<ItemStack>)OreDictionary.getOres((String)ore));
    }

    public static boolean listContains(ItemStack check, List<ItemStack> list) {
        if (list != null) {
            if (list.isEmpty()) {
                return false;
            }
            for (ItemStack item : list) {
                if (!ItemStack.func_179545_c((ItemStack)check, (ItemStack)item) && (check.func_77973_b() != item.func_77973_b() || item.func_77952_i() != Short.MAX_VALUE)) continue;
                return !item.func_77942_o() || ItemStack.func_77970_a((ItemStack)check, (ItemStack)item);
            }
        }
        return false;
    }

    public static boolean hasSuffix(ItemStack stack, String suffix) {
        return BWOreDictionary.listContains(stack, BWOreDictionary.getOreNames(suffix));
    }

    static {
        woods = Lists.newArrayList();
    }

    public static class Wood {
        public ItemStack log;
        public ItemStack plank;
        public ItemStack bark;

        public Wood(ItemStack log, ItemStack plank) {
            this.log = log;
            this.plank = plank;
            this.bark = ItemBark.getStack("oak", 1);
        }

        public Wood(ItemStack log, ItemStack plank, ItemStack bark) {
            this.log = log;
            this.plank = plank;
            this.bark = bark;
        }

        public ItemStack getLog(int count) {
            ItemStack copy = this.log.func_77946_l();
            copy.func_190920_e(count);
            return copy;
        }

        public ItemStack getPlank(int count) {
            ItemStack copy = this.plank.func_77946_l();
            copy.func_190920_e(count);
            return copy;
        }

        public ItemStack getBark(int count) {
            ItemStack copy = this.bark.func_77946_l();
            copy.func_190920_e(count);
            return copy;
        }

        public ItemStack getSawdust(int count) {
            ItemStack copy = ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.SAWDUST, count);
            return copy;
        }
    }
}

