/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common;

import betterwithmods.BWMod;
import betterwithmods.api.capabilities.MechanicalCapability;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.BWFuelHandler;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.BWSounds;
import betterwithmods.common.blocks.BlockBDispenser;
import betterwithmods.common.blocks.behaviors.BehaviorDiodeDispense;
import betterwithmods.common.blocks.behaviors.BehaviorSilkTouch;
import betterwithmods.common.entity.EntityBroadheadArrow;
import betterwithmods.common.entity.EntityDynamite;
import betterwithmods.common.entity.EntityExtendingRope;
import betterwithmods.common.entity.EntityFallingGourd;
import betterwithmods.common.entity.EntityMiningCharge;
import betterwithmods.common.entity.EntityShearedCreeper;
import betterwithmods.common.entity.EntitySpiderWeb;
import betterwithmods.common.entity.EntityUrn;
import betterwithmods.common.entity.item.EntityFallingBlockCustom;
import betterwithmods.common.entity.item.EntityItemBuoy;
import betterwithmods.common.potion.BWPotion;
import betterwithmods.common.registry.BellowsManager;
import betterwithmods.common.registry.ChoppingRecipe;
import betterwithmods.common.registry.CuttingRecipe;
import betterwithmods.common.registry.DyeWithTagRecipe;
import betterwithmods.common.registry.KilnStructureManager;
import betterwithmods.common.registry.heat.BWMHeatRegistry;
import betterwithmods.common.registry.steelanvil.SteelShapedOreRecipe;
import betterwithmods.common.registry.steelanvil.SteelShapedRecipe;
import betterwithmods.common.registry.steelanvil.SteelShapelessRecipe;
import betterwithmods.util.ColorUtils;
import betterwithmods.util.DispenserBehaviorDynamite;
import betterwithmods.util.InvUtils;
import li.cil.manual.api.API;
import li.cil.manual.common.api.ManualAPIImpl;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.RecipeSorter;

public class BWRegistry {
    public static final Potion POTION_TRUESIGHT = (Potion)new BWPotion(false, 14270531, 4, 1).setRegistryName("true_sight");
    private static int availableEntityId = 0;

    public static void preInit() {
        API.manualAPI = ManualAPIImpl.INSTANCE;
        BWMBlocks.registerBlocks();
        BWMItems.registerItems();
        BWMBlocks.registerTileEntities();
        BWOreDictionary.registerOres();
        BWRegistry.registerEntities();
        BWRegistry.registerPotions();
        BWRegistry.registerBlockDispenserBehavior();
        CapabilityManager.INSTANCE.register(IMechanicalPower.class, (Capability.IStorage)new MechanicalCapability.CapabilityMechanicalPower(), MechanicalCapability.DefaultMechanicalPower.class);
        KilnStructureManager.registerKilnBlock(Blocks.field_150336_V.func_176223_P());
        KilnStructureManager.registerKilnBlock(Blocks.field_150385_bj.func_176223_P());
    }

    public static void init() {
        GameRegistry.registerFuelHandler((IFuelHandler)new BWFuelHandler());
        BWRegistry.registerHeatSources();
        BWSounds.registerSounds();
        RecipeSorter.register((String)"bwm:chopping", ChoppingRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessore");
        RecipeSorter.register((String)"bwm:cutting", CuttingRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessore");
        RecipeSorter.register((String)"bwm:dyetag", DyeWithTagRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessore");
        RecipeSorter.register((String)"bwm:steel_shapeless", SteelShapelessRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:forge:shapelessore");
        RecipeSorter.register((String)"bwm:steel_shaped", SteelShapedRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:forge:shapedore");
        RecipeSorter.register((String)"bwm:steel_shaped_ore", SteelShapedOreRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPED, (String)"after:forge:shapedore");
    }

    public static void postInit() {
        BWOreDictionary.postInitOreDictGathering();
        ColorUtils.initColors();
        BellowsManager.postInit();
    }

    private static void registerEntities() {
        BWRegistry.registerEntity(EntityExtendingRope.class, "extending_rope", 64, 20, true);
        BWRegistry.registerEntity(EntityDynamite.class, "bwm_dynamite", 10, 50, true);
        BWRegistry.registerEntity(EntityUrn.class, "bwm_urn", 10, 50, true);
        BWRegistry.registerEntity(EntityMiningCharge.class, "bwm_mining_charge", 10, 50, true);
        BWRegistry.registerEntity(EntityItemBuoy.class, "entity_item_buoy", 64, 20, true);
        BWRegistry.registerEntity(EntityShearedCreeper.class, "entity_sheared_creeper", 64, 1, true);
        BWRegistry.registerEntity(EntityBroadheadArrow.class, "entity_broadhead_arrow", 64, 1, true);
        BWRegistry.registerEntity(EntityFallingGourd.class, "entity_falling_gourd", 64, 1, true);
        BWRegistry.registerEntity(EntityFallingBlockCustom.class, "falling_block_custom", 64, 20, true);
        BWRegistry.registerEntity(EntitySpiderWeb.class, "bwm_spider_web", 64, 20, true);
    }

    public static void registerBlockDispenserBehavior() {
        BlockDispenser.field_149943_a.func_82595_a((Object)BWMItems.DYNAMITE, (Object)new DispenserBehaviorDynamite());
        BlockBDispenser.BLOCK_DISPENSER_REGISTRY.func_82595_a((Object)Items.field_151107_aW, (Object)new BehaviorDiodeDispense());
        BlockBDispenser.BLOCK_DISPENSER_REGISTRY.func_82595_a((Object)Items.field_151132_bS, (Object)new BehaviorDiodeDispense());
        BlockBDispenser.BLOCK_DISPENSER_REGISTRY.func_82595_a((Object)Item.func_150898_a((Block)BWMBlocks.MINING_CHARGE), (source, stack) -> {
            World worldIn = source.func_82618_k();
            EnumFacing facing = (EnumFacing)source.func_189992_e().func_177229_b((IProperty)BlockDispenser.field_176441_a);
            BlockPos pos = source.func_180699_d().func_177972_a(facing);
            EntityMiningCharge miningCharge = new EntityMiningCharge(worldIn, (float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f, null, facing);
            miningCharge.func_189654_d(false);
            worldIn.func_72838_d((Entity)miningCharge);
            worldIn.func_184148_a(null, miningCharge.field_70165_t, miningCharge.field_70163_u, miningCharge.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return stack;
        });
        BlockBDispenser.BLOCK_COLLECT_REGISTRY.func_82595_a((Object)Blocks.field_150348_b, (Object)new BehaviorSilkTouch());
        BlockBDispenser.BLOCK_COLLECT_REGISTRY.func_82595_a((Object)BWMBlocks.STUMP, (Object)new BehaviorSilkTouch());
        BlockBDispenser.ENTITY_COLLECT_REGISTRY.func_82595_a(EntityWolf.class, (world, pos, entity, stack) -> {
            InvUtils.ejectStackWithOffset(world, pos, new ItemStack(Items.field_151007_F, 1 + world.field_73012_v.nextInt(3)));
            world.func_184133_a(null, pos, SoundEvents.field_187863_gH, SoundCategory.NEUTRAL, 0.75f, 1.0f);
            entity.func_70106_y();
            return InvUtils.asNonnullList(new ItemStack(BWMBlocks.WOLF));
        });
        BlockBDispenser.ENTITY_COLLECT_REGISTRY.func_82595_a(EntitySheep.class, (world, pos, entity, stack) -> {
            EntitySheep sheep = (EntitySheep)entity;
            if (sheep.isShearable(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)world, pos)) {
                return InvUtils.asNonnullList(sheep.onSheared(new ItemStack((Item)Items.field_151097_aZ), (IBlockAccess)world, pos, 0));
            }
            return NonNullList.func_191196_a();
        });
        BlockBDispenser.ENTITY_COLLECT_REGISTRY.func_82595_a(EntityChicken.class, (world, pos, entity, stack) -> {
            InvUtils.ejectStackWithOffset(world, pos, new ItemStack(Items.field_151008_G, 1 + world.field_73012_v.nextInt(2)));
            world.func_184133_a(null, pos, SoundEvents.field_187666_Z, SoundCategory.NEUTRAL, 0.75f, 1.0f);
            entity.func_70106_y();
            return InvUtils.asNonnullList(new ItemStack(Items.field_151110_aK));
        });
        BlockBDispenser.ENTITY_COLLECT_REGISTRY.func_82595_a(EntityCow.class, (world, pos, entity, stack) -> {
            if (stack.func_77969_a(new ItemStack(Items.field_151133_ar))) {
                stack.func_190918_g(1);
                world.func_184133_a(null, pos, SoundEvents.field_187564_an, SoundCategory.BLOCKS, 1.0f, 1.0f);
                InvUtils.ejectStackWithOffset(world, pos, new ItemStack(Items.field_151117_aB));
            }
            return NonNullList.func_191196_a();
        });
    }

    public static void registerEntity(Class<? extends Entity> entityClass, String entityName, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation("betterwithmods:" + entityName), entityClass, (String)entityName, (int)availableEntityId, (Object)BWMod.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
        ++availableEntityId;
    }

    public static void registerHeatSources() {
        BWMHeatRegistry.setBlockHeatRegistry((Block)Blocks.field_150480_ab, 3);
        BWMHeatRegistry.setBlockHeatRegistry(BWMBlocks.STOKED_FLAME, 8);
    }

    private static void registerPotions() {
        BWRegistry.registerPotion(POTION_TRUESIGHT);
    }

    private static void registerPotion(Potion potion) {
        String potionName = potion.getRegistryName().toString().substring("betterwithmods".length() + ":".length());
        potion.func_76390_b("bwm.effect." + potionName);
        GameRegistry.register((IForgeRegistryEntry)potion);
    }
}

