/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAesthetic
extends BWMBlock
implements IMultiVariants {
    public static final PropertyEnum<EnumType> blockType = PropertyEnum.func_177709_a((String)"blocktype", EnumType.class);

    public BlockAesthetic() {
        super(Material.field_151576_e);
        this.func_149647_a(BWCreativeTabs.BWTAB);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(blockType, (Comparable)((Object)EnumType.CHOPBLOCK)));
    }

    public static ItemStack getStack(EnumType type) {
        return new ItemStack(BWMBlocks.AESTHETIC, 1, type.getMeta());
    }

    public float func_176195_g(IBlockState state, World worldIn, BlockPos pos) {
        return ((EnumType)((Object)state.func_177229_b(blockType))).getHardness();
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return ((EnumType)((Object)state.func_177229_b(blockType))).getSoundType();
    }

    public Material func_149688_o(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(blockType))).getMaterial();
    }

    public MapColor func_180659_g(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(blockType))).getMapColor();
    }

    public int getHarvestLevel(IBlockState state) {
        return state.func_177229_b(blockType) == EnumType.STEEL ? 4 : 1;
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return state.func_177229_b(blockType) != EnumType.STEEL || entity instanceof EntityPlayer;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (world.func_180495_p(pos).func_177229_b(blockType) != EnumType.STEEL) {
            super.onBlockExploded(world, pos, explosion);
        }
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        return ((EnumType)((Object)world.func_180495_p(pos).func_177229_b(blockType))).getResistance();
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    @Override
    public String[] getVariants() {
        return new String[]{"blocktype=chopping", "blocktype=chopping_blood", "blocktype=steel", "blocktype=hellfire", "blocktype=rope", "blocktype=flint", "blocktype=whitestone", "blocktype=whitecobble", "blocktype=enderblock", "blocktype=padding", "blocktype=soap", "blocktype=dung", "blocktype=wicker"};
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < EnumType.META_LOOKUP.length; ++i) {
            list.add((Object)new ItemStack(item, 1, i));
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(blockType))).getMeta();
    }

    public boolean isFireSource(World world, BlockPos pos, EnumFacing side) {
        return world.func_180495_p(pos).func_177229_b(blockType) == EnumType.HELLFIRE;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(blockType, (Comparable)((Object)EnumType.byMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(blockType))).getMeta();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{blockType});
    }

    public static enum EnumType implements IStringSerializable
    {
        CHOPBLOCK(0, "chopping", MapColor.field_151665_m),
        CHOPBLOCKBLOOD(1, "chopping_blood", MapColor.field_151655_K),
        STEEL(2, "steel", MapColor.field_151668_h, Material.field_151573_f, SoundType.field_185852_e, 100.0f, 4000.0f),
        HELLFIRE(3, "hellfire", MapColor.field_151676_q),
        ROPE(4, "rope", MapColor.field_151664_l, Material.field_151580_n, SoundType.field_185854_g, 1.0f, 5.0f),
        FLINT(5, "flint", MapColor.field_151665_m),
        WHITESTONE(6, "whitestone", MapColor.field_151659_e),
        WHITECOBBLE(7, "whitecobble", MapColor.field_151659_e),
        ENDERBLOCK(8, "enderblock", MapColor.field_151679_y),
        PADDING(9, "padding", MapColor.field_151659_e, Material.field_151580_n, SoundType.field_185854_g, 1.0f, 5.0f),
        SOAP(10, "soap", MapColor.field_151671_v, Material.field_151578_c, SoundType.field_185849_b, 1.0f, 5.0f),
        DUNG(11, "dung", MapColor.field_151650_B, Material.field_151578_c, SoundType.field_185849_b, 1.0f, 2.0f),
        WICKER(12, "wicker", MapColor.field_151650_B, Material.field_151575_d, SoundType.field_185848_a, 1.0f, 5.0f);

        private static final EnumType[] META_LOOKUP;
        private final int meta;
        private final String name;
        private final MapColor color;
        private final Material material;
        private final SoundType soundType;
        private final float hardness;
        private final float resistance;

        private EnumType(int meta, String name, MapColor color) {
            this.meta = meta;
            this.name = name;
            this.color = color;
            this.material = Material.field_151576_e;
            this.soundType = SoundType.field_185851_d;
            this.hardness = 1.5f;
            this.resistance = 10.0f;
        }

        private EnumType(int meta, String name, MapColor color, Material material, SoundType soundType, float hardness, float resistance) {
            this.meta = meta;
            this.name = name;
            this.color = color;
            this.material = material;
            this.soundType = soundType;
            this.hardness = hardness;
            this.resistance = resistance;
        }

        public static EnumType byMeta(int meta) {
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        public MapColor getMapColor() {
            return this.color;
        }

        public Material getMaterial() {
            return this.material;
        }

        public SoundType getSoundType() {
            return this.soundType;
        }

        public float getHardness() {
            return this.hardness;
        }

        public float getResistance() {
            return this.resistance;
        }

        static {
            META_LOOKUP = EnumType.values();
        }
    }
}

