/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.block.IAxle;
import betterwithmods.api.block.IMechanical;
import betterwithmods.api.block.IMechanicalBlock;
import betterwithmods.api.block.IMultiVariants;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWSounds;
import betterwithmods.common.blocks.BlockRotate;
import betterwithmods.util.DirUtils;
import betterwithmods.util.InvUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockAxle
extends BlockRotate
implements IMechanical,
IAxle,
IMultiVariants {
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177709_a((String)"axis", EnumFacing.Axis.class);
    public static final PropertyInteger SIGNAL = PropertyInteger.func_177719_a((String)"signal", (int)0, (int)4);
    public static final int TICK_RATE = 1;
    private static final AxisAlignedBB X_AABB = new AxisAlignedBB(0.0, 0.375, 0.375, 1.0, 0.625, 0.625);
    private static final AxisAlignedBB Y_AABB = new AxisAlignedBB(0.375, 0.0, 0.375, 0.625, 1.0, 0.625);
    private static final AxisAlignedBB Z_AABB = new AxisAlignedBB(0.375, 0.375, 0.0, 0.625, 0.625, 1.0);

    public BlockAxle() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(AXIS, (Comparable)EnumFacing.Axis.Y).func_177226_a((IProperty)SIGNAL, (Comparable)Integer.valueOf(0)));
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
        this.func_149647_a(BWCreativeTabs.BWTAB);
    }

    @Override
    public String[] getVariants() {
        return new String[]{"axis=y,signal=0"};
    }

    @Override
    public void nextState(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)SIGNAL, (Comparable)Integer.valueOf(0)).func_177231_a(AXIS));
    }

    public int func_149738_a(World world) {
        return 1;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing.Axis)state.func_177229_b(AXIS)) {
            case X: {
                return X_AABB;
            }
            case Y: {
                return Y_AABB;
            }
        }
        return Z_AABB;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_180497_b(pos, (Block)this, 1, 5);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        this.validatePowerLevel(world, pos);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.setPowerLevel(world, pos, 0);
        this.validatePowerLevel(world, pos);
    }

    private void setPowerLevel(World world, BlockPos pos, int power) {
        IBlockState state = world.func_180495_p(pos);
        world.func_175656_a(pos, state.func_177226_a((IProperty)SIGNAL, (Comparable)Integer.valueOf(power)));
    }

    private void validatePowerLevel(World world, BlockPos pos) {
        int newPower;
        int currentPower = this.getPowerLevel((IBlockAccess)world, pos);
        int maxNeighborPower = 0;
        int greaterPowerNeighbors = 0;
        EnumFacing.Axis axis = (EnumFacing.Axis)world.func_180495_p(pos).func_177229_b(AXIS);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            BlockPos pos2;
            Block block;
            if (dir.func_176740_k() != axis || !((block = world.func_180495_p(pos2 = pos.func_177972_a(dir)).func_177230_c()) instanceof IMechanical)) continue;
            IMechanical mech = (IMechanical)block;
            int powerLevel = mech.getMechPowerLevelToFacing(world, pos2, dir.func_176734_d());
            if (powerLevel > maxNeighborPower) {
                maxNeighborPower = powerLevel;
            }
            if (powerLevel <= currentPower) continue;
            ++greaterPowerNeighbors;
        }
        if (greaterPowerNeighbors >= 2) {
            this.breakAxle(world, pos);
            return;
        }
        if (maxNeighborPower > currentPower) {
            if (maxNeighborPower == 1) {
                this.breakAxle(world, pos);
                return;
            }
            newPower = maxNeighborPower - 1;
        } else {
            newPower = 0;
        }
        if (newPower != currentPower) {
            this.setPowerLevel(world, pos, newPower);
        }
    }

    public void breakAxle(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            InvUtils.ejectStackWithOffset(world, pos, new ItemStack(BWMBlocks.AXLE, 1, 0));
            world.func_175698_g(pos);
        }
    }

    @Override
    public int getMechPowerLevelToFacing(World world, BlockPos pos, EnumFacing dir) {
        EnumFacing.Axis axis = (EnumFacing.Axis)world.func_180495_p(pos).func_177229_b(AXIS);
        if (dir.func_176740_k() == axis) {
            return this.getPowerLevel((IBlockAccess)world, pos);
        }
        return 0;
    }

    @Override
    public boolean isMechanicalJunction() {
        return false;
    }

    @Override
    public int getPowerLevel(IBlockAccess world, BlockPos pos) {
        return this.getPowerLevelFromState(world.func_180495_p(pos));
    }

    private int getPowerLevelFromState(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)SIGNAL);
    }

    @Override
    public int getAxisAlignment(IBlockAccess world, BlockPos pos) {
        return DirUtils.getLegacyAxis((EnumFacing.Axis)world.func_180495_p(pos).func_177229_b(AXIS));
    }

    @Override
    public boolean isAxleOrientedToFacing(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        EnumFacing.Axis axis = (EnumFacing.Axis)world.func_180495_p(pos).func_177229_b(AXIS);
        return axis == dir.func_176740_k();
    }

    public void overpower(World world, BlockPos pos) {
        EnumFacing.Axis axis = (EnumFacing.Axis)world.func_180495_p(pos).func_177229_b(AXIS);
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            if (dir.func_176740_k() != axis) continue;
            this.overpowerBlockToSide(world, pos, axis, dir);
        }
    }

    private void overpowerBlockToSide(World world, BlockPos pos, EnumFacing.Axis sourceAxis, EnumFacing dir) {
        IMechanicalBlock mech;
        BlockPos pos2 = pos.func_177972_a(dir);
        Block block = world.func_180495_p(pos2).func_177230_c();
        if (block == BWMBlocks.AXLE) {
            EnumFacing.Axis axis = (EnumFacing.Axis)world.func_180495_p(pos2).func_177229_b(AXIS);
            if (axis == sourceAxis) {
                this.overpowerBlockToSide(world, pos2, sourceAxis, dir);
            }
        } else if (block instanceof IMechanicalBlock && (mech = (IMechanicalBlock)block).canInputPowerToSide((IBlockAccess)world, pos2, dir.func_176734_d())) {
            mech.overpower(world, pos2);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if ((Integer)state.func_177229_b((IProperty)SIGNAL) > 0) {
            this.emitAxleParticles(world, pos, rand);
            if (rand.nextInt(200) == 0) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, BWSounds.WOODCREAK, SoundCategory.BLOCKS, 0.15f, rand.nextFloat() * 0.1f + 0.5f, false);
            }
        }
    }

    private void emitAxleParticles(World world, BlockPos pos, Random rand) {
        int pow = this.getPowerLevel((IBlockAccess)world, pos);
        for (int i = 0; i < pow; ++i) {
            float flX = (float)pos.func_177958_n() + rand.nextFloat();
            float flY = (float)pos.func_177956_o() + rand.nextFloat() * 0.5f + 0.625f;
            float flZ = (float)pos.func_177952_p() + rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)flX, (double)flY, (double)flZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private int powerLevelFromMeta(int meta) {
        if (meta < 3) {
            return 0;
        }
        if (meta < 6) {
            return 1;
        }
        if (meta < 9) {
            return 2;
        }
        if (meta < 12) {
            return 3;
        }
        if (meta < 15) {
            return 4;
        }
        return 0;
    }

    private EnumFacing.Axis orientationFromMeta(int meta) {
        int powerLevel = 3 * this.powerLevelFromMeta(meta);
        return DirUtils.getAxisFromLegacy(meta - powerLevel);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)facing.func_176740_k());
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)SIGNAL) * 3 + DirUtils.getLegacyAxis((EnumFacing.Axis)state.func_177229_b(AXIS));
    }

    public IBlockState func_176203_a(int meta) {
        int power = this.powerLevelFromMeta(meta);
        EnumFacing.Axis ori = this.orientationFromMeta(meta);
        return this.func_176223_P().func_177226_a(AXIS, (Comparable)ori).func_177226_a((IProperty)SIGNAL, (Comparable)Integer.valueOf(power));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AXIS, SIGNAL});
    }
}

