/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.block.IAxle;
import betterwithmods.api.block.IMechanicalBlock;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWOreDictionary;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.BlockGearbox;
import betterwithmods.common.items.ItemMaterial;
import betterwithmods.util.DirUtils;
import betterwithmods.util.MechanicalUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BlockBrokenGearbox
extends BWMBlock
implements IMechanicalBlock {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"repair", (int)0, (int)1);

    public BlockBrokenGearbox() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)DirUtils.FACING, (Comparable)EnumFacing.UP).func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
        this.func_149647_a(BWCreativeTabs.BWTAB);
        this.func_149675_a(true);
    }

    public void func_190948_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"tooltip.broken_gearbox.name", (Object[])new Object[0]));
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    public void func_180645_a(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (MechanicalUtil.isBlockPoweredByAxle(worldIn, pos, this)) {
            for (int i = 0; i < 5; ++i) {
                float flX = (float)pos.func_177958_n() + rand.nextFloat();
                float flY = (float)pos.func_177956_o() + rand.nextFloat() * 0.5f + 1.0f;
                float flZ = (float)pos.func_177952_p() + rand.nextFloat();
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)flX, (double)flY, (double)flZ, 0.0, 0.0, 0.0, new int[0]);
            }
            worldIn.func_184133_a(null, pos, SoundEvents.field_187927_ha, SoundCategory.BLOCKS, 1.0f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.45f);
        }
        super.func_180645_a(worldIn, pos, state, rand);
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.func_180642_a(world, pos, side, flX, flY, flZ, meta, placer);
        return state.func_177226_a((IProperty)DirUtils.FACING, (Comparable)side.func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        EnumFacing facing = DirUtils.convertEntityOrientationToFacing(entity, EnumFacing.NORTH);
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)DirUtils.FACING, (Comparable)facing));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack hold = player.func_184586_b(hand);
        if (!hold.func_190926_b() && BWOreDictionary.listContains(hold, (List<ItemStack>)OreDictionary.getOres((String)"gearWood"))) {
            if (world.field_72995_K) {
                return true;
            }
            this.advanceStage(world, pos, state);
            if (!player.field_71075_bZ.field_75098_d) {
                hold.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    private void advanceStage(World world, BlockPos pos, IBlockState state) {
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 0) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(1)));
        } else {
            world.func_175656_a(pos, BWMBlocks.GEARBOX.func_176223_P().func_177226_a((IProperty)DirUtils.FACING, state.func_177229_b((IProperty)DirUtils.FACING)).func_177226_a((IProperty)BlockGearbox.ISACTIVE, (Comparable)Boolean.valueOf(false)));
        }
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        List list = super.getDrops(world, pos, state, fortune);
        if ((Integer)state.func_177229_b((IProperty)STAGE) == 1) {
            list.add(ItemMaterial.getMaterial(ItemMaterial.EnumMaterial.GEAR));
        }
        return list;
    }

    private boolean isAxle(IBlockAccess world, BlockPos origin, EnumFacing facing) {
        BlockPos pos = origin.func_177972_a(facing);
        Block block = world.func_180495_p(pos).func_177230_c();
        return block instanceof IAxle && ((IAxle)block).isAxleOrientedToFacing(world, pos, facing.func_176734_d());
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean[] dirs = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            EnumFacing facing = EnumFacing.func_82600_a((int)i);
            dirs[i] = this.isAxle(world, pos, facing) && state.func_177229_b((IProperty)DirUtils.FACING) != facing;
        }
        return state.func_177226_a((IProperty)DirUtils.DOWN, (Comparable)Boolean.valueOf(dirs[0])).func_177226_a((IProperty)DirUtils.UP, (Comparable)Boolean.valueOf(dirs[1])).func_177226_a((IProperty)DirUtils.NORTH, (Comparable)Boolean.valueOf(dirs[2])).func_177226_a((IProperty)DirUtils.SOUTH, (Comparable)Boolean.valueOf(dirs[3])).func_177226_a((IProperty)DirUtils.WEST, (Comparable)Boolean.valueOf(dirs[4])).func_177226_a((IProperty)DirUtils.EAST, (Comparable)Boolean.valueOf(dirs[5]));
    }

    public int func_176201_c(IBlockState state) {
        int meta = (Integer)state.func_177229_b((IProperty)STAGE) == 1 ? 8 : 0;
        return meta += ((EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        int stage = 0;
        if (meta > 7) {
            stage = 1;
            meta -= 8;
        }
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(stage)).func_177226_a((IProperty)DirUtils.FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.FACING, STAGE, DirUtils.UP, DirUtils.DOWN, DirUtils.NORTH, DirUtils.SOUTH, DirUtils.WEST, DirUtils.EAST});
    }

    @Override
    public boolean canOutputMechanicalPower() {
        return false;
    }

    @Override
    public boolean canInputMechanicalPower() {
        return false;
    }

    @Override
    public boolean isInputtingMechPower(World world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean isOutputtingMechPower(World world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean canInputPowerToSide(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        EnumFacing facing = (EnumFacing)world.func_180495_p(pos).func_177229_b((IProperty)DirUtils.FACING);
        return dir == facing;
    }

    @Override
    public void overpower(World world, BlockPos pos) {
    }

    @Override
    public boolean isMechanicalOn(IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Override
    public void setMechanicalOn(World world, BlockPos pos, boolean isOn) {
    }

    @Override
    public boolean isMechanicalOnFromState(IBlockState state) {
        return false;
    }
}

