/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.BWMod;
import betterwithmods.api.block.IMultiVariants;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.tile.TileEntityCauldron;
import betterwithmods.common.blocks.tile.TileEntityCrucible;
import betterwithmods.common.blocks.tile.TileEntityDragonVessel;
import betterwithmods.util.DirUtils;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;

public class BlockCookingPot
extends BWMBlock
implements IMultiVariants {
    public static final PropertyEnum<EnumType> TYPE = PropertyEnum.func_177709_a((String)"type", EnumType.class);

    public static ItemStack getStack(EnumType type) {
        return new ItemStack(BWMBlocks.COOKING_POTS, 1, type.getMeta());
    }

    public BlockCookingPot() {
        super(Material.field_151576_e);
        this.func_149711_c(3.5f);
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < EnumType.META_LOOKUP.length; ++i) {
            list.add((Object)new ItemStack(itemIn, 1, i));
        }
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        switch ((EnumType)((Object)state.func_177229_b(TYPE))) {
            default: {
                return SoundType.field_185851_d;
            }
            case CRUCIBLE: 
        }
        return SoundType.field_185853_f;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, DirUtils.TILTING});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return super.func_176221_a(state, worldIn, pos);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumType.byMeta(meta)));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            player.openGui((Object)BWMod.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        switch ((EnumType)((Object)state.func_177229_b(TYPE))) {
            case CRUCIBLE: {
                return new TileEntityCrucible();
            }
            case CAULDRON: {
                return new TileEntityCauldron();
            }
            case DRAGONVESSEL: {
                return new TileEntityDragonVessel();
            }
        }
        return super.createTileEntity(world, state);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Override
    public String[] getVariants() {
        return new String[]{"facing=up,type=crucible", "facing=up,type=cauldron", "facing=up,type=dragonvessel"};
    }

    public static enum EnumType implements IStringSerializable
    {
        CRUCIBLE(0, "crucible"),
        CAULDRON(1, "cauldron"),
        DRAGONVESSEL(2, "dragonvessel");

        private static final EnumType[] META_LOOKUP;
        private int meta;
        private String name;

        private EnumType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public static EnumType byMeta(int meta) {
            return META_LOOKUP[meta % META_LOOKUP.length];
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        static {
            META_LOOKUP = EnumType.values();
        }
    }
}

