/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.block.IMechanicalBlock;
import betterwithmods.api.block.IMultiVariants;
import betterwithmods.common.BWMItems;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.module.ModuleLoader;
import betterwithmods.module.gameplay.Gameplay;
import betterwithmods.module.hardcore.hchunger.HCHunger;
import betterwithmods.util.InvUtils;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockCrank
extends BWMBlock
implements IMechanicalBlock,
IMultiVariants {
    public static final PropertyInteger STAGE = PropertyInteger.func_177719_a((String)"stage", (int)0, (int)7);
    public static final float BASE_HEIGHT = 0.25f;
    private static final int TICK_RATE = 3;
    private static final AxisAlignedBB CRANK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0);

    public BlockCrank() {
        super(Material.field_151576_e);
        this.func_149711_c(0.5f);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149675_a(true);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
        this.setHarvestLevel("pickaxe", 0);
    }

    public int func_149738_a(World worldIn) {
        return 3;
    }

    @Override
    public String[] getVariants() {
        return new String[]{"stage=0"};
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return CRANK_AABB;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        int meta = (Integer)state.func_177229_b((IProperty)STAGE);
        if (meta == 0) {
            if (Gameplay.crankExhaustion > 0.0) {
                int minHunger;
                int n = minHunger = ModuleLoader.isFeatureEnabled(HCHunger.class) ? 20 : 6;
                if (player.func_71024_bL().func_75116_a() > minHunger) {
                    player.func_71020_j((float)Gameplay.crankExhaustion);
                    if (!world.field_72995_K) {
                        this.toggleSwitch(world, pos, state);
                    }
                } else if (world.field_72995_K) {
                    if (hand == EnumHand.MAIN_HAND) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("bwm.message.exhaustion", new Object[0]), true);
                    }
                    return false;
                }
            } else {
                this.toggleSwitch(world, pos, state);
            }
            return true;
        }
        return false;
    }

    private void toggleSwitch(World world, BlockPos pos, IBlockState state) {
        if (!world.field_72995_K) {
            if (!this.checkForOverpower(world, pos)) {
                world.func_175656_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(1)));
                world.func_175704_b(pos, pos);
                world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 1.0f, 2.0f);
                world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
            } else {
                this.breakCrank(world, pos);
            }
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean checkForOverpower(World world, BlockPos pos) {
        int potentialDevices = 0;
        for (int i = 0; i < 6; ++i) {
            IMechanicalBlock mech;
            Block block;
            BlockPos offset = pos.func_177972_a(EnumFacing.func_82600_a((int)i));
            if (i == 0 || (block = world.func_180495_p(offset).func_177230_c()) == null || !(block instanceof IMechanicalBlock) || !(mech = (IMechanicalBlock)block).canInputMechanicalPower()) continue;
            ++potentialDevices;
        }
        return potentialDevices > 1;
    }

    public void breakCrank(World world, BlockPos pos) {
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack(Items.field_151055_y));
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack(Blocks.field_150347_e, 2, 0));
        InvUtils.ejectStackWithOffset(world, pos, new ItemStack(BWMItems.MATERIAL, 1, 0));
        world.func_175698_g(pos);
    }

    @Override
    public boolean canOutputMechanicalPower() {
        return true;
    }

    @Override
    public boolean canInputMechanicalPower() {
        return false;
    }

    @Override
    public boolean isInputtingMechPower(World world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean isOutputtingMechPower(World world, BlockPos pos) {
        return (Integer)world.func_180495_p(pos).func_177229_b((IProperty)STAGE) > 1;
    }

    @Override
    public boolean canInputPowerToSide(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        return false;
    }

    @Override
    public void overpower(World world, BlockPos pos) {
    }

    @Override
    public boolean isMechanicalOn(IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Override
    public void setMechanicalOn(World world, BlockPos pos, boolean isOn) {
    }

    @Override
    public boolean isMechanicalOnFromState(IBlockState state) {
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        int stage = (Integer)state.func_177229_b((IProperty)STAGE);
        if (stage > 0) {
            if (stage < 7) {
                if (stage <= 6) {
                    world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 1.0f, 2.0f);
                }
                if (stage <= 5) {
                    world.func_180497_b(pos, (Block)this, this.func_149738_a(world) + stage, 5);
                } else {
                    world.func_180497_b(pos, (Block)this, 17, 5);
                }
                world.func_175656_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(stage + 1)));
            } else {
                world.func_175656_a(pos, state.func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(0)));
                world.func_175704_b(pos, pos);
                world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
                world.func_184133_a(null, pos, SoundEvents.field_187885_gS, SoundCategory.BLOCKS, 0.3f, 0.7f);
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        BlockPos down = pos.func_177977_b();
        if (!world.isSideSolid(down, EnumFacing.UP)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STAGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STAGE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STAGE});
    }
}

