/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.block.IAxle;
import betterwithmods.api.block.IMechanical;
import betterwithmods.api.block.IMechanicalBlock;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWSounds;
import betterwithmods.common.blocks.BlockRotate;
import betterwithmods.util.DirUtils;
import betterwithmods.util.MechanicalUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockGearbox
extends BlockRotate
implements IMechanicalBlock,
IMechanical {
    public static final PropertyBool ISACTIVE = PropertyBool.func_177716_a((String)"ison");

    public BlockGearbox() {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149675_a(true);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)DirUtils.FACING, (Comparable)EnumFacing.UP).func_177226_a((IProperty)ISACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void func_190948_a(ItemStack stack, EntityPlayer player, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"tooltip.gearbox.name", (Object[])new Object[0]));
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    public int func_149738_a(World world) {
        return 10;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, side, flX, flY, flZ, meta, placer, hand);
        return this.setFacingInBlock(state, side.func_176734_d());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        EnumFacing facing = DirUtils.convertEntityOrientationToFacing(entity, EnumFacing.NORTH);
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)DirUtils.FACING, (Comparable)facing));
    }

    @Override
    public void nextState(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177231_a((IProperty)DirUtils.FACING).func_177226_a((IProperty)ISACTIVE, (Comparable)Boolean.valueOf(false)));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_180497_b(pos, (Block)this, 10, 5);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        boolean isRedstonePowered;
        boolean gettingPower = this.isInputtingMechPower(world, pos);
        boolean isOn = this.isGearboxOn((IBlockAccess)world, pos);
        boolean bl = isRedstonePowered = world.func_175687_A(pos) > 0;
        if (isRedstonePowered) {
            gettingPower = false;
        }
        if (isOn != gettingPower) {
            if (isOn) {
                this.setGearboxState(world, pos, false);
            } else {
                this.setGearboxState(world, pos, true);
                world.func_184133_a(null, pos, BWSounds.WOODCREAK, SoundCategory.BLOCKS, 0.5f, world.field_73012_v.nextFloat() * 0.25f + 0.25f);
            }
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        boolean isOn = this.isGearboxOn((IBlockAccess)world, pos);
        if (isOn) {
            boolean isRedstonePowered;
            boolean gettingPower = this.isInputtingMechPower(world, pos);
            boolean bl = isRedstonePowered = world.func_175687_A(pos) > 0;
            if (isRedstonePowered) {
                gettingPower = false;
            }
            if (!gettingPower) {
                world.func_180497_b(pos, (Block)this, 9, 5);
                return;
            }
        }
        world.func_180497_b(pos, (Block)this, 10, 5);
    }

    public int getMechPowerProvidedToAxle(World world, BlockPos pos, EnumFacing facing) {
        if (this.isGearboxOn((IBlockAccess)world, pos) && this.getFacing((IBlockAccess)world, pos) != facing) {
            return 4;
        }
        return 0;
    }

    public EnumFacing getFacing(IBlockAccess world, BlockPos pos) {
        return this.getFacingFromState(world.func_180495_p(pos));
    }

    public EnumFacing getFacingFromState(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING);
    }

    @Override
    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.func_177226_a((IProperty)DirUtils.FACING, (Comparable)facing);
    }

    @Override
    public boolean canRotateOnTurntable(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean canRotateHorizontally(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean canRotateVertically(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public void rotateAroundYAxis(World world, BlockPos pos, boolean reverse) {
        EnumFacing facing = this.getFacing((IBlockAccess)world, pos);
        EnumFacing newFacing = DirUtils.rotateFacingAroundY(facing, reverse);
        if (newFacing != facing) {
            if (this.isGearboxOn((IBlockAccess)world, pos)) {
                this.setGearboxState(world, pos, false);
            }
            world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)DirUtils.FACING, (Comparable)newFacing));
            world.func_175704_b(pos, pos);
            world.func_180497_b(pos, (Block)this, 10, 5);
            MechanicalUtil.destoryHorizontalAxles(world, pos);
        }
    }

    @Override
    public boolean canOutputMechanicalPower() {
        return true;
    }

    @Override
    public boolean canInputMechanicalPower() {
        return true;
    }

    @Override
    public boolean isInputtingMechPower(World world, BlockPos pos) {
        EnumFacing dir = this.getFacing((IBlockAccess)world, pos);
        return MechanicalUtil.isBlockPoweredByAxleOnSide(world, pos, dir);
    }

    @Override
    public boolean isOutputtingMechPower(World world, BlockPos pos) {
        return this.isGearboxOn((IBlockAccess)world, pos);
    }

    @Override
    public boolean canInputPowerToSide(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        EnumFacing facing = this.getFacing(world, pos);
        return dir == facing;
    }

    @Override
    public void overpower(World world, BlockPos pos) {
        if (this.isGearboxOn((IBlockAccess)world, pos)) {
            this.breakGearbox(world, pos, world.func_180495_p(pos));
        }
    }

    public boolean isGearboxOn(IBlockAccess world, BlockPos pos) {
        return this.isGearboxOnFromState(world.func_180495_p(pos));
    }

    public void setGearboxState(World world, BlockPos pos, boolean on) {
        boolean isActive = (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)ISACTIVE);
        if (on != isActive) {
            world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)ISACTIVE, (Comparable)Boolean.valueOf(on)));
        }
    }

    public boolean isGearboxOnFromState(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ISACTIVE);
    }

    private void emitGearboxParticles(World world, BlockPos pos, Random rand) {
        for (int i = 0; i < 5; ++i) {
            float flX = (float)pos.func_177958_n() + rand.nextFloat();
            float flY = (float)pos.func_177956_o() + rand.nextFloat() * 0.5f + 1.0f;
            float flZ = (float)pos.func_177952_p() + rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)flX, (double)flY, (double)flZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void breakGearbox(World world, BlockPos pos, IBlockState state) {
        int i;
        for (i = 0; i < 10; ++i) {
            world.func_184133_a(null, pos, SoundEvents.field_187927_ha, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.45f);
        }
        for (i = 0; i < 5; ++i) {
            float flX = (float)pos.func_177958_n() + world.field_73012_v.nextFloat();
            float flY = (float)pos.func_177956_o() + world.field_73012_v.nextFloat() * 0.5f + 1.0f;
            float flZ = (float)pos.func_177952_p() + world.field_73012_v.nextFloat();
            world.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)flX, (double)flY, (double)flZ, 0.0, 0.0, 0.0, new int[0]);
        }
        world.func_175656_a(pos, BWMBlocks.BROKEN_GEARBOX.func_176223_P().func_177226_a((IProperty)DirUtils.FACING, state.func_177229_b((IProperty)DirUtils.FACING)));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (((Boolean)state.func_177229_b((IProperty)ISACTIVE)).booleanValue()) {
            this.emitGearboxParticles(world, pos, rand);
            if (rand.nextInt(50) == 0) {
                world.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, BWSounds.WOODCREAK, SoundCategory.BLOCKS, 0.25f, world.field_73012_v.nextFloat() * 0.25f + 0.25f, false);
            }
        }
    }

    @Override
    public boolean isMechanicalOn(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return this.isMechanicalOnFromState(state);
    }

    @Override
    public void setMechanicalOn(World world, BlockPos pos, boolean isOn) {
        world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)ISACTIVE, (Comparable)Boolean.valueOf(isOn)));
    }

    @Override
    public boolean isMechanicalOnFromState(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ISACTIVE);
    }

    @Override
    public int getMechPowerLevelToFacing(World world, BlockPos pos, EnumFacing dir) {
        return this.getMechPowerProvidedToAxle(world, pos, dir);
    }

    @Override
    public boolean isMechanicalJunction() {
        return true;
    }

    private boolean isAxle(IBlockAccess world, BlockPos origin, EnumFacing facing) {
        BlockPos pos = origin.func_177972_a(facing);
        Block block = world.func_180495_p(pos).func_177230_c();
        return block instanceof IAxle && ((IAxle)block).isAxleOrientedToFacing(world, pos, facing.func_176734_d());
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        boolean[] dirs = new boolean[6];
        for (int i = 0; i < 6; ++i) {
            EnumFacing facing = EnumFacing.func_82600_a((int)i);
            dirs[i] = this.isAxle(world, pos, facing) && this.getFacing(world, pos) != facing;
        }
        return state.func_177226_a((IProperty)DirUtils.DOWN, (Comparable)Boolean.valueOf(dirs[0])).func_177226_a((IProperty)DirUtils.UP, (Comparable)Boolean.valueOf(dirs[1])).func_177226_a((IProperty)DirUtils.NORTH, (Comparable)Boolean.valueOf(dirs[2])).func_177226_a((IProperty)DirUtils.SOUTH, (Comparable)Boolean.valueOf(dirs[3])).func_177226_a((IProperty)DirUtils.WEST, (Comparable)Boolean.valueOf(dirs[4])).func_177226_a((IProperty)DirUtils.EAST, (Comparable)Boolean.valueOf(dirs[5]));
    }

    public int func_176201_c(IBlockState state) {
        int meta = this.isMechanicalOnFromState(state) ? 8 : 0;
        return meta += ((EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING)).func_176745_a();
    }

    public IBlockState func_176203_a(int meta) {
        boolean isActive = false;
        if (meta > 7) {
            isActive = true;
            meta -= 8;
        }
        return this.func_176223_P().func_177226_a((IProperty)ISACTIVE, (Comparable)Boolean.valueOf(isActive)).func_177226_a((IProperty)DirUtils.FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.FACING, ISACTIVE, DirUtils.UP, DirUtils.DOWN, DirUtils.NORTH, DirUtils.SOUTH, DirUtils.WEST, DirUtils.EAST});
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return this.isGearboxOn((IBlockAccess)worldIn, pos) ? 15 : 0;
    }
}

