/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockDetector;
import betterwithmods.common.blocks.BlockInvisibleLight;
import betterwithmods.common.blocks.BlockRotate;
import betterwithmods.util.DirUtils;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLens
extends BlockRotate {
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");
    public static final int RANGE = 256;

    public BlockLens() {
        super(Material.field_151573_f);
        this.func_149711_c(3.5f);
        this.func_149675_a(true);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)DirUtils.FACING, (Comparable)EnumFacing.NORTH));
        this.setHarvestLevel("pickaxe", 0);
    }

    public int func_149738_a(World world) {
        return 5;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_180497_b(pos, (Block)this, 3, 5);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase entity, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, side, flX, flY, flZ, meta, entity, hand);
        EnumFacing face = DirUtils.convertEntityOrientationToFacing(entity, side);
        return this.setFacingInBlock(state, face);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.cleanupLightToFacing(world, pos, (EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING));
        super.func_180663_b(world, pos, state);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        EnumFacing facing = DirUtils.convertEntityOrientationToFacing(entity, EnumFacing.NORTH);
        this.setFacingInBlock(state, facing);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        world.func_180497_b(pos, (Block)this, 3, 5);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        this.cleanupLight(world, pos);
        EnumFacing dir = this.getFacing((IBlockAccess)world, pos);
        boolean isLightDetector = this.isFacingBlockDetector(world, pos);
        if (!isLightDetector) {
            boolean sunlight = this.isLightFromSun(world, pos);
            boolean lightOn = this.isInputLit(world, pos);
            if (this.isLit((IBlockAccess)world, pos) != lightOn) {
                this.setLit(world, pos, lightOn);
            }
            EnumFacing expectedFacing = DirUtils.getOpposite(this.getFacing((IBlockAccess)world, pos));
            BlockPos offset = pos.func_177972_a(dir);
            if (this.isLit((IBlockAccess)world, pos) && (world.func_175623_d(offset) || world.func_180495_p(offset).func_177230_c() == BWMBlocks.LIGHT_SOURCE)) {
                for (int i = 1; i < 256; ++i) {
                    BlockPos bPos = pos.func_177967_a(dir, i);
                    IBlockState lightState = BWMBlocks.LIGHT_SOURCE.func_176223_P();
                    if (world.func_175623_d(bPos)) {
                        List entity = world.func_72872_a(Entity.class, field_185505_j.func_186670_a(bPos));
                        if (entity.size() > 0) {
                            world.func_175656_a(bPos, lightState.func_177226_a((IProperty)DirUtils.FACING, (Comparable)expectedFacing).func_177226_a((IProperty)BlockInvisibleLight.SUNLIGHT, (Comparable)Boolean.valueOf(sunlight)));
                        } else {
                            if (world.func_180495_p(bPos).func_177230_c() == BWMBlocks.LIGHT_SOURCE && ((EnumFacing)world.func_180495_p(bPos).func_177229_b((IProperty)DirUtils.FACING)).ordinal() < expectedFacing.ordinal()) {
                                if (((Boolean)world.func_180495_p(bPos).func_177229_b((IProperty)BlockInvisibleLight.SUNLIGHT)).booleanValue()) {
                                    lightState = lightState.func_177226_a((IProperty)BlockInvisibleLight.SUNLIGHT, (Comparable)Boolean.valueOf(true));
                                }
                                world.func_175656_a(bPos, lightState.func_177226_a((IProperty)DirUtils.FACING, (Comparable)expectedFacing));
                                continue;
                            }
                            if (world.func_175623_d(bPos)) continue;
                            if (world.func_180495_p(bPos = bPos.func_177972_a(dir.func_176734_d())).func_177230_c() != BWMBlocks.LIGHT_SOURCE || world.func_180495_p(bPos).func_177230_c() == BWMBlocks.LIGHT_SOURCE && ((EnumFacing)world.func_180495_p(bPos).func_177229_b((IProperty)DirUtils.FACING)).ordinal() < expectedFacing.ordinal()) {
                                world.func_175656_a(bPos, lightState.func_177226_a((IProperty)DirUtils.FACING, (Comparable)expectedFacing).func_177226_a((IProperty)BlockInvisibleLight.SUNLIGHT, (Comparable)Boolean.valueOf(sunlight)));
                            }
                        }
                    } else {
                        if (world.func_175623_d(bPos)) continue;
                        BlockPos dPos = bPos.func_177972_a(dir.func_176734_d());
                        if (world.func_180495_p(dPos).func_177230_c() != BWMBlocks.LIGHT_SOURCE || world.func_180495_p(dPos).func_177230_c() == BWMBlocks.LIGHT_SOURCE && ((EnumFacing)world.func_180495_p(dPos).func_177229_b((IProperty)DirUtils.FACING)).ordinal() <= expectedFacing.ordinal()) {
                            if (world.func_180495_p(dPos).func_177230_c() == BWMBlocks.LIGHT_SOURCE && ((Boolean)world.func_180495_p(dPos).func_177229_b((IProperty)BlockInvisibleLight.SUNLIGHT)).booleanValue()) {
                                lightState = lightState.func_177226_a((IProperty)BlockInvisibleLight.SUNLIGHT, (Comparable)Boolean.valueOf(sunlight));
                            }
                            world.func_175656_a(dPos, lightState.func_177226_a((IProperty)DirUtils.FACING, (Comparable)expectedFacing));
                        }
                    }
                    break;
                }
            } else if (!this.isLit((IBlockAccess)world, pos)) {
                for (int i = 1; i < 256; ++i) {
                    BlockPos bPos = pos.func_177967_a(dir, i);
                    if (world.func_180495_p(bPos).func_177230_c() == BWMBlocks.LIGHT_SOURCE) {
                        world.func_175698_g(bPos);
                        continue;
                    }
                    if (world.func_175623_d(bPos)) {
                        continue;
                    }
                    break;
                }
            }
        } else {
            boolean shouldBeOn;
            int lightValue = world.func_175699_k(pos.func_177972_a(dir.func_176734_d()));
            boolean bl = shouldBeOn = lightValue > 7;
            if (this.isLit((IBlockAccess)world, pos) != shouldBeOn) {
                this.setLit(world, pos, shouldBeOn);
            }
        }
        world.func_180497_b(pos, (Block)this, 5, 5);
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.BLOCK;
    }

    public EnumFacing getFacing(IBlockAccess world, BlockPos pos) {
        return this.getFacingFromBlockState(world.func_180495_p(pos));
    }

    @Override
    public EnumFacing getFacingFromBlockState(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING);
    }

    @Override
    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.func_177226_a((IProperty)DirUtils.FACING, (Comparable)facing);
    }

    public boolean isLit(IBlockAccess world, BlockPos pos) {
        return (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)LIT);
    }

    public void setLit(World world, BlockPos pos, boolean isOn) {
        boolean oldLit = (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)LIT);
        if (isOn != oldLit) {
            world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(isOn)));
            world.func_190524_a(pos, (Block)this, pos);
        }
    }

    private boolean isInputLit(World world, BlockPos pos) {
        EnumFacing facing = this.getFacing((IBlockAccess)world, pos);
        EnumFacing dir = DirUtils.getOpposite(facing);
        BlockPos oppOff = pos.func_177972_a(dir);
        Block block = world.func_180495_p(oppOff).func_177230_c();
        if (world.func_175623_d(oppOff) && world.func_175710_j(oppOff)) {
            return world.func_175642_b(EnumSkyBlock.SKY, oppOff) > 12 && world.func_72935_r() && (!world.func_72896_J() || !world.func_72911_I());
        }
        return block.getLightValue(world.func_180495_p(oppOff), (IBlockAccess)world, oppOff) > 12;
    }

    private boolean isFacingBlockDetector(World world, BlockPos pos) {
        EnumFacing detFacing;
        EnumFacing facing = this.getFacing((IBlockAccess)world, pos);
        BlockPos offset = pos.func_177972_a(facing);
        Block block = world.func_180495_p(offset).func_177230_c();
        return block == BWMBlocks.DETECTOR && (detFacing = ((BlockDetector)block).getFacingFromBlockState(world.func_180495_p(offset))) == DirUtils.getOpposite(facing);
    }

    private boolean isLightFromSun(World world, BlockPos pos) {
        EnumFacing facing = DirUtils.getOpposite(this.getFacing((IBlockAccess)world, pos));
        BlockPos offset = pos.func_177972_a(facing);
        if (world.func_175623_d(offset) && world.func_175710_j(offset)) {
            return true;
        }
        return world.func_180495_p(offset).func_177230_c() == BWMBlocks.LIGHT_SOURCE && (Boolean)world.func_180495_p(offset).func_177229_b((IProperty)BlockInvisibleLight.SUNLIGHT) != false;
    }

    private void cleanupLightToFacing(World world, BlockPos pos, EnumFacing facing) {
        EnumFacing opp = DirUtils.getOpposite(facing);
        for (int i = 1; i < 256; ++i) {
            BlockPos offset = pos.func_177967_a(facing, i);
            if (world.func_180495_p(offset).func_177230_c() == BWMBlocks.LIGHT_SOURCE) {
                EnumFacing lightFace = ((BlockInvisibleLight)world.func_180495_p(offset).func_177230_c()).getFacing((IBlockAccess)world, offset);
                if (lightFace != opp) continue;
                world.func_175698_g(offset);
                break;
            }
            if (!world.func_175623_d(offset)) break;
        }
    }

    private void cleanupLight(World world, BlockPos pos) {
        EnumFacing facing = this.getFacing((IBlockAccess)world, pos);
        EnumFacing oppFacing = DirUtils.getOpposite(facing);
        for (int i = 1; i < 256; ++i) {
            BlockLens lens;
            BlockPos offset = pos.func_177967_a(facing, i);
            if (world.func_180495_p(offset).func_177230_c() == BWMBlocks.LIGHT_SOURCE) {
                EnumFacing lightFace = ((BlockInvisibleLight)world.func_180495_p(offset).func_177230_c()).getFacing((IBlockAccess)world, offset);
                if (lightFace != oppFacing) continue;
                world.func_175698_g(offset);
                continue;
            }
            if (!world.func_175623_d(offset) && world.func_180495_p(offset).func_177230_c() == this && (lens = (BlockLens)world.func_180495_p(pos).func_177230_c()).getFacing((IBlockAccess)world, offset) == facing) break;
        }
    }

    public IBlockState func_176203_a(int meta) {
        boolean lit = false;
        if (meta > 7) {
            lit = true;
            meta -= 8;
        }
        return this.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(lit)).func_177226_a((IProperty)DirUtils.FACING, (Comparable)EnumFacing.func_82600_a((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        int meta = (Boolean)state.func_177229_b((IProperty)LIT) != false ? 8 : 0;
        return meta + ((EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.FACING, LIT});
    }

    @Override
    public void nextState(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false)).func_177231_a((IProperty)DirUtils.FACING));
    }
}

