/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.BWMod;
import betterwithmods.api.block.IMechanicalBlock;
import betterwithmods.api.block.IMultiVariants;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.tile.TileEntityFilteredHopper;
import betterwithmods.common.blocks.tile.TileEntityMill;
import betterwithmods.common.blocks.tile.TileEntityPulley;
import betterwithmods.common.blocks.tile.TileEntityTurntable;
import betterwithmods.module.gameplay.MechanicalBreakage;
import betterwithmods.util.InvUtils;
import betterwithmods.util.MechanicalUtil;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockMechMachines
extends BWMBlock
implements IMechanicalBlock,
IMultiVariants {
    public static final PropertyBool ISACTIVE = PropertyBool.func_177716_a((String)"ison");
    public static final PropertyEnum<EnumType> MACHINETYPE = PropertyEnum.func_177709_a((String)"machinetype", EnumType.class);

    public static ItemStack getStack(EnumType type) {
        return new ItemStack(BWMBlocks.SINGLE_MACHINES, 1, type.getMeta() << 1);
    }

    public BlockMechMachines() {
        super(Material.field_151576_e);
        this.func_149675_a(true);
        this.func_149711_c(3.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(MACHINETYPE, (Comparable)((Object)EnumType.MILL)).func_177226_a((IProperty)ISACTIVE, (Comparable)Boolean.valueOf(false)));
        this.field_149783_u = true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumType)((Object)state.func_177229_b(MACHINETYPE))) {
            case HOPPER: {
                return new AxisAlignedBB(0.0, 0.25, 0.0, 1.0, 1.0, 1.0);
            }
        }
        return super.func_185496_a(state, source, pos);
    }

    @Override
    public String[] getVariants() {
        return new String[]{"ison=true,machinetype=mill", "ison=false,machinetype=mill", "ison=true,machinetype=pulley", "ison=false,machinetype=pulley", "ison=true,machinetype=hopper", "ison=false,machinetype=hopper", "ison=true,machinetype=turntable", "ison=false,machinetype=turntable"};
    }

    public Material func_149688_o(IBlockState state) {
        switch ((EnumType)((Object)state.func_177229_b(MACHINETYPE))) {
            case HOPPER: 
            case PULLEY: {
                this.setHarvestLevel("axe", 0, state);
                return Material.field_151575_d;
            }
        }
        this.setHarvestLevel("pickaxe", 0, state);
        return super.func_149688_o(state);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        switch ((EnumType)((Object)state.func_177229_b(MACHINETYPE))) {
            case HOPPER: 
            case PULLEY: {
                return SoundType.field_185848_a;
            }
        }
        return super.getSoundType(state, world, pos, entity);
    }

    public boolean isSideSolid(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        EnumType type = (EnumType)((Object)world.func_180495_p(pos).func_177229_b(MACHINETYPE));
        return type == EnumType.MILL || type == EnumType.PULLEY || type == EnumType.TURNTABLE;
    }

    public int tickRateForMeta(EnumType type) {
        if (type == EnumType.MILL) {
            return 1;
        }
        return 10;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        EnumType type = (EnumType)((Object)world.func_180495_p(pos).func_177229_b(MACHINETYPE));
        world.func_180497_b(pos, (Block)this, this.tickRateForMeta(type), 5);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public int func_180651_a(IBlockState state) {
        EnumType type = (EnumType)((Object)state.func_177229_b(MACHINETYPE));
        return type.getMeta() << 1;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    public boolean func_149662_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(MACHINETYPE))).getSolidity();
    }

    public boolean func_149686_d(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(MACHINETYPE))).getSolidity();
    }

    public boolean func_149730_j(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(MACHINETYPE))).getSolidity();
    }

    public boolean func_176214_u(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(MACHINETYPE))).getSolidity();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        if (world.func_175625_s(pos) != null && world.func_175625_s(pos).hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            player.openGui((Object)BWMod.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        } else if (world.func_175625_s(pos) != null && world.func_175625_s(pos) instanceof TileEntityTurntable && hand == EnumHand.MAIN_HAND) {
            return ((TileEntityTurntable)world.func_175625_s(pos)).processRightClick(player);
        }
        return true;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return InvUtils.calculateComparatorLevel((IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null));
        }
        return 0;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        boolean gettingPower = this.isInputtingMechPower(world, pos);
        boolean isOn = this.isMechanicalOn((IBlockAccess)world, pos);
        if (world.func_175625_s(pos) instanceof TileEntityTurntable && !world.func_82736_K().func_82766_b("doDaylightCycle")) {
            ((TileEntityTurntable)world.func_175625_s(pos)).toggleAsynchronous(null);
        }
        if (isOn != gettingPower) {
            this.setMechanicalOn(world, pos, gettingPower);
        }
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        EnumType type = (EnumType)((Object)world.func_180495_p(pos).func_177229_b(MACHINETYPE));
        if (!this.isCurrentStateValid(world, pos)) {
            world.func_180497_b(pos, (Block)this, this.tickRateForMeta(type), 5);
        }
    }

    public boolean isCurrentStateValid(World world, BlockPos pos) {
        boolean gettingPower = this.isInputtingMechPower(world, pos);
        boolean isOn = this.isMechanicalOn((IBlockAccess)world, pos);
        return isOn == gettingPower;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch ((EnumType)((Object)state.func_177229_b(MACHINETYPE))) {
            case MILL: {
                return new TileEntityMill();
            }
            case PULLEY: {
                return new TileEntityPulley();
            }
            case HOPPER: {
                return new TileEntityFilteredHopper();
            }
            case TURNTABLE: {
                return new TileEntityTurntable();
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (EnumType type : EnumType.META_LOOKUP) {
            list.add((Object)new ItemStack(item, 1, type.getMeta() << 1));
        }
    }

    @Override
    public boolean canOutputMechanicalPower() {
        return false;
    }

    @Override
    public boolean canInputMechanicalPower() {
        return true;
    }

    @Override
    public boolean isInputtingMechPower(World world, BlockPos pos) {
        EnumType type = (EnumType)((Object)world.func_180495_p(pos).func_177229_b(MACHINETYPE));
        if (type != EnumType.TURNTABLE) {
            return MechanicalUtil.isBlockPoweredByAxle(world, pos, this) || MechanicalUtil.isPoweredByCrank(world, pos);
        }
        return MechanicalUtil.isBlockPoweredByAxle(world, pos, this);
    }

    @Override
    public boolean isOutputtingMechPower(World world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean canInputPowerToSide(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        EnumType type = (EnumType)((Object)world.func_180495_p(pos).func_177229_b(MACHINETYPE));
        switch (type) {
            case MILL: {
                return dir == EnumFacing.UP || dir == EnumFacing.DOWN;
            }
            case PULLEY: {
                return dir != EnumFacing.DOWN && dir != EnumFacing.UP;
            }
            case HOPPER: {
                return dir != EnumFacing.UP && dir != EnumFacing.DOWN;
            }
            case TURNTABLE: {
                return dir == EnumFacing.DOWN;
            }
        }
        return false;
    }

    @Override
    public void overpower(World world, BlockPos pos) {
        EnumType type = (EnumType)((Object)world.func_180495_p(pos).func_177229_b(MACHINETYPE));
        if (!world.field_72995_K) {
            switch (type) {
                case MILL: {
                    this.breakMill(world, pos);
                    break;
                }
                case PULLEY: {
                    this.breakPulley(world, pos);
                    break;
                }
                case HOPPER: {
                    this.breakHopper(world, pos);
                    break;
                }
                case TURNTABLE: {
                    this.breakTurntable(world, pos);
                    break;
                }
            }
        }
    }

    private void breakMill(World world, BlockPos pos) {
        if (MechanicalBreakage.millstone) {
            InvUtils.ejectBrokenItems(world, pos, new ResourceLocation("betterwithmods", "block/mill"));
        }
        world.func_184133_a(null, pos, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.3f, world.field_73012_v.nextFloat() * 0.1f + 0.45f);
        world.func_175698_g(pos);
    }

    private void breakPulley(World world, BlockPos pos) {
        if (MechanicalBreakage.pulley) {
            InvUtils.ejectBrokenItems(world, pos, new ResourceLocation("betterwithmods", "block/pulley"));
        }
        world.func_184133_a(null, pos, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.3f, world.field_73012_v.nextFloat() * 0.1f + 0.45f);
        world.func_175698_g(pos);
    }

    public void breakHopper(World world, BlockPos pos) {
        if (MechanicalBreakage.hopper) {
            InvUtils.ejectBrokenItems(world, pos, new ResourceLocation("betterwithmods", "block/hopper"));
        }
        world.func_184133_a(null, pos, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.3f, world.field_73012_v.nextFloat() * 0.1f + 0.45f);
        world.func_175698_g(pos);
    }

    private void breakTurntable(World world, BlockPos pos) {
        if (MechanicalBreakage.turntable) {
            InvUtils.ejectBrokenItems(world, pos, new ResourceLocation("betterwithmods", "block/turntable"));
        }
        world.func_184133_a(null, pos, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.3f, world.field_73012_v.nextFloat() * 0.1f + 0.45f);
        world.func_175698_g(pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        EnumType type = (EnumType)((Object)world.func_180495_p(pos).func_177229_b(MACHINETYPE));
        boolean isOn = (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)ISACTIVE);
        if (type == EnumType.MILL && isOn) {
            this.updateMill(world, pos, rand);
        }
    }

    public void updateMill(World world, BlockPos pos, Random rand) {
        if (this.isMechanicalOn((IBlockAccess)world, pos)) {
            this.emitSmoke(world, pos, rand, 5);
        }
    }

    private void emitSmoke(World world, BlockPos pos, Random rand, int heat) {
        for (int i = 0; i < heat; ++i) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            float fX = (float)x + rand.nextFloat();
            float fY = (float)y + rand.nextFloat() * 0.5f + 1.0f;
            float fZ = (float)z + rand.nextFloat();
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)fX, (double)fY, (double)fZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public EnumFacing getFacingFromBlockState(IBlockState state) {
        return null;
    }

    @Override
    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state;
    }

    @Override
    public boolean canRotateOnTurntable(IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean canRotateHorizontally(IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean canRotateVertically(IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean isMechanicalOn(IBlockAccess world, BlockPos pos) {
        return this.isMechanicalOnFromState(world.func_180495_p(pos));
    }

    @Override
    public void setMechanicalOn(World world, BlockPos pos, boolean isOn) {
        if (isOn != (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)ISACTIVE)) {
            world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)ISACTIVE, (Comparable)Boolean.valueOf(isOn)));
        }
    }

    @Override
    public boolean isMechanicalOnFromState(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ISACTIVE);
    }

    public boolean isRedstonePowered(World world, BlockPos pos) {
        return world.func_175687_A(pos) > 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{ISACTIVE, MACHINETYPE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(MACHINETYPE, (Comparable)((Object)EnumType.byMeta(meta >> 1))).func_177226_a((IProperty)ISACTIVE, (Comparable)Boolean.valueOf((meta & 1) == 1));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumType)((Object)state.func_177229_b(MACHINETYPE))).getMeta() << 1 | ((Boolean)state.func_177229_b((IProperty)ISACTIVE) != false ? 1 : 0);
    }

    public static enum EnumType implements IStringSerializable
    {
        MILL(0, "mill", true),
        PULLEY(1, "pulley", true),
        HOPPER(2, "hopper"),
        TURNTABLE(3, "turntable", true);

        private static final EnumType[] META_LOOKUP;
        private int meta;
        private String name;
        private boolean solidity;

        private EnumType(int meta, String name) {
            this(meta, name, false);
        }

        private EnumType(int meta, String name, boolean solid) {
            this.meta = meta;
            this.name = name;
            this.solidity = solid;
        }

        public static EnumType byMeta(int meta) {
            return META_LOOKUP[meta % META_LOOKUP.length];
        }

        public String func_176610_l() {
            return this.name;
        }

        public int getMeta() {
            return this.meta;
        }

        public boolean getSolidity() {
            return this.solidity;
        }

        static {
            META_LOOKUP = EnumType.values();
        }
    }
}

