/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.entity.EntityMiningCharge;
import betterwithmods.util.DirUtils;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockMiningCharge
extends BWMBlock {
    public static final PropertyBool EXPLODE = PropertyBool.func_177716_a((String)"explode");
    private static final AxisAlignedBB D_AABB = new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB U_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
    private static final AxisAlignedBB N_AABB = new AxisAlignedBB(0.0, 0.0, 0.5, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB S_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 0.5);
    private static final AxisAlignedBB W_AABB = new AxisAlignedBB(0.5, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB E_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.5, 1.0, 1.0);

    public BlockMiningCharge() {
        super(Material.field_151590_u);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)EXPLODE, (Comparable)Boolean.FALSE));
        this.func_149672_a(SoundType.field_185850_c);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        EnumFacing facing = (EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING);
        switch (facing) {
            case DOWN: {
                return D_AABB;
            }
            case UP: {
                return U_AABB;
            }
            case NORTH: {
                return N_AABB;
            }
            case SOUTH: {
                return S_AABB;
            }
            case WEST: {
                return W_AABB;
            }
            case EAST: {
                return E_AABB;
            }
        }
        return field_185505_j;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EXPLODE, DirUtils.FACING});
    }

    public void explode(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase igniter) {
        if (!worldIn.field_72995_K && ((Boolean)state.func_177229_b((IProperty)EXPLODE)).booleanValue()) {
            EntityMiningCharge miningCharge = new EntityMiningCharge(worldIn, (float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f, igniter, this.getFacingFromBlockState(state));
            worldIn.func_72838_d((Entity)miningCharge);
            worldIn.func_184148_a(null, miningCharge.field_70165_t, miningCharge.field_70163_u, miningCharge.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    @Override
    public EnumFacing getFacingFromBlockState(IBlockState state) {
        return (EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING);
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)DirUtils.FACING, (Comparable)facing);
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        super.func_176213_c(worldIn, pos, state);
        if (worldIn.func_175640_z(pos)) {
            this.func_176206_d(worldIn, pos, state.func_177226_a((IProperty)EXPLODE, (Comparable)Boolean.TRUE));
            worldIn.func_175698_g(pos);
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos other) {
        if (worldIn.func_175640_z(pos)) {
            this.func_176206_d(worldIn, pos, state.func_177226_a((IProperty)EXPLODE, (Comparable)Boolean.TRUE));
            worldIn.func_175698_g(pos);
        }
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        this.func_180652_a(world, pos, explosion);
        world.func_175698_g(pos);
    }

    public void func_180652_a(World worldIn, BlockPos pos, Explosion explosionIn) {
        if (!worldIn.field_72995_K) {
            EntityMiningCharge miningCharge = new EntityMiningCharge(worldIn, (float)pos.func_177958_n() + 0.5f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.5f, explosionIn.func_94613_c(), this.getFacingFromBlockState(worldIn.func_180495_p(pos)));
            miningCharge.setFuse((short)(worldIn.field_73012_v.nextInt(miningCharge.getFuse() / 4) + miningCharge.getFuse() / 8));
            worldIn.func_72838_d((Entity)miningCharge);
        }
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        this.explode(worldIn, pos, state, null);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (!(heldItem.func_190926_b() || heldItem.func_77973_b() != Items.field_151033_d && heldItem.func_77973_b() != Items.field_151059_bz)) {
            this.explode(worldIn, pos, state.func_177226_a((IProperty)EXPLODE, (Comparable)Boolean.TRUE), (EntityLivingBase)playerIn);
            worldIn.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 11);
            if (heldItem.func_77973_b() == Items.field_151033_d) {
                heldItem.func_77972_a(1, (EntityLivingBase)playerIn);
            } else if (!playerIn.field_71075_bZ.field_75098_d) {
                heldItem.func_190918_g(1);
            }
            return true;
        }
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        EntityArrow entityarrow;
        if (!worldIn.field_72995_K && entityIn instanceof EntityArrow && (entityarrow = (EntityArrow)entityIn).func_70027_ad()) {
            this.explode(worldIn, pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)EXPLODE, (Comparable)Boolean.TRUE), entityarrow.field_70250_c instanceof EntityLivingBase ? (EntityLivingBase)entityarrow.field_70250_c : null);
            worldIn.func_175698_g(pos);
        }
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public IBlockState func_176203_a(int meta) {
        boolean explode = (meta & 1) > 0;
        EnumFacing facing = EnumFacing.func_82600_a((int)(meta >> 1));
        return this.func_176223_P().func_177226_a((IProperty)EXPLODE, (Comparable)Boolean.valueOf(explode)).func_177226_a((IProperty)DirUtils.FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        int facing = ((EnumFacing)state.func_177229_b((IProperty)DirUtils.FACING)).func_176745_a() << 1;
        int explode = (Boolean)state.func_177229_b((IProperty)EXPLODE) != false ? 1 : 0;
        return explode | facing;
    }
}

