/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.module.hardcore.HCBonemeal;
import betterwithmods.util.InvUtils;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ColorizerGrass;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeColorHelper;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockPlanter
extends BWMBlock
implements IMultiVariants {
    public static final PropertyEnum<EnumPlanterType> TYPE = PropertyEnum.func_177709_a((String)"plantertype", EnumPlanterType.class);

    public BlockPlanter() {
        super(Material.field_151576_e);
        this.func_149675_a(true);
        this.func_149711_c(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)EnumPlanterType.EMPTY)));
        this.setHarvestLevel("pickaxe", 0);
    }

    @Override
    public String[] getVariants() {
        return new String[]{"plantertype=empty", "plantertype=dirt", "plantertype=grass", "plantertype=soul_sand", "plantertype=fertile", "plantertype=sand", "plantertype=water_still", "plantertype=gravel", "plantertype=red_sand"};
    }

    public int colorMultiplier(IBlockState state, IBlockAccess world, BlockPos pos, int tintIndex) {
        return state.func_177229_b(TYPE) == EnumPlanterType.GRASS && tintIndex > -1 ? (world != null && pos != null ? BiomeColorHelper.func_180286_a((IBlockAccess)world, (BlockPos)pos) : ColorizerGrass.func_77480_a((double)0.5, (double)1.0)) : -1;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumPlanterType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    private boolean isValidBlockStack(ItemStack stack) {
        if (stack.func_77973_b() instanceof ItemBlock) {
            Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
            return block == Blocks.field_150346_d || block == Blocks.field_150349_c || block == Blocks.field_150354_m || block == Blocks.field_150351_n || block == Blocks.field_150425_aM;
        }
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        IBlockState planter = world.func_180495_p(pos);
        ItemStack heldItem = player.func_184586_b(hand);
        int meta = ((EnumPlanterType)((Object)world.func_180495_p(pos).func_177229_b(TYPE))).getMeta();
        if (world.field_72995_K) {
            ItemStack item;
            ItemStack itemStack = item = hand == EnumHand.MAIN_HAND ? player.func_184614_ca() : player.func_184592_cb();
            if (!item.func_190926_b()) {
                if (meta == 0 && (this.isValidBlockStack(item) || item.func_77973_b() == Items.field_151131_as)) {
                    return true;
                }
                if (meta == 1) {
                    if (HCBonemeal.FERTILIZERS.stream().anyMatch(arg_0 -> ((ItemStack)item).func_77969_a(arg_0))) {
                        return true;
                    }
                }
                if (meta == 2 && item.func_77973_b() instanceof ItemHoe) {
                    return true;
                }
                if (meta != 0 && meta != 6 && item.func_77973_b().getHarvestLevel(player.func_184586_b(hand), "shovel", player, planter) > -1) {
                    return true;
                }
                if (meta == 6 && item.func_77973_b() == Items.field_151133_ar) {
                    return true;
                }
            }
            return false;
        }
        if (meta == 0) {
            ItemStack stack;
            ItemStack itemStack = stack = hand == EnumHand.MAIN_HAND ? player.func_184614_ca() : player.func_184592_cb();
            if (!stack.func_190926_b()) {
                boolean valid = false;
                if (stack.func_77973_b() == Items.field_151131_as) {
                    world.func_175656_a(pos, planter.func_177226_a(TYPE, (Comparable)((Object)EnumPlanterType.WATER)));
                    world.func_184133_a(null, pos, SoundEvents.field_187624_K, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                    ItemStack replacement = stack.func_77973_b().getContainerItem(stack);
                    if (stack.func_190916_E() == 1 && !player.field_71075_bZ.field_75098_d) {
                        EntityEquipmentSlot slot = EntityEquipmentSlot.MAINHAND;
                        if (hand == EnumHand.OFF_HAND) {
                            slot = EntityEquipmentSlot.OFFHAND;
                        }
                        player.func_184201_a(slot, replacement);
                    } else if (!player.field_71075_bZ.field_75098_d && !player.field_71071_by.func_70441_a(replacement)) {
                        InvUtils.ejectStackWithOffset(world, new BlockPos((double)player.field_70118_ct, (double)player.field_70117_cu, (double)player.field_70116_cv), replacement);
                    }
                    valid = true;
                } else if (stack.func_77973_b() instanceof ItemBlock) {
                    Block block = ((ItemBlock)stack.func_77973_b()).func_179223_d();
                    if (this.isValidBlockStack(stack)) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            stack.func_190918_g(1);
                        }
                        for (EnumPlanterType type : EnumPlanterType.values()) {
                            if (valid) break;
                            if (type.getFill() == null || type.getFill() != block || stack.func_77952_i() != type.getBlockMeta()) continue;
                            world.func_175656_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)type)));
                            valid = true;
                        }
                    }
                    if (valid) {
                        world.func_184133_a(null, pos, block.getSoundType(state, world, pos, (Entity)player).func_185841_e(), SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
                    }
                }
                return valid;
            }
        } else if (meta == 1 && !heldItem.func_190926_b() && heldItem.func_77973_b() == Items.field_151100_aR && heldItem.func_77952_i() == 15) {
            world.func_175656_a(pos, planter.func_177226_a(TYPE, (Comparable)((Object)EnumPlanterType.FERTILE)));
            if (!player.field_71075_bZ.field_75098_d) {
                heldItem.func_190918_g(1);
            }
            world.func_184133_a(null, pos, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.25f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            return true;
        }
        if (meta != 6 && !heldItem.func_190926_b() && heldItem.func_77973_b().getHarvestLevel(heldItem, "shovel", player, planter) > -1) {
            EnumPlanterType type = (EnumPlanterType)((Object)state.func_177229_b(TYPE));
            if (!player.field_71075_bZ.field_75098_d && !player.field_71071_by.func_70441_a(new ItemStack(type.getFill(), 1, type.getBlockMeta()))) {
                player.func_71019_a(new ItemStack(type.getFill(), 1, type.getBlockMeta()), false);
            }
            world.func_184133_a(null, pos, type.getFill().getSoundType(state, world, pos, (Entity)player).func_185841_e(), SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            world.func_175656_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumPlanterType.EMPTY)));
            return true;
        }
        if (meta == 2 && heldItem.func_77973_b() instanceof ItemHoe) {
            world.func_184133_a(null, pos, SoundEvents.field_187693_cj, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            world.func_175656_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumPlanterType.DIRT)));
            return true;
        }
        if (meta == 6 && heldItem.func_77973_b() == Items.field_151133_ar) {
            if (!player.field_71075_bZ.field_75098_d) {
                if (heldItem.func_190916_E() == 1) {
                    EntityEquipmentSlot slot = EntityEquipmentSlot.MAINHAND;
                    if (hand == EnumHand.OFF_HAND) {
                        slot = EntityEquipmentSlot.OFFHAND;
                    }
                    player.func_184201_a(slot, new ItemStack(Items.field_151131_as));
                } else {
                    heldItem.func_190918_g(1);
                    if (!player.field_71071_by.func_70441_a(new ItemStack(Items.field_151131_as))) {
                        player.func_71019_a(new ItemStack(Items.field_151131_as), false);
                    }
                }
            }
            world.func_184133_a(null, pos, SoundEvents.field_187630_M, SoundCategory.BLOCKS, 1.0f, world.field_73012_v.nextFloat() * 0.1f + 0.9f);
            world.func_175656_a(pos, state.func_177226_a(TYPE, (Comparable)((Object)EnumPlanterType.EMPTY)));
            return true;
        }
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K) {
            int meta = ((EnumPlanterType)((Object)world.func_180495_p(pos).func_177229_b(TYPE))).getMeta();
            BlockPos up = pos.func_177984_a();
            if (world.func_175623_d(up)) {
                if (meta == 1) {
                    int zP;
                    int yP;
                    int xP;
                    BlockPos checkPos;
                    if (world.func_175699_k(up) > 8 && world.func_180495_p(checkPos = pos.func_177982_a(xP = rand.nextInt(3) - 1, yP = rand.nextInt(3) - 1, zP = rand.nextInt(3) - 1)).func_177230_c() == Blocks.field_150349_c) {
                        world.func_175656_a(pos, this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumPlanterType.GRASS)));
                    }
                } else if (meta == 2 && rand.nextInt(30) == 0) {
                    world.func_180494_b(pos).plantFlower(world, rand, up);
                    if (world.func_175699_k(up) > 8) {
                        for (int i = 0; i < 4; ++i) {
                            int zP;
                            int yP;
                            int xP = rand.nextInt(3) - 1;
                            BlockPos checkPos = pos.func_177982_a(xP, yP = rand.nextInt(3) - 1, zP = rand.nextInt(3) - 1);
                            if (world.func_180495_p(checkPos) != Blocks.field_150346_d || world.func_180495_p(checkPos) != Blocks.field_150346_d.func_176223_P()) continue;
                            world.func_175656_a(checkPos, Blocks.field_150349_c.func_176223_P());
                        }
                    }
                }
            } else if (world.func_180495_p(up).func_177230_c() instanceof IPlantable) {
                IPlantable plant = (IPlantable)world.func_180495_p(up).func_177230_c();
                if (this.canSustainPlant(world.func_180495_p(pos), (IBlockAccess)world, pos, EnumFacing.UP, plant) && world.func_180495_p(up).func_177230_c().func_149653_t()) {
                    IBlockState cropState = world.func_180495_p(up);
                    world.func_180495_p(up).func_177230_c().func_180650_b(world, up, cropState, rand);
                    if (meta == 4) {
                        world.func_180495_p(up).func_177230_c().func_180650_b(world, up, cropState, rand);
                        if (rand.nextInt(100) == 0) {
                            world.func_175656_a(pos, this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumPlanterType.DIRT)));
                        }
                    }
                }
            }
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean isFertile(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177229_b(TYPE) == EnumPlanterType.FERTILE;
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing dir, IPlantable plant) {
        BlockPos up = pos.func_177984_a();
        EnumPlantType plantType = plant.getPlantType(world, up);
        return dir == EnumFacing.UP && ((EnumPlanterType)((Object)world.func_180495_p(pos).func_177229_b(TYPE))).isType(plantType);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < 9; ++i) {
            list.add((Object)new ItemStack(item, 1, i));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)EnumPlanterType.byMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumPlanterType)((Object)state.func_177229_b(TYPE))).getMeta();
    }

    public static enum EnumPlanterType implements IStringSerializable
    {
        EMPTY("empty", null, 0, new EnumPlantType[0]),
        DIRT("dirt", Blocks.field_150346_d, 1, new EnumPlantType[]{EnumPlantType.Crop, EnumPlantType.Plains}),
        GRASS("grass", (Block)Blocks.field_150349_c, 2, new EnumPlantType[]{EnumPlantType.Plains}),
        SOULSAND("soul_sand", Blocks.field_150425_aM, 3, new EnumPlantType[]{EnumPlantType.Nether}),
        FERTILE("fertile", Blocks.field_150346_d, 4, new EnumPlantType[]{EnumPlantType.Crop, EnumPlantType.Plains}),
        SAND("sand", (Block)Blocks.field_150354_m, 5, new EnumPlantType[]{EnumPlantType.Desert, EnumPlantType.Beach}),
        WATER("water_still", (Block)Blocks.field_150355_j, 6, new EnumPlantType[]{EnumPlantType.Water}),
        GRAVEL("gravel", Blocks.field_150351_n, 7, new EnumPlantType[]{EnumPlantType.Cave}),
        REDSAND("red_sand", (Block)Blocks.field_150354_m, 1, 8, new EnumPlantType[]{EnumPlantType.Desert, EnumPlantType.Beach});

        private static final EnumPlanterType[] META_LOOKUP;
        private String name;
        private Block fill;
        private int meta;
        private int blockMeta;
        private EnumPlantType[] type;

        private EnumPlanterType(String name, Block fill, int meta, EnumPlantType[] type) {
            this(name, fill, 0, meta, type);
        }

        private EnumPlanterType(String name, Block fill, int blockMeta, int meta, EnumPlantType[] type) {
            this.name = name;
            this.fill = fill;
            this.blockMeta = blockMeta;
            this.meta = meta;
            this.type = type;
        }

        public static EnumPlanterType byMeta(int meta) {
            if (meta > 8) {
                return EMPTY;
            }
            return META_LOOKUP[meta];
        }

        public String func_176610_l() {
            return this.name;
        }

        public Block getFill() {
            return this.fill;
        }

        public int getBlockMeta() {
            return this.blockMeta;
        }

        public int getMeta() {
            return this.meta;
        }

        public boolean isType(EnumPlantType type) {
            return this.type.length != 0 && Arrays.asList(this.type).contains(type);
        }

        static {
            META_LOOKUP = new EnumPlanterType[EnumPlanterType.values().length];
            EnumPlanterType[] enumPlanterTypeArray = EnumPlanterType.values();
            int n = enumPlanterTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumPlanterType types;
                EnumPlanterType.META_LOOKUP[types.getMeta()] = types = enumPlanterTypeArray[i];
            }
        }
    }
}

