/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.block.IMechanicalBlock;
import betterwithmods.api.block.IMultiVariants;
import betterwithmods.client.BWCreativeTabs;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockRotate;
import betterwithmods.util.DirUtils;
import betterwithmods.util.MechanicalUtil;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPump
extends BlockRotate
implements IMechanicalBlock,
IMultiVariants {
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public BlockPump() {
        super(Material.field_151575_d);
        this.func_149647_a(BWCreativeTabs.BWTAB);
        this.func_149675_a(true);
        this.func_149711_c(3.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)DirUtils.HORIZONTAL, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)));
        this.func_149672_a(SoundType.field_185848_a);
    }

    public static boolean hasWaterToPump(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)DirUtils.HORIZONTAL);
        BlockPos source = DirUtils.movePos(pos, direction);
        IBlockState sourceState = world.func_180495_p(source);
        Block block = sourceState.func_177230_c();
        Material mat = block.func_149688_o(state);
        return block instanceof BlockLiquid && mat == Material.field_151586_h;
    }

    @Override
    public String[] getVariants() {
        return new String[]{"active=false,facing=north"};
    }

    @Override
    public boolean canOutputMechanicalPower() {
        return false;
    }

    @Override
    public boolean canInputMechanicalPower() {
        return true;
    }

    @Override
    public boolean isInputtingMechPower(World world, BlockPos pos) {
        return MechanicalUtil.isBlockPoweredByAxle(world, pos, this) || MechanicalUtil.isPoweredByCrank(world, pos);
    }

    @Override
    public boolean isOutputtingMechPower(World world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean canInputPowerToSide(IBlockAccess world, BlockPos pos, EnumFacing dir) {
        return dir == EnumFacing.DOWN;
    }

    @Override
    public void overpower(World world, BlockPos pos) {
    }

    @Override
    public boolean isMechanicalOn(IBlockAccess world, BlockPos pos) {
        return this.isMechanicalOnFromState(world.func_180495_p(pos));
    }

    @Override
    public void setMechanicalOn(World world, BlockPos pos, boolean isOn) {
        if (isOn != (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)ACTIVE)) {
            world.func_175656_a(pos, world.func_180495_p(pos).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(isOn)));
        }
    }

    @Override
    public boolean isMechanicalOnFromState(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)ACTIVE);
    }

    @Override
    public boolean canRotateOnTurntable(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean canRotateHorizontally(IBlockAccess world, BlockPos pos) {
        return true;
    }

    @Override
    public boolean canRotateVertically(IBlockAccess world, BlockPos pos) {
        return false;
    }

    @Override
    public void rotateAroundYAxis(World world, BlockPos pos, boolean reverse) {
        DirUtils.rotateAroundY(this, world, pos, reverse);
    }

    public int func_149738_a(World world) {
        return 5;
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase entity, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, side, flX, flY, flZ, meta, entity, hand);
        return this.setFacingInBlock(state, entity.func_70093_af() ? entity.func_174811_aO().func_176734_d() : entity.func_174811_aO());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
    }

    @Override
    public IBlockState setFacingInBlock(IBlockState state, EnumFacing facing) {
        return state.func_177226_a((IProperty)DirUtils.HORIZONTAL, (Comparable)facing);
    }

    public IBlockState func_176203_a(int meta) {
        boolean isActive = false;
        if (meta > 7) {
            isActive = true;
            meta -= 8;
        }
        return this.func_176223_P().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(isActive)).func_177226_a((IProperty)DirUtils.HORIZONTAL, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        int meta = (Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 8 : 0;
        return meta + ((EnumFacing)state.func_177229_b((IProperty)DirUtils.HORIZONTAL)).func_176745_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{DirUtils.HORIZONTAL, ACTIVE});
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (this.isMechanicalOnFromState(state) && world.func_175623_d(pos.func_177984_a()) && BlockPump.hasWaterToPump(world, pos)) {
            world.func_175656_a(pos.func_177984_a(), BWMBlocks.TEMP_LIQUID_SOURCE.func_176223_P());
        }
        this.setMechanicalOn(world, pos, this.isInputtingMechPower(world, pos));
        world.func_180497_b(pos, (Block)this, this.func_149738_a(world), 5);
    }

    @Override
    public void nextState(World world, BlockPos pos, IBlockState state) {
        world.func_175656_a(pos, state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).func_177231_a((IProperty)DirUtils.HORIZONTAL));
    }
}

