/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.common.blocks.BWMBlock;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockUnfiredPottery
extends BWMBlock
implements IMultiVariants {
    public static final PropertyEnum<EnumPotteryType> POTTERYTYPE = PropertyEnum.func_177709_a((String)"potterytype", EnumPotteryType.class);
    private static final AxisAlignedBB BLOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB URN_AABB = new AxisAlignedBB(0.3125, 0.0, 0.3125, 0.6875, 0.625, 0.6875);
    private static final AxisAlignedBB VASE_AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    public BlockUnfiredPottery() {
        super(Material.field_151571_B);
        this.func_149672_a(SoundType.field_185849_b);
        this.func_149711_c(0.5f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(POTTERYTYPE, (Comparable)((Object)EnumPotteryType.CRUCIBLE)));
    }

    @Override
    public String[] getVariants() {
        return new String[]{"potterytype=crucible", "potterytype=planter", "potterytype=urn", "potterytype=vase"};
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing side, float flX, float flY, float flZ, int meta, EntityLivingBase entity, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, side, flX, flY, flZ, meta, entity, hand);
        return state.func_177226_a(POTTERYTYPE, (Comparable)((Object)EnumPotteryType.byMeta(meta)));
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < 4; ++i) {
            list.add((Object)new ItemStack(item, 1, i));
        }
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumPotteryType)((Object)state.func_177229_b(POTTERYTYPE))).getMeta();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        EnumPotteryType type = (EnumPotteryType)((Object)state.func_177229_b(POTTERYTYPE));
        switch (type) {
            case CRUCIBLE: 
            case PLANTER: {
                return BLOCK_AABB;
            }
            case URN: {
                return URN_AABB;
            }
        }
        return VASE_AABB;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return world.isSideSolid(pos.func_177977_b(), EnumFacing.UP);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block block, BlockPos other) {
        if (!world.isSideSolid(pos.func_177977_b(), EnumFacing.UP)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(POTTERYTYPE, (Comparable)((Object)EnumPotteryType.byMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumPotteryType)((Object)state.func_177229_b(POTTERYTYPE))).getMeta();
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POTTERYTYPE});
    }

    public static enum EnumPotteryType implements IStringSerializable
    {
        CRUCIBLE(0, "crucible"),
        PLANTER(1, "planter"),
        URN(2, "urn"),
        VASE(3, "vase");

        private static final EnumPotteryType[] META_LOOKUP;
        private String name;
        private int meta;

        private EnumPotteryType(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public static EnumPotteryType byMeta(int meta) {
            return META_LOOKUP[meta];
        }

        public int getMeta() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumPotteryType[EnumPotteryType.values().length];
            EnumPotteryType[] enumPotteryTypeArray = EnumPotteryType.values();
            int n = enumPotteryTypeArray.length;
            for (int i = 0; i < n; ++i) {
                EnumPotteryType type;
                EnumPotteryType.META_LOOKUP[type.getMeta()] = type = enumPotteryTypeArray[i];
            }
        }
    }
}

