/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks;

import betterwithmods.api.block.IMultiVariants;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BWMBlock;
import betterwithmods.common.blocks.tile.TileEntityVase;
import betterwithmods.util.InvUtils;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class BlockVase
extends BWMBlock
implements IMultiVariants {
    public static final PropertyEnum<EnumDyeColor> Color = BlockColored.field_176581_a;
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);

    public BlockVase() {
        super(BWMBlocks.POTTERY);
        this.func_149711_c(2.0f);
        this.setHarvestLevel("pickaxe", -1);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(Color, (Comparable)EnumDyeColor.WHITE));
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityVase();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public String[] getVariants() {
        EnumDyeColor[] dyes = EnumDyeColor.values();
        String[] variants = new String[dyes.length];
        for (int i = 0; i < dyes.length; ++i) {
            EnumDyeColor dye = dyes[i];
            variants[i] = "color=" + dye.func_176610_l();
        }
        return variants;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            InvUtils.readFromStack((IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), stack);
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        if (playerIn.func_70093_af()) {
            return false;
        }
        InvUtils.getItemHandler(worldIn, pos, null).ifPresent(inv -> {
            if (InvUtils.insertSingle(inv, heldItem, false).func_190926_b()) {
                if (!playerIn.func_184812_l_()) {
                    heldItem.func_190918_g(1);
                }
                worldIn.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        });
        return super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        if (!world.field_72995_K && entity != null && entity instanceof EntityArrow) {
            world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            world.func_175666_e(pos, (Block)this);
            world.func_175698_g(pos);
        }
        super.func_180634_a(world, pos, state, entity);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        ItemStack stack = new ItemStack(Item.func_150898_a((Block)this), 1, ((EnumDyeColor)state.func_177229_b(Color)).func_176765_a());
        TileEntity tile = world.func_175625_s(pos);
        if (!world.field_72995_K && tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            InvUtils.writeToStack((IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), stack);
        }
        return stack;
    }

    public boolean canSilkHarvest(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        return true;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(Color)).func_176765_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < EnumDyeColor.values().length; ++i) {
            list.add((Object)new ItemStack(item, 1, i));
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(Color, (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(Color)).func_176765_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{Color});
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        TileEntity tile = worldIn.func_175625_s(pos);
        if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return ((IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).getStackInSlot(0) != null ? 15 : 0;
        }
        return 0;
    }
}

