/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.tile;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IProjectile;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TileEntityDragonVessel
extends TileEntity
implements ITickable {
    private final int MAX_EXPERIENCE = 800;
    private int experience;
    private int maxDist = 5;
    private static final String PREVENT_REMOTE_MOVEMENT = "PreventRemoteMovement";
    public static final String BWM_PULLER_TAG = "BWMpuller";

    private int addExperience(int xp) {
        if (this.experience >= 800) {
            return xp;
        }
        if (this.experience < 800 - xp) {
            this.experience += xp;
            return 0;
        }
        if (this.experience >= 800 - xp) {
            int newXp = xp - (800 - this.experience);
            this.experience += newXp;
            return xp - newXp;
        }
        return xp;
    }

    private void hooverXP(EntityXPOrb entity) {
        if (!this.field_145850_b.field_72995_K && !entity.field_70128_L) {
            int xpValue = entity.func_70526_d();
            this.addExperience(xpValue);
            this.func_70296_d();
            if (xpValue > 0) {
                entity.field_70530_e = xpValue;
                TileEntityDragonVessel.release((Entity)entity);
            } else {
                entity.func_70106_y();
            }
        }
    }

    public void func_73660_a() {
        AxisAlignedBB box = this.field_145850_b.func_180495_p(this.field_174879_c).func_185900_c((IBlockAccess)this.field_145850_b, this.field_174879_c).func_72321_a(5.0, 5.0, 5.0);
        List xp = this.field_145850_b.func_72872_a(EntityXPOrb.class, box);
        for (EntityXPOrb entity : xp) {
            boolean silent;
            double zDist;
            double yDist;
            double xDist = (double)this.func_174877_v().func_177958_n() + 0.5 - entity.field_70165_t;
            double totalDistance = Math.sqrt(xDist * xDist + (yDist = (double)this.func_174877_v().func_177956_o() + 0.5 - entity.field_70163_u) * yDist + (zDist = (double)this.func_174877_v().func_177952_p() + 0.5 - entity.field_70161_v) * zDist);
            if (totalDistance < 1.5) {
                this.hooverXP(entity);
                continue;
            }
            if (!TileEntityDragonVessel.shouldAttract(this.func_174877_v(), (Entity)entity)) continue;
            double d = 1.0 - Math.max(0.1, totalDistance) / (double)this.maxDist;
            double speed = 0.01 + d * 0.02;
            entity.field_70159_w += xDist / totalDistance * speed;
            entity.field_70179_y += zDist / totalDistance * speed;
            entity.field_70181_x += yDist / totalDistance * speed;
            if (yDist > 0.5) {
                entity.field_70181_x = 0.12;
            }
            entity.func_174810_b(!(silent = entity.func_174814_R()));
            entity.func_174810_b(silent);
        }
    }

    public static boolean shouldAttract(@Nullable BlockPos pullerPos, @Nullable Entity entity) {
        if (entity == null || entity.field_70128_L) {
            return false;
        }
        if (entity instanceof IProjectile && entity.field_70181_x > 0.01) {
            return false;
        }
        NBTTagCompound data = entity.getEntityData();
        if (TileEntityDragonVessel.isReservedByOthers(data)) {
            return false;
        }
        if (!TileEntityDragonVessel.isReservedByBWM(data)) {
            if (pullerPos != null) {
                data.func_74772_a(BWM_PULLER_TAG, pullerPos.func_177986_g());
            }
            return true;
        }
        if (pullerPos == null) {
            return false;
        }
        long posL = data.func_74763_f(BWM_PULLER_TAG);
        if (posL == pullerPos.func_177986_g()) {
            return true;
        }
        BlockPos curOwner = BlockPos.func_177969_a((long)posL);
        double distToCur = curOwner.func_177957_d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        double distToMe = pullerPos.func_177957_d(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (distToMe + 1.0 < distToCur) {
            data.func_74772_a(BWM_PULLER_TAG, pullerPos.func_177986_g());
            return true;
        }
        return false;
    }

    public static void release(@Nullable Entity entity) {
        if (entity != null && !entity.field_70128_L) {
            NBTTagCompound data = entity.getEntityData();
            data.func_82580_o(BWM_PULLER_TAG);
        }
    }

    public static boolean isReserved(Entity entity) {
        return TileEntityDragonVessel.isReservedByBWM(entity.getEntityData()) || TileEntityDragonVessel.isReservedByOthers(entity.getEntityData());
    }

    public static boolean isReservedByBWM(NBTTagCompound data) {
        return data.func_74764_b(BWM_PULLER_TAG);
    }

    public static boolean isReservedByOthers(NBTTagCompound data) {
        return data.func_74764_b(PREVENT_REMOTE_MOVEMENT);
    }
}

