/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.tile;

import betterwithmods.api.block.IMechanicalBlock;
import betterwithmods.api.block.ISoulSensitive;
import betterwithmods.client.model.filters.ModelWithResource;
import betterwithmods.client.model.render.RenderUtils;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockMechMachines;
import betterwithmods.common.blocks.tile.IMechSubtype;
import betterwithmods.common.blocks.tile.SimpleStackHandler;
import betterwithmods.common.blocks.tile.TileEntityVisibleInventory;
import betterwithmods.common.registry.HopperFilters;
import betterwithmods.common.registry.HopperInteractions;
import betterwithmods.util.InvUtils;
import betterwithmods.util.WorldUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;

public class TileEntityFilteredHopper
extends TileEntityVisibleInventory
implements IMechSubtype {
    private final int STACK_SIZE = 8;
    public int filterType = 0;
    public byte power;
    public int soulsRetained = 0;
    private int ejectCounter = 0;
    private int ejectXPCounter = 10;
    private int experienceCount = 0;
    private int maxExperienceCount = 1000;

    public TileEntityFilteredHopper() {
        this.occupiedSlots = 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("EjectCounter")) {
            this.ejectCounter = tag.func_74762_e("EjectCounter");
        }
        if (tag.func_74764_b("XPCount")) {
            this.experienceCount = tag.func_74762_e("XPCount");
        }
        if (tag.func_74764_b("FilterType")) {
            this.filterType = tag.func_74765_d("FilterType");
        }
        if (tag.func_74764_b("Souls")) {
            this.soulsRetained = tag.func_74762_e("Souls");
        }
        if (tag.func_74764_b("IsPowered")) {
            this.power = tag.func_74767_n("IsPowered") ? (byte)1 : 0;
        }
        this.validateInventory();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        t.func_74768_a("EjectCounter", this.ejectCounter);
        t.func_74768_a("XPCount", this.experienceCount);
        t.func_74777_a("FilterType", (short)this.filterType);
        t.func_74768_a("Souls", this.soulsRetained);
        t.func_74757_a("IsPowered", this.power > 1);
        return t;
    }

    private List<EntityItem> getCollidingItems(World world, BlockPos pos) {
        return world.func_175647_a(EntityItem.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o() + 1.0001, (double)pos.func_177952_p() + 1.0), EntitySelectors.field_94557_a);
    }

    private List<EntityXPOrb> getCollidingXPOrbs(World world, BlockPos pos) {
        return world.func_72872_a(EntityXPOrb.class, new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)pos.func_177958_n() + 1.0, (double)pos.func_177956_o() + 1.5, (double)pos.func_177952_p() + 1.0));
    }

    public boolean isPowered() {
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        return state.func_177230_c() instanceof IMechanicalBlock && ((IMechanicalBlock)state.func_177230_c()).isMechanicalOn((IBlockAccess)this.field_145850_b, this.field_174879_c);
    }

    public boolean isXPFull() {
        return this.experienceCount >= this.maxExperienceCount;
    }

    private void insert() {
        EntityItem item;
        if (!InvUtils.isFull((IItemHandler)this.inventory) && (item = (EntityItem)this.getCollidingItems(this.field_145850_b, this.field_174879_c).stream().findFirst().orElse(null)) != null) {
            if (HopperInteractions.attemptToCraft(this.filterType, this.func_145831_w(), this.func_174877_v(), item)) {
                this.func_145831_w().func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((this.func_145831_w().field_73012_v.nextFloat() - this.func_145831_w().field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
            if (this.canFilterProcessItem(item.func_92059_d()) && InvUtils.insertFromWorld((IItemHandler)this.inventory, item, 0, 18, false)) {
                this.func_145831_w().func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187638_cR, SoundCategory.PLAYERS, 0.2f, ((this.func_145831_w().field_73012_v.nextFloat() - this.func_145831_w().field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
        if (!this.isXPFull() && this.filterType == 6) {
            List<EntityXPOrb> orbs = this.getCollidingXPOrbs(this.field_145850_b, this.field_174879_c);
            for (EntityXPOrb orb : orbs) {
                int remaining = this.maxExperienceCount - this.experienceCount;
                int value = orb.func_70526_d();
                if (remaining <= 0) continue;
                if (value <= remaining) {
                    this.experienceCount += value;
                    orb.func_70106_y();
                    continue;
                }
                orb.field_70530_e -= remaining;
                this.experienceCount = this.maxExperienceCount;
            }
        }
    }

    private void extract() {
        Optional<IItemHandler> inv = InvUtils.getItemHandler(this.field_145850_b, this.field_174879_c.func_177977_b(), EnumFacing.UP);
        if (this.ejectCounter > 2) {
            int slot = InvUtils.getFirstOccupiedStackInRange((IItemHandler)this.inventory, 0, 17);
            if (slot != -1) {
                ItemStack stack = this.inventory.getStackInSlot(slot);
                if (inv.isPresent()) {
                    if (InvUtils.canInsert(inv.get(), stack, 8)) {
                        ItemStack insert = InvUtils.insert(inv.get(), stack, 8, false);
                        InvUtils.consumeItemsInInventory((IItemHandler)this.inventory, stack, 8 - insert.func_190916_E(), false);
                    }
                } else {
                    InvUtils.consumeItemsInInventory((IItemHandler)this.inventory, stack, 8, false);
                    InvUtils.spawnStack(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() - 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 8, stack);
                }
            }
            this.ejectCounter = 0;
        } else {
            ++this.ejectCounter;
        }
        if (this.ejectXPCounter > 2) {
            if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_185904_a().func_76222_j() && this.experienceCount > 19) {
                this.experienceCount -= 20;
                this.spawnEntityXPOrb(20);
            }
            this.ejectXPCounter = 0;
        } else {
            ++this.ejectXPCounter;
        }
    }

    public void func_73660_a() {
        boolean isPowered = this.isPowered();
        if ((isPowered ? (byte)1 : 0) != this.power) {
            this.power = (byte)(this.isPowered() ? 1 : 0);
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockMechMachines && this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BlockMechMachines.MACHINETYPE) == BlockMechMachines.EnumType.HOPPER) {
            this.insert();
            if (this.isPowered()) {
                this.extract();
            }
        }
        if (this.soulsRetained > 0) {
            this.processSouls();
        }
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        int z;
        int y;
        int x = this.field_174879_c.func_177958_n();
        return player.func_70092_e((double)x + 0.5, (double)(y = this.field_174879_c.func_177956_o()) + 0.5, (double)(z = this.field_174879_c.func_177952_p()) + 0.5) <= 64.0;
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        if (this.func_145831_w() != null) {
            this.validateInventory();
        }
    }

    private boolean validateInventory() {
        byte slotsOccupied;
        boolean stateChanged = false;
        int currentFilter = this.getFilterType();
        if (currentFilter != this.filterType) {
            this.filterType = currentFilter;
            stateChanged = true;
        }
        if ((slotsOccupied = (byte)InvUtils.getOccupiedStacks((IItemHandler)this.inventory, 0, 17)) != this.occupiedSlots) {
            this.occupiedSlots = slotsOccupied;
            stateChanged = true;
        }
        if (this.func_145831_w() != null && stateChanged) {
            IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
            this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
        }
        return stateChanged;
    }

    private int getFilterType() {
        ItemStack filter = this.getFilterStack();
        if (filter.func_190926_b()) {
            return -1;
        }
        return (short)HopperFilters.getFilterType(filter);
    }

    private boolean canFilterProcessItem(ItemStack stack) {
        this.validateInventory();
        if (this.filterType == -1) {
            return true;
        }
        if (this.filterType == 0) {
            return this.getFilterStack().func_77969_a(stack);
        }
        if (this.filterType > 0) {
            if (!this.isPowered()) {
                return false;
            }
            if (HopperFilters.getAllowedItems(this.filterType) != null) {
                return HopperFilters.getAllowedItems(this.filterType).test(stack);
            }
        }
        return true;
    }

    private void spawnEntityXPOrb(int value) {
        double xOff = this.func_145831_w().field_73012_v.nextDouble() * 0.1 + 0.45;
        double yOff = -0.5;
        double zOff = this.func_145831_w().field_73012_v.nextDouble() * 0.1 + 0.45;
        EntityXPOrb orb = new EntityXPOrb(this.func_145831_w(), (double)this.field_174879_c.func_177958_n() + xOff, (double)this.field_174879_c.func_177956_o() + yOff, (double)this.field_174879_c.func_177952_p() + zOff, value);
        orb.field_70159_w = 0.0;
        orb.field_70181_x = 0.0;
        orb.field_70179_y = 0.0;
        this.func_145831_w().func_72838_d((Entity)orb);
    }

    private void processSouls() {
        BlockPos down = this.field_174879_c.func_177977_b();
        if (this.filterType == 6) {
            Block blockBelow = this.func_145831_w().func_180495_p(down).func_177230_c();
            if (this.soulsRetained > 0 && blockBelow instanceof ISoulSensitive && ((ISoulSensitive)blockBelow).isSoulSensitive((IBlockAccess)this.func_145831_w(), down)) {
                int soulsConsumed = ((ISoulSensitive)blockBelow).processSouls(this.func_145831_w(), down, this.soulsRetained);
                if (((ISoulSensitive)blockBelow).consumeSouls(this.func_145831_w(), down, soulsConsumed)) {
                    this.soulsRetained -= soulsConsumed;
                }
            } else if (this.soulsRetained > 7 && !this.isPowered()) {
                if (WorldUtils.spawnGhast(this.field_145850_b, this.field_174879_c)) {
                    this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_189105_bM, SoundCategory.BLOCKS, 1.0f, this.func_145831_w().field_73012_v.nextFloat() * 0.1f + 0.8f);
                }
                if (this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() == BWMBlocks.SINGLE_MACHINES) {
                    ((BlockMechMachines)this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c()).breakHopper(this.func_145831_w(), this.field_174879_c);
                }
            }
        } else {
            this.soulsRetained = 0;
        }
    }

    public void increaseSoulCount(int numSouls) {
        this.soulsRetained += numSouls;
    }

    @Override
    public int getInventorySize() {
        return 19;
    }

    @Override
    public SimpleStackHandler createItemStackHandler() {
        return new HopperHandler(this.getInventorySize(), this);
    }

    @Override
    public String getName() {
        return "inv.filtered_hopper.name";
    }

    @Override
    public int getSubtype() {
        return this.filterType;
    }

    @Override
    public void setSubtype(int type) {
        this.filterType = (short)Math.min(type, 7);
    }

    @Override
    public int getMaxVisibleSlots() {
        return 18;
    }

    public ModelWithResource getModel() {
        return RenderUtils.getModelFromStack(this.getFilterStack());
    }

    public ItemStack getFilterStack() {
        return this.inventory.getStackInSlot(18);
    }

    private class HopperHandler
    extends SimpleStackHandler {
        TileEntityFilteredHopper hopper;

        public HopperHandler(int size, TileEntityFilteredHopper hopper) {
            super(size, hopper);
            this.hopper = hopper;
        }

        @Override
        public void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileEntityFilteredHopper.this.field_145850_b.func_175704_b(TileEntityFilteredHopper.this.field_174879_c, TileEntityFilteredHopper.this.field_174879_c);
            TileEntityFilteredHopper.this.func_145831_w().func_184138_a(TileEntityFilteredHopper.this.field_174879_c, TileEntityFilteredHopper.this.field_145850_b.func_180495_p(TileEntityFilteredHopper.this.field_174879_c), TileEntityFilteredHopper.this.field_145850_b.func_180495_p(TileEntityFilteredHopper.this.field_174879_c), 2);
        }

        public int getSlotLimit(int slot) {
            return slot == 18 ? 1 : super.getSlotLimit(slot);
        }
    }
}

