/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.tile;

import betterwithmods.common.BWSounds;
import betterwithmods.common.blocks.BlockMechMachines;
import betterwithmods.common.blocks.tile.TileBasicInventory;
import betterwithmods.common.registry.bulk.manager.MillManager;
import betterwithmods.common.registry.bulk.recipes.MillRecipe;
import betterwithmods.util.InvUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityMill
extends TileBasicInventory
implements ITickable {
    public static final int GRIND_TIME = 200;
    public int grindCounter = 0;
    private int grindType = 0;
    private boolean validateContents = true;
    private boolean containsIngredientsToGrind;

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        Block block = this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c();
        if (block == null || !(block instanceof BlockMechMachines)) {
            return;
        }
        BlockMechMachines mill = (BlockMechMachines)block;
        if (this.validateContents) {
            this.validateContents();
        }
        if (mill.isMechanicalOn((IBlockAccess)this.func_145831_w(), this.field_174879_c) && this.func_145831_w().field_73012_v.nextInt(20) == 0) {
            this.func_145831_w().func_184133_a(null, this.field_174879_c, BWSounds.STONEGRIND, SoundCategory.BLOCKS, 0.5f + this.func_145831_w().field_73012_v.nextFloat() * 0.1f, 0.5f + this.func_145831_w().field_73012_v.nextFloat() * 0.1f);
        }
        if (this.containsIngredientsToGrind && mill.isMechanicalOn((IBlockAccess)this.func_145831_w(), this.field_174879_c)) {
            if (!this.func_145831_w().field_72995_K) {
                if (this.grindType == 2) {
                    if (this.func_145831_w().field_73012_v.nextInt(25) < 2) {
                        this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187555_bJ, SoundCategory.BLOCKS, 1.0f, this.func_145831_w().field_73012_v.nextFloat() * 0.4f + 0.8f);
                    }
                } else if (this.grindType == 1 && this.func_145831_w().field_73012_v.nextInt(20) < 2) {
                    this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187863_gH, SoundCategory.BLOCKS, 2.0f, (this.func_145831_w().field_73012_v.nextFloat() - this.func_145831_w().field_73012_v.nextFloat()) * 0.2f + 1.0f);
                }
            }
            ++this.grindCounter;
            if (this.grindCounter > 199) {
                this.grindContents();
                this.grindCounter = 0;
                this.validateContents = true;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("GrindCounter")) {
            this.grindCounter = tag.func_74762_e("GrindCounter");
        }
    }

    @Override
    public int getInventorySize() {
        return 3;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74768_a("GrindCounter", this.grindCounter);
        return tag;
    }

    public int getGrindType() {
        return this.grindType;
    }

    @Override
    public void func_70296_d() {
        super.func_70296_d();
        this.validateContents();
        if (this.func_145831_w() != null && !this.func_145831_w().field_72995_K) {
            if (this.grindType == 1) {
                this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187871_gL, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            this.validateContents = true;
        }
    }

    private void ejectStack(ItemStack stack) {
        IBlockState down;
        ArrayList<EnumFacing> validDirections = new ArrayList<EnumFacing>();
        for (EnumFacing facing : EnumFacing.field_176754_o) {
            IBlockState check = this.func_145831_w().func_180495_p(this.field_174879_c.func_177972_a(facing));
            if (!check.func_177230_c().func_176200_f((IBlockAccess)this.func_145831_w(), this.field_174879_c.func_177972_a(facing)) && !this.func_145831_w().func_175623_d(this.field_174879_c.func_177972_a(facing))) continue;
            validDirections.add(facing);
        }
        if (validDirections.isEmpty() && ((down = this.func_145831_w().func_180495_p(this.field_174879_c.func_177972_a(EnumFacing.DOWN))).func_177230_c().func_176200_f((IBlockAccess)this.func_145831_w(), this.field_174879_c.func_177972_a(EnumFacing.DOWN)) || this.func_145831_w().func_175623_d(this.field_174879_c.func_177972_a(EnumFacing.DOWN)))) {
            validDirections.add(EnumFacing.DOWN);
        }
        BlockPos offset = validDirections.size() > 1 ? this.field_174879_c.func_177972_a((EnumFacing)validDirections.get(this.func_145831_w().field_73012_v.nextInt(validDirections.size()))) : (validDirections.isEmpty() ? this.field_174879_c.func_177972_a(EnumFacing.UP) : this.field_174879_c.func_177972_a((EnumFacing)validDirections.get(0)));
        InvUtils.ejectStackWithOffset(this.func_145831_w(), offset, stack);
    }

    public double getGrindProgress() {
        return (double)this.grindCounter / 200.0;
    }

    public boolean isGrinding() {
        return this.grindCounter > 0;
    }

    private boolean grindContents() {
        MillManager mill = MillManager.getInstance();
        List<Object> ingredients = mill.getValidCraftingIngredients(this.inventory);
        if (ingredients != null) {
            NonNullList<ItemStack> output;
            if (this.grindType == 1) {
                this.func_145831_w().func_184133_a(null, this.field_174879_c, SoundEvents.field_187859_gF, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            if (!(output = mill.craftItem(this.field_145850_b, this, this.inventory)).isEmpty()) {
                for (ItemStack anOutput : output) {
                    ItemStack stack = anOutput.func_77946_l();
                    if (stack.func_190926_b()) continue;
                    this.ejectStack(stack);
                }
            }
            return true;
        }
        return false;
    }

    private void validateContents() {
        int oldGrindType = this.getGrindType();
        int newGrindType = 0;
        MillRecipe recipe = (MillRecipe)MillManager.getInstance().getMostValidRecipe(this.inventory);
        if (recipe != null) {
            this.containsIngredientsToGrind = true;
            newGrindType = recipe.getGrindType();
        } else {
            this.grindCounter = 0;
            this.containsIngredientsToGrind = false;
        }
        this.validateContents = false;
        if (oldGrindType != newGrindType) {
            this.grindType = newGrindType;
        }
    }
}

