/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.tile;

import betterwithmods.BWMod;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.blocks.BlockAnchor;
import betterwithmods.common.blocks.BlockMechMachines;
import betterwithmods.common.blocks.BlockRope;
import betterwithmods.common.blocks.tile.SimpleStackHandler;
import betterwithmods.common.blocks.tile.TileEntityVisibleInventory;
import betterwithmods.common.entity.EntityExtendingRope;
import betterwithmods.module.GlobalConfig;
import betterwithmods.util.InvUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraftforge.items.IItemHandler;

public class TileEntityPulley
extends TileEntityVisibleInventory {
    private EntityExtendingRope rope;
    private NBTTagCompound ropeTag = null;

    public static final boolean isValidPlatform(Block block) {
        return block == BWMBlocks.PLATFORM || block == BWMBlocks.IRON_WALL;
    }

    private boolean isRedstonePowered() {
        return this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() != null && this.func_145831_w().func_175640_z(this.field_174879_c);
    }

    public boolean isMechanicallyPowered() {
        return this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() != null && this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockMechMachines && ((BlockMechMachines)this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c()).isMechanicalOn((IBlockAccess)this.func_145831_w(), this.field_174879_c);
    }

    @Override
    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public boolean isRaising() {
        return !this.isRedstonePowered() && this.isMechanicallyPowered();
    }

    public boolean isLowering() {
        return !this.isRedstonePowered() && !this.isMechanicallyPowered();
    }

    @Override
    public int getInventorySize() {
        return 4;
    }

    @Override
    public SimpleStackHandler createItemStackHandler() {
        return super.createItemStackHandler();
    }

    @Override
    public String getName() {
        return "inv.pulley.name";
    }

    @Override
    public int getMaxVisibleSlots() {
        return 4;
    }

    public boolean isUseableByPlayer(EntityPlayer player) {
        int z;
        int y;
        int x = this.field_174879_c.func_177958_n();
        return player.func_70092_e((double)x + 0.5, (double)(y = this.field_174879_c.func_177956_o()) + 0.5, (double)(z = this.field_174879_c.func_177952_p()) + 0.5) <= 64.0;
    }

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        this.tryNextOperation();
    }

    private void tryNextOperation() {
        if (!this.activeOperation() && this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockMechMachines) {
            if (this.canGoDown(false)) {
                this.goDown();
            } else if (this.canGoUp()) {
                this.goUp();
            }
        }
    }

    private boolean canGoUp() {
        BlockPos lowest;
        return this.isRaising() && this.putRope(false) && !(lowest = BlockRope.getLowestRopeBlock(this.func_145831_w(), this.field_174879_c)).equals((Object)this.field_174879_c);
    }

    private boolean canGoDown(boolean isMoving) {
        if (this.isLowering() && this.takeRope(false)) {
            boolean flag;
            BlockPos newPos = BlockRope.getLowestRopeBlock(this.func_145831_w(), this.field_174879_c).func_177977_b();
            IBlockState state = this.func_145831_w().func_180495_p(newPos);
            boolean bl = flag = !isMoving && state.func_177230_c() == BWMBlocks.ANCHOR && ((BlockAnchor)BWMBlocks.ANCHOR).getFacingFromBlockState(state) == EnumFacing.UP;
            if (newPos.func_177956_o() > 0 && (this.func_145831_w().func_175623_d(newPos) || state.func_177230_c().func_176200_f((IBlockAccess)this.func_145831_w(), newPos) || flag) && newPos.func_177984_a().func_177956_o() > 0) {
                return true;
            }
        }
        return false;
    }

    private void goUp() {
        BlockPos lowest = BlockRope.getLowestRopeBlock(this.func_145831_w(), this.field_174879_c);
        IBlockState state = this.func_145831_w().func_180495_p(lowest.func_177977_b());
        boolean flag = state.func_177230_c() == BWMBlocks.ANCHOR && ((BlockAnchor)BWMBlocks.ANCHOR).getFacingFromBlockState(state) == EnumFacing.UP;
        this.rope = new EntityExtendingRope(this.func_145831_w(), this.field_174879_c, lowest, lowest.func_177984_a().func_177956_o());
        if (!flag || this.movePlatform(lowest.func_177977_b(), true)) {
            this.func_145831_w().func_184133_a(null, this.field_174879_c.func_177977_b(), SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 0.4f + this.func_145831_w().field_73012_v.nextFloat() * 0.1f, 1.0f);
            this.func_145831_w().func_72838_d((Entity)this.rope);
            this.func_145831_w().func_175698_g(lowest);
            this.putRope(true);
        } else {
            this.rope = null;
        }
    }

    private void goDown() {
        BlockPos newPos = BlockRope.getLowestRopeBlock(this.func_145831_w(), this.field_174879_c).func_177977_b();
        IBlockState state = this.func_145831_w().func_180495_p(newPos);
        boolean flag = state.func_177230_c() == BWMBlocks.ANCHOR && ((BlockAnchor)BWMBlocks.ANCHOR).getFacingFromBlockState(state) == EnumFacing.UP;
        this.rope = new EntityExtendingRope(this.func_145831_w(), this.field_174879_c, newPos.func_177984_a(), newPos.func_177956_o());
        if (!flag || this.movePlatform(newPos, false)) {
            this.func_145831_w().func_72838_d((Entity)this.rope);
        } else {
            this.rope = null;
        }
    }

    private boolean movePlatform(BlockPos anchor, boolean up) {
        boolean success;
        IBlockState state = this.func_145831_w().func_180495_p(anchor);
        if (state.func_177230_c() != BWMBlocks.ANCHOR) {
            return false;
        }
        HashSet<BlockPos> platformBlocks = new HashSet<BlockPos>();
        platformBlocks.add(anchor);
        Block b = this.func_145831_w().func_180495_p(anchor.func_177977_b()).func_177230_c();
        boolean bl = TileEntityPulley.isValidPlatform(this.func_145831_w().func_180495_p(anchor.func_177977_b()).func_177230_c()) ? this.addToList(platformBlocks, anchor.func_177977_b(), up) : (success = up || this.isValidBlock(b, anchor.func_177977_b()));
        if (!success) {
            return false;
        }
        for (BlockPos blockPos : platformBlocks) {
            Arrays.asList(blockPos.func_177978_c(), blockPos.func_177968_d()).forEach(p -> {
                if (!platformBlocks.contains(p)) {
                    this.fixRail((BlockPos)p, BlockRailBase.EnumRailDirection.ASCENDING_NORTH, BlockRailBase.EnumRailDirection.ASCENDING_SOUTH);
                }
            });
            Arrays.asList(blockPos.func_177974_f(), blockPos.func_177976_e()).forEach(p -> {
                if (!platformBlocks.contains(p)) {
                    this.fixRail((BlockPos)p, BlockRailBase.EnumRailDirection.ASCENDING_EAST, BlockRailBase.EnumRailDirection.ASCENDING_WEST);
                }
            });
        }
        if (!this.func_145831_w().field_72995_K) {
            for (BlockPos blockPos : platformBlocks) {
                IBlockState blockState = this.func_145831_w().func_180495_p(blockPos.func_177984_a());
                b = blockState.func_177230_c();
                blockState = b == Blocks.field_150488_af || b instanceof BlockRailBase ? blockState : null;
                BlockPos offset = blockPos.func_177973_b((Vec3i)anchor.func_177984_a());
                this.rope.addBlock((Vec3i)offset, this.func_145831_w().func_180495_p(blockPos));
                if (blockState != null) {
                    this.rope.addBlock(new Vec3i(offset.func_177958_n(), offset.func_177956_o() + 1, offset.func_177952_p()), blockState);
                    this.func_145831_w().func_175698_g(blockPos.func_177984_a());
                }
                this.func_145831_w().func_175698_g(blockPos);
            }
        }
        return true;
    }

    public boolean isValidBlock(Block b, BlockPos pos) {
        return b == Blocks.field_150350_a || b.func_176200_f((IBlockAccess)this.func_145831_w(), pos) || TileEntityPulley.isValidPlatform(b);
    }

    private void fixRail(BlockPos rail, BlockRailBase.EnumRailDirection ... directions) {
        List<BlockRailBase.EnumRailDirection> list = Arrays.asList(directions);
        IBlockState state = this.func_145831_w().func_180495_p(rail);
        if (this.func_145831_w().func_180495_p(rail).func_177230_c() instanceof BlockRailBase) {
            PropertyEnum shape = null;
            for (IProperty p : state.func_177227_a()) {
                if (!"shape".equals(p.func_177701_a()) || !(p instanceof PropertyEnum)) continue;
                shape = (PropertyEnum)p;
                break;
            }
            if (shape != null) {
                BlockRailBase.EnumRailDirection currentShape = (BlockRailBase.EnumRailDirection)state.func_177229_b(shape);
                if (list.contains(currentShape)) {
                    this.func_145831_w().func_180501_a(rail, state.func_177226_a((IProperty)shape, (Comparable)this.flatten(currentShape)), 6);
                }
            } else {
                Formatter f = new Formatter();
                BWMod.logger.warn((Object)f.format("Rail at %s has no shape?", rail));
                f.close();
            }
        }
    }

    private BlockRailBase.EnumRailDirection flatten(BlockRailBase.EnumRailDirection old) {
        switch (old) {
            case ASCENDING_EAST: 
            case ASCENDING_WEST: {
                return BlockRailBase.EnumRailDirection.EAST_WEST;
            }
            case ASCENDING_NORTH: 
            case ASCENDING_SOUTH: {
                return BlockRailBase.EnumRailDirection.NORTH_SOUTH;
            }
        }
        return old;
    }

    private boolean addToList(HashSet<BlockPos> set, BlockPos p, boolean up) {
        BlockPos blockCheck;
        if (set.size() > GlobalConfig.maxPlatformBlocks) {
            return false;
        }
        BlockPos blockPos = blockCheck = up ? p.func_177984_a() : p.func_177977_b();
        if (!TileEntityPulley.isValidPlatform(this.func_145831_w().func_180495_p(p).func_177230_c())) {
            return true;
        }
        Block b = this.func_145831_w().func_180495_p(blockCheck).func_177230_c();
        if (!(b == Blocks.field_150488_af || b instanceof BlockRailBase || this.func_145831_w().func_175623_d(blockCheck) || b.func_176200_f((IBlockAccess)this.func_145831_w(), blockCheck) || TileEntityPulley.isValidPlatform(b) || set.contains(blockCheck))) {
            return false;
        }
        set.add(p);
        ArrayList fails = new ArrayList();
        Arrays.asList(p.func_177984_a(), p.func_177977_b(), p.func_177978_c(), p.func_177968_d(), p.func_177974_f(), p.func_177976_e()).forEach(q -> {
            if (fails.isEmpty() && !set.contains(q) && !this.addToList(set, (BlockPos)q, up)) {
                fails.add(q);
            }
        });
        return fails.isEmpty();
    }

    private boolean activeOperation() {
        return this.rope != null && this.rope.func_70089_S();
    }

    private boolean takeRope(boolean flag) {
        return InvUtils.consumeItemsInInventory((IItemHandler)this.inventory, new ItemStack(BWMBlocks.ROPE), 1, !flag);
    }

    private boolean putRope(boolean flag) {
        return InvUtils.insert((IItemHandler)this.inventory, new ItemStack(BWMBlocks.ROPE, 1), !flag).func_190926_b();
    }

    public boolean onJobCompleted(boolean up, int targetY, EntityExtendingRope theRope) {
        BlockPos ropePos = new BlockPos(this.field_174879_c.func_177958_n(), targetY - (up ? 1 : 0), this.field_174879_c.func_177952_p());
        IBlockState state = this.func_145831_w().func_180495_p(ropePos);
        if (!up) {
            if ((this.func_145831_w().func_175623_d(ropePos) || state.func_177230_c().func_176200_f((IBlockAccess)this.func_145831_w(), ropePos)) && BWMBlocks.ROPE.func_176196_c(this.func_145831_w(), ropePos) && this.takeRope(true)) {
                this.func_145831_w().func_184133_a(null, this.field_174879_c.func_177977_b(), SoundEvents.field_187577_bU, SoundCategory.BLOCKS, 0.4f, 1.0f);
                this.func_145831_w().func_175656_a(ropePos, BWMBlocks.ROPE.func_176223_P());
            } else {
                this.tryNextOperation();
                theRope.func_70106_y();
                return false;
            }
        }
        if ((theRope.getUp() ? this.canGoUp() : this.canGoDown(true)) && !theRope.isPathBlocked()) {
            theRope.setTargetY(targetY + (theRope.getUp() ? 1 : -1));
            if (up && !this.func_145831_w().func_175623_d(ropePos.func_177984_a())) {
                this.func_145831_w().func_184133_a(null, this.field_174879_c.func_177977_b(), SoundEvents.field_187571_bR, SoundCategory.BLOCKS, 0.4f + this.func_145831_w().field_73012_v.nextFloat() * 0.1f, 1.0f);
                this.func_145831_w().func_175698_g(ropePos.func_177984_a());
                this.putRope(true);
            }
            return true;
        }
        this.tryNextOperation();
        theRope.func_70106_y();
        return false;
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound ropetag = new NBTTagCompound();
        if (this.rope != null) {
            this.rope.func_184198_c(ropetag);
        }
        tag.func_74782_a("Rope", (NBTBase)ropetag);
        return super.func_189515_b(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.ropeTag = (NBTTagCompound)tag.func_74781_a("Rope");
    }

    public void func_145834_a(World worldIn) {
        NBTTagList pos;
        super.func_145834_a(worldIn);
        if (this.rope == null && !worldIn.field_72995_K && this.ropeTag != null && !this.ropeTag.func_82582_d() && (pos = (NBTTagList)this.ropeTag.func_74781_a("Pos")) != null) {
            this.rope = (EntityExtendingRope)AnvilChunkLoader.func_186054_a((NBTTagCompound)this.ropeTag, (World)this.func_145831_w(), (double)pos.func_150309_d(0), (double)pos.func_150309_d(1), (double)pos.func_150309_d(2), (boolean)true);
        }
    }
}

