/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.tile;

import betterwithmods.common.blocks.tile.TileBasicInventory;
import betterwithmods.util.InvUtils;
import betterwithmods.util.WorldUtils;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TileStake
extends TileBasicInventory {
    public BlockPos[] connections = new BlockPos[this.getInventorySize()];

    public static Optional<TileStake> getStake(@Nonnull World world, @Nonnull BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return Optional.ofNullable(tile instanceof TileStake ? (TileStake)tile : null);
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        this.connectStake(worldIn, pos, side.func_176734_d(), playerIn);
        return true;
    }

    @Override
    public int getInventorySize() {
        return 6;
    }

    public BlockPos findStake(World world, BlockPos first, EnumFacing direction) {
        BlockPos second = first;
        for (int i = 0; i < 64; ++i) {
            if (!TileStake.getStake(world, second = second.func_177972_a(direction)).isPresent()) continue;
            return second;
        }
        return null;
    }

    public boolean isConnected(EnumFacing facing) {
        return this.connections[facing.func_176745_a()] != null;
    }

    public ItemStack getItemFromDistance(BlockPos pos1, BlockPos pos2) {
        return new ItemStack(Items.field_151007_F, WorldUtils.getDistance(pos1, pos2));
    }

    public void setConnected(EnumFacing facing, BlockPos pos) {
        this.connections[facing.func_176745_a()] = pos;
        if (pos == null) {
            this.inventory.setStackInSlot(facing.func_176745_a(), ItemStack.field_190927_a);
        } else {
            this.inventory.setStackInSlot(facing.func_176745_a(), this.getItemFromDistance(this.func_174877_v(), pos));
        }
        this.func_70296_d();
    }

    public boolean connectStake(World world, BlockPos first, EnumFacing direction, EntityPlayer player) {
        BlockPos second = this.findStake(world, first, direction);
        if (first == null || second == null) {
            return false;
        }
        ItemStack string = this.getItemFromDistance(first, second);
        TileStake firstTile = TileStake.getStake(world, first).orElse(null);
        TileStake secondTile = TileStake.getStake(world, second).orElse(null);
        if (firstTile == null || secondTile == null) {
            return false;
        }
        if (!firstTile.isConnected(direction) && !secondTile.isConnected(direction)) {
            if (!InvUtils.usePlayerItemStrict(player, EnumFacing.UP, string, string.func_190916_E())) {
                return false;
            }
            firstTile.setConnected(direction, second);
            secondTile.setConnected(direction.func_176734_d(), first);
        }
        return false;
    }

    @Override
    public void onBreak() {
        for (int i = 0; i < this.connections.length; ++i) {
            TileStake stake;
            BlockPos second = this.connections[i];
            if (second == null || (stake = (TileStake)TileStake.getStake(this.field_145850_b, second).orElse(null)) == null) continue;
            stake.setConnected(EnumFacing.func_82600_a((int)i).func_176734_d(), null);
        }
        super.onBreak();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (this.connections[facing.func_176745_a()] == null) continue;
            tag.func_74772_a(this.getKey(facing), this.connections[facing.func_176745_a()].func_177986_g());
        }
        return super.func_189515_b(tag);
    }

    @Override
    public void func_145839_a(NBTTagCompound compound) {
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!compound.func_74764_b(this.getKey(facing))) continue;
            this.connections[facing.func_176745_a()] = BlockPos.func_177969_a((long)compound.func_74763_f(this.getKey(facing)));
        }
        super.func_145839_a(compound);
    }

    public String getKey(EnumFacing facing) {
        return "connected" + facing.name();
    }
}

