/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.tile.gen;

import betterwithmods.api.block.IMechanical;
import betterwithmods.api.capabilities.MechanicalCapability;
import betterwithmods.api.tile.IMechanicalPower;
import betterwithmods.common.BWSounds;
import betterwithmods.common.blocks.BlockMillGenerator;
import betterwithmods.common.blocks.tile.TileBasic;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class TileEntityMillGenerator
extends TileBasic
implements ITickable,
IMechanicalPower {
    public int radius;
    public byte runningState = 0;
    public float speed = 0.0f;
    public float runningSpeed = 0.4f;
    public int overpowerTime = 30;
    public byte dyeIndex = 0;
    public float currentRotation = 0.0f;
    public float previousRotation = 0.0f;
    protected byte waterMod = 1;
    protected EnumFacing facing = null;

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("RunningState")) {
            this.runningState = tag.func_74771_c("RunningState");
        }
        if (tag.func_74764_b("CurrentRotation")) {
            this.currentRotation = tag.func_74760_g("CurrentRotation");
        }
        if (tag.func_74764_b("RotationSpeed")) {
            this.previousRotation = tag.func_74760_g("RotationSpeed");
        }
        if (tag.func_74764_b("DyeIndex")) {
            this.dyeIndex = tag.func_74771_c("DyeIndex");
        }
        if (tag.func_74764_b("Facing")) {
            this.facing = EnumFacing.func_82600_a((int)tag.func_74771_c("Facing"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        t.func_74774_a("RunningState", this.runningState);
        t.func_74776_a("CurrentRotation", this.currentRotation);
        t.func_74776_a("RotationSpeed", this.previousRotation);
        if (this.facing != null) {
            t.func_74774_a("Facing", (byte)this.facing.ordinal());
        }
        return t;
    }

    public float getCurrentRotation() {
        return this.currentRotation;
    }

    public float getPrevRotation() {
        return this.previousRotation;
    }

    public void func_73660_a() {
        if (this.facing == null) {
            this.facing = ((BlockMillGenerator)this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c()).getAxleDirectionFromState(this.func_145831_w().func_180495_p(this.field_174879_c));
        }
        if (this.runningState != 0) {
            this.previousRotation = (this.runningState > 1 ? this.runningSpeed * 5.0f : this.runningSpeed) * (float)this.waterMod;
            this.currentRotation += (float)(this.runningState > 1 ? 5 : (int)this.runningState) * this.runningSpeed * (float)this.waterMod;
            if (this.func_145831_w().field_73012_v.nextInt(100) == 0) {
                this.func_145831_w().func_184133_a(null, this.field_174879_c, BWSounds.WOODCREAK, SoundCategory.BLOCKS, 0.75f, this.func_145831_w().field_73012_v.nextFloat() * 0.25f + 0.25f);
            }
        }
        if (this.currentRotation >= 360.0f) {
            this.currentRotation -= 360.0f;
        }
        if (this.func_145831_w().func_82737_E() % 20L == 0L && this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockMillGenerator) {
            this.verifyIntegrity();
            this.updateSpeed();
            if (this.runningState == 2 && this.overpowerTime < 1) {
                this.overpower();
            } else if (this.runningState != 2 && this.overpowerTime != 30) {
                this.overpowerTime = 30;
            } else if (this.runningState == 2 && this.overpowerTime > 0) {
                --this.overpowerTime;
            }
        }
    }

    public EnumFacing getOrientation() {
        return this.facing;
    }

    public void setOrientation(EnumFacing facing) {
        if (facing != null) {
            this.facing = facing.func_176743_c() != EnumFacing.AxisDirection.POSITIVE ? facing.func_176734_d() : facing;
        }
    }

    public abstract void updateSpeed();

    public abstract void overpower();

    public abstract boolean isValid();

    public byte getRunningState() {
        return this.runningState;
    }

    public void setRunningState(int i) {
        boolean oldRun;
        boolean newRun = oldRun = ((Boolean)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockMillGenerator.ISACTIVE)).booleanValue();
        this.runningState = (byte)i;
        if (this.runningState > 0) {
            newRun = true;
        } else if (this.runningState == 0) {
            newRun = false;
        }
        if (newRun != oldRun) {
            this.func_145831_w().func_175656_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockMillGenerator.ISACTIVE, (Comparable)Boolean.valueOf(newRun)));
            this.func_145831_w().func_180497_b(this.field_174879_c, this.func_145838_q(), this.func_145838_q().func_149738_a(this.func_145831_w()), 5);
        }
    }

    public boolean verifyIntegrity() {
        return true;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return super.func_145833_n() * 3.0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == MechanicalCapability.MECHANICAL_POWER || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == MechanicalCapability.MECHANICAL_POWER) {
            return (T)MechanicalCapability.MECHANICAL_POWER.cast((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public int getMechanicalOutput(EnumFacing facing) {
        if (this.func_145838_q() instanceof IMechanical && ((IMechanical)this.func_145838_q()).getMechPowerLevelToFacing(this.func_145831_w(), this.field_174879_c, facing) > 0) {
            return 20;
        }
        return 0;
    }

    @Override
    public int getMechanicalInput(EnumFacing facing) {
        return 0;
    }

    @Override
    public int getMaximumInput(EnumFacing facing) {
        return 0;
    }
}

