/*
 * Decompiled with CFR 0.152.
 */
package betterwithmods.common.blocks.tile.gen;

import betterwithmods.api.block.IAxle;
import betterwithmods.api.block.IMechanicalBlock;
import betterwithmods.common.BWMBlocks;
import betterwithmods.common.BWMItems;
import betterwithmods.common.blocks.BlockAxle;
import betterwithmods.common.blocks.BlockWindmill;
import betterwithmods.common.blocks.tile.gen.IColor;
import betterwithmods.common.blocks.tile.gen.TileEntityMillGenerator;
import betterwithmods.util.InvUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DimensionType;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityWindmillVertical
extends TileEntityMillGenerator
implements IColor {
    public int[] bladeMeta = new int[]{0, 0, 0, 0, 0, 0, 0, 0};

    public int getBladeColor(int blade) {
        return this.bladeMeta[blade];
    }

    @Override
    public int getMinimumInput(EnumFacing facing) {
        return 0;
    }

    @Override
    public int getColorFromBlade(int blade) {
        return this.bladeMeta[blade];
    }

    @Override
    public boolean dyeBlade(int dyeColor) {
        boolean dyed = false;
        if (this.bladeMeta[this.dyeIndex] != dyeColor) {
            this.bladeMeta[this.dyeIndex] = dyeColor;
            dyed = true;
            IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
            this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
            this.func_70296_d();
        }
        this.dyeIndex = (byte)(this.dyeIndex + 1);
        if (this.dyeIndex > 7) {
            this.dyeIndex = 0;
        }
        return dyed;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        for (int i = 0; i < 8; ++i) {
            if (!tag.func_74764_b("Color_" + i)) continue;
            this.bladeMeta[i] = tag.func_74762_e("Color_" + i);
        }
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        NBTTagCompound t = super.func_189515_b(tag);
        for (int i = 0; i < 8; ++i) {
            t.func_74768_a("Color_" + i, this.bladeMeta[i]);
        }
        t.func_74774_a("DyeIndex", this.dyeIndex);
        return t;
    }

    @Override
    public boolean isValid() {
        boolean valid = true;
        if (this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() != null && this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() == BWMBlocks.WINDMILL_BLOCK) {
            for (int i = -3; i < 4 && (i == 0 || (valid = this.isSlaveValid(i))); ++i) {
            }
        }
        return valid;
    }

    public boolean isSlaveValid(int offset) {
        boolean notBlocked = true;
        int airCounter = 0;
        for (int x = -4; x < 5; ++x) {
            for (int z = -4; z < 5; ++z) {
                BlockPos offPos = this.field_174879_c.func_177982_a(x, offset, z);
                if (x == 0 && z == 0 && this.func_145831_w().func_180495_p(offPos).func_177230_c() instanceof IAxle && ((IAxle)this.func_145831_w().func_180495_p(offPos).func_177230_c()).getAxisAlignment((IBlockAccess)this.func_145831_w(), offPos) == 0) continue;
                if (this.func_145831_w().field_73011_w.func_186058_p() == DimensionType.NETHER) {
                    notBlocked = this.func_145831_w().func_175623_d(offPos);
                } else if (this.func_145831_w().field_73011_w.func_186058_p() != DimensionType.NETHER) {
                    notBlocked = this.func_145831_w().func_175623_d(offPos);
                    if (this.func_145831_w().func_175710_j(offPos)) {
                        ++airCounter;
                    }
                }
                if (!notBlocked) break;
            }
            if (!notBlocked) break;
        }
        if (this.func_145831_w().field_73011_w.func_186058_p() != DimensionType.NETHER) {
            return notBlocked && airCounter > 25;
        }
        return notBlocked;
    }

    @Override
    public boolean verifyIntegrity() {
        boolean integrity = true;
        for (int offY = -3; offY < 4; ++offY) {
            BlockPos offset = this.field_174879_c.func_177982_a(0, offY, 0);
            if (offY == 0) continue;
            boolean bl = integrity = this.func_145831_w().func_180495_p(offset).func_177230_c() instanceof IAxle && ((IAxle)this.func_145831_w().func_180495_p(offset).func_177230_c()).getAxisAlignment((IBlockAccess)this.func_145831_w(), offset) == 0;
            if (integrity) continue;
            this.invalidateWindmill();
            break;
        }
        return integrity;
    }

    private void invalidateWindmill() {
        this.func_145831_w().func_175656_a(this.field_174879_c, BWMBlocks.WINDMILL_BLOCK.func_176223_P());
        for (int i = -3; i < 4; ++i) {
            BlockPos pos = this.field_174879_c.func_177982_a(0, i, 0);
            if (!(this.func_145831_w().func_180495_p(pos).func_177230_c() instanceof BlockAxle)) continue;
            this.func_145831_w().func_175656_a(pos, BWMBlocks.AXLE.func_176223_P());
        }
        if (!this.func_145831_w().field_72995_K) {
            InvUtils.ejectStackWithOffset(this.func_145831_w(), this.field_174879_c, new ItemStack(BWMItems.WINDMILL, 1, 2));
        }
        this.func_145831_w().func_175656_a(this.field_174879_c, BWMBlocks.AXLE.func_176223_P());
    }

    @Override
    public void overpower() {
        if (this.func_145838_q() instanceof BlockWindmill) {
            EnumFacing.Axis axis = (EnumFacing.Axis)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((IProperty)BlockWindmill.AXIS);
            for (EnumFacing dir : EnumFacing.field_82609_l) {
                if (dir.func_176740_k() != axis) continue;
                BlockPos offset = this.field_174879_c.func_177972_a(dir);
                Block axle = this.func_145831_w().func_180495_p(offset).func_177230_c();
                if (axle instanceof BlockAxle) {
                    ((BlockAxle)axle).overpower(this.func_145831_w(), offset);
                    continue;
                }
                if (!(axle instanceof IMechanicalBlock) || !((IMechanicalBlock)axle).canInputPowerToSide((IBlockAccess)this.func_145831_w(), offset, dir.func_176734_d())) continue;
                ((IMechanicalBlock)axle).overpower(this.func_145831_w(), offset);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onDataPacket(NetworkManager mgr, SPacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
        IBlockState state = this.func_145831_w().func_180495_p(this.field_174879_c);
        this.func_145831_w().func_184138_a(this.field_174879_c, state, state, 3);
    }

    @Override
    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Override
    public void updateSpeed() {
        int speed = 0;
        if (this.isValid() && !this.isGalacticraftDimension() && this.isNotOtherDimension()) {
            speed = (this.func_145831_w().func_72896_J() || this.func_145831_w().func_72911_I()) && this.func_145831_w().field_73011_w.func_186058_p() != DimensionType.NETHER ? 2 : 1;
        }
        if (speed != this.runningState && this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockWindmill) {
            this.setRunningState(speed);
            this.func_145831_w().func_175656_a(this.field_174879_c, this.func_145831_w().func_180495_p(this.field_174879_c).func_177226_a((IProperty)BlockWindmill.ISACTIVE, (Comparable)Boolean.valueOf(speed > 0)));
            this.func_145831_w().func_180497_b(this.field_174879_c, this.func_145838_q(), this.func_145838_q().func_149738_a(this.func_145831_w()), 5);
        }
    }

    public boolean isNotOtherDimension() {
        return this.func_145831_w().field_73011_w.func_186058_p() != DimensionType.THE_END;
    }

    public boolean isGalacticraftDimension() {
        boolean isDimension = false;
        if (Loader.isModLoaded((String)"GalacticraftCore")) {
            isDimension = false;
        }
        return isDimension;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        if (this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() != null && this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockWindmill) {
            return new AxisAlignedBB((double)(x - 4), (double)(y - 4), (double)(z - 4), (double)(x + 4), (double)(y + 4), (double)(z + 4));
        }
        return super.getRenderBoundingBox();
    }
}

